/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.api.company;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.enums.company.CompanySizeEnum;
import cn.smarthse.modules.health.vo.outdata.company.CompanyInfo;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.web.controller.ControllerSupport;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class CompanyApiController
extends ControllerSupport {
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService paramProvideService;

    @PostMapping(value={"/importdeclarecompanyinfo"})
    @ResponseBody
    public ResponseData<String> importCheckPlan(@RequestBody CompanyInfo param) {
        this.logger.info("\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u5bfc\u5165:{}", (Object)JSON.toJSONString((Object)param));
        ResponseData data = new ResponseData();
        CompanySuperviseModel company = new CompanySuperviseModel();
        BeanUtils.copyProperties((Object)param, (Object)company);
        this.convertName2Code(param, company);
        this.companyProvideBySuperviseService.saveImportCompany(company, null);
        return data;
    }

    private void convertName2Code(CompanyInfo param, CompanySuperviseModel company) {
        Byte scale;
        SysParamModel registerModel;
        List industryList;
        String companyTypeName = param.getCompanyTypeName();
        String industryCategoryName = param.getIndustryCategoryName();
        String registerTypeName = param.getRegisterTypeName();
        String occupationalRiskClassifyName = param.getOccupationalRiskClassifyName();
        String scaleName = param.getScaleName();
        if ("\u5916\u5305\u4f01\u4e1a".equals(companyTypeName)) {
            company.setCompanyType(Integer.valueOf(2));
        } else {
            company.setCompanyType(Integer.valueOf(1));
        }
        if (StringUtils.isNotBlank((CharSequence)industryCategoryName) && CollectionUtils.isNotEmpty((Collection)(industryList = this.industryProvideService.getIndustryListByNames(industryCategoryName)))) {
            IndustryModel industryModel = (IndustryModel)industryList.get(0);
            company.setIndustryCategory(industryModel.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)registerTypeName) && (registerModel = this.paramProvideService.getSysParamByName(registerTypeName, null, SysParamGroupEnum.register_type)) != null) {
            company.setRegisterType(registerModel.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)occupationalRiskClassifyName)) {
            Integer occupationalRiskClassify = CompanyOccTypeEnum.getCodeByName((String)occupationalRiskClassifyName);
            company.setOccupationalRiskClassify(occupationalRiskClassify);
        }
        if (StringUtils.isNotBlank((CharSequence)scaleName) && (scale = CompanySizeEnum.getCodeByName((String)scaleName)) != null) {
            company.setScale(scale.toString());
        }
    }
}

