/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.api;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.util.FileUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.work.check.vo.CheckReportDataVo;
import cn.smarthse.modules.health.entity.work.check.vo.CheckReportFileVo;
import cn.smarthse.modules.health.entity.work.check.vo.CheckReportTipVo;
import cn.smarthse.modules.health.entity.work.check.vo.CustomizeValidUtils;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.check.IProjectCheckService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.thirdOrganization.service.sys.ISysAreaService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/projectCheck"})
public class ProjectCheckApiController
extends ControllerSupport {
    @DubboReference
    IProjectCheckService projectCheckService;
    @DubboReference
    ISysAreaService sysAreaService;
    @DubboReference
    IThirdOrganizationService thirdOrganizationService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired(required=false)
    protected OssClientBean ossClientBean;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService sysFileProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;

    @ResponseBody
    @RequestMapping(value={"importProjectCheck"}, method={RequestMethod.POST})
    public ResponseData<List<CheckReportTipVo>> importProjectCheck(HttpServletRequest request, @RequestBody CheckReportDataVo data) throws Exception {
        List errMsgVos = CustomizeValidUtils.getValidMessages((Object)data, (boolean)true);
        if (errMsgVos.size() == 0) {
            AreaModel am;
            int count = this.projectCheckService.getCheckCountByNo(data.getProjNo());
            if (count > 0) {
                data.setIsSameProjNo(Boolean.valueOf(true));
            }
            CompanyBaseInfoModel cpm = null;
            List cpms = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByUnitCodeExcludeDelete(Collections.singletonList(data.getClientCode()));
            if (cpms != null) {
                cpm = (CompanyBaseInfoModel)cpms.stream().filter(s -> Integer.valueOf(data.getClientType().intValue()).equals(s.getCompanyType())).findFirst().orElse(new CompanySuperviseModel());
            }
            Long clientType = cpm.getCompanyType() == null ? 0L : cpm.getCompanyType().longValue();
            if (clientType.longValue() == data.getClientType().longValue()) {
                data.setIsExitClientCode(Boolean.valueOf(true));
            } else {
                data.setIsExitClientCode(Boolean.valueOf(false));
            }
            data.setCid(cpm.getId());
            data.setCompanyName(cpm.getName());
            ThirdOrganization checkOrg = this.thirdOrganizationService.getByName(data.getCheckOrgName().trim());
            if (checkOrg == null) {
                data.setIsExitCheckOrg(Boolean.valueOf(false));
            } else {
                data.setIsExitCheckOrg(Boolean.valueOf(true));
                data.setHospital(checkOrg.getId());
                data.setCheckOrgName(checkOrg.getName());
            }
            if (StringUtils.isNotEmpty((String)data.getCompanyAreaNames()) && (am = this.sysAreaProvideService.getAreaByName(data.getCompanyAreaNames())) != null) {
                data.setCompanyAreaId(am.getId());
            }
            errMsgVos = CustomizeValidUtils.getValidMessages((Object)data, (boolean)false);
        }
        ResponseData responseData = new ResponseData();
        if (errMsgVos.size() == 0) {
            List checkReportFiles = data.getCheckReportFiles();
            for (CheckReportFileVo vo : checkReportFiles) {
                errMsgVos.addAll(CustomizeValidUtils.getValidMessages((Object)vo, (boolean)false));
            }
            List otherFiles = data.getOtherFiles();
            if (otherFiles != null && otherFiles.size() > 0) {
                for (CheckReportFileVo vo : otherFiles) {
                    errMsgVos.addAll(CustomizeValidUtils.getValidMessages((Object)vo, (boolean)false));
                }
            }
            data.getCheckDatas().forEach(s -> s.setClientType(data.getClientType()));
            for (CheckReportFileVo vo : data.getCheckDatas()) {
                errMsgVos.addAll(CustomizeValidUtils.getValidMessages((Object)vo, (boolean)false));
            }
            if (errMsgVos.size() == 0) {
                data.setCheckReportFileIds(this.getSysFile(data.getCheckReportFiles()));
                data.setOtherFileIds(this.getSysFile(data.getOtherFiles()));
                for (CheckReportFileVo vo : data.getCheckDatas()) {
                    vo.setCid(data.getCid());
                    if (vo.getClientType() == 1L) {
                        vo.setStaffCid(data.getCid());
                        continue;
                    }
                    CompanyBaseInfoModel cpm = null;
                    List cpms = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByUnitCodeExcludeDelete(Collections.singletonList(vo.getCompanyCode()));
                    if (cpm != null) {
                        cpm = (CompanyBaseInfoModel)cpms.stream().filter(s -> Integer.valueOf(1).equals(s.getCompanyType())).findFirst().orElse(new CompanySuperviseModel());
                    }
                    vo.setStaffCid(cpm.getId());
                }
                this.projectCheckService.addCheckReportDataVo(data);
            } else {
                responseData.setState(ResponseStateEnum.fail);
            }
        } else {
            responseData.setState(ResponseStateEnum.fail);
        }
        responseData.setResult((Object)errMsgVos);
        return responseData;
    }

    private String getSysFile(List<CheckReportFileVo> fileParamList) throws IOException {
        if (fileParamList == null || fileParamList.isEmpty()) {
            return "";
        }
        StringBuilder ids = new StringBuilder();
        for (CheckReportFileVo fileParam : fileParamList) {
            File file = FileUtil.getNetUrl((String)fileParam.getFileUrl());
            ids.append(this.uploadFile(file, "api/check", fileParam.getFileName()).getId()).append(",");
        }
        return ids.substring(0, ids.length() - 1);
    }

    private SysFileModel uploadFile(File obj, String ossPath, String fileName) throws IOException {
        SysFileModel file = new SysFileModel();
        String[] arr = fileName.split("\\=");
        String oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + "." + arr[arr.length - 1], obj, ossPath, fileName, null);
        file.setFileName(fileName);
        file.setResource(Integer.valueOf(FileResourceEnum.companyHealth_07.getValue()));
        file.setFileSize(FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)obj)));
        if (fileName.contains(".")) {
            file.setFileExt(fileName.substring(fileName.lastIndexOf(".") + 1));
        }
        file.setFileHash("" + FileUtils.checksumCRC32((File)obj));
        file.setOssUrl(oss);
        file.setDescription("");
        file.setCid(UserUtils.getLoginStaffCompanyId());
        file = this.sysFileProvideService.addSysFile(file, Long.valueOf(0L));
        return file;
    }
}

