/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.UserUtils;
import com.google.code.kaptcha.Producer;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.web.util.WebUtils;
import org.crazycake.shiro.RedisSessionDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"login/yc"})
public class YcLoginController
extends ControllerSupport {
    @Autowired
    Producer captchaProducer = null;
    @Value(value="${platform.login.url}")
    protected String platformLoginUrl;
    @Value(value="${superviseLoginUrl}")
    protected String superviseLoginUrl;
    @Autowired
    private RedisSessionDAO redisSessionDAO;
    private static final String keyPrefix = "shiro:session:smarthse:";
    @Autowired
    private RedisTemplate redisTemplate;

    @GetMapping
    public String login(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u8d8a\u57ce\u533a\u4f01\u4e1a\u7aef\u767b\u5f55\u9875");
        Subject subject = UserUtils.getSubject();
        if (subject.isAuthenticated()) {
            subject.logout();
        }
        model.addAttribute("platformLoginUrl", (Object)(this.platformLoginUrl + "/yc"));
        model.addAttribute("superviseLoginUrl", (Object)(this.superviseLoginUrl + "/yc"));
        return "/views/login/ycMicrocom/index";
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public ResponseData<String> ajax_login(HttpServletRequest request, HttpServletResponse response) {
        ResponseData r = new ResponseData();
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            r.setState(ResponseStateEnum.success);
            r.setResult((Object)this.adminPath);
            return r;
        }
        String username = WebUtils.getCleanParam((ServletRequest)request, (String)"username");
        boolean rememberMe = WebUtils.isTrue((ServletRequest)request, (String)"rememberMe");
        String exception = (String)request.getAttribute("shiroLoginFailure");
        String message = (String)request.getAttribute("message");
        if (exception.equals("org.apache.shiro.authc.ExcessiveAttemptsException")) {
            message = "\u7981\u6b62\u767b\u5f55\uff0c\u767b\u5f55\u8d85\u8fc7\u8bbe\u5b9a\u6b21\u6570!";
        } else if (exception.equals("org.apache.shiro.authc.LockedAccountException")) {
            message = "\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef5\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7b49\u5f8530\u5206\u949f\u518d\u5c1d\u8bd5\u767b\u5f55\uff0c\u5982\u6709\u7591\u95ee\u53ef\u8054\u7cfb\u5ba2\u670d\uff1a0571-89978771/89978775\u3002";
        } else if (StringUtils.isBlank((CharSequence)message) || StringUtils.equals((CharSequence)message, (CharSequence)"null")) {
            message = "\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.";
        }
        r.setState(ResponseStateEnum.fail);
        r.setContent(message);
        return r;
    }

    @RequestMapping(value={"supervise"}, method={RequestMethod.GET})
    public String superviseLogin(HttpServletRequest request, HttpServletResponse response, Model model) {
        Subject subject = UserUtils.getSubject();
        if (subject.isAuthenticated()) {
            subject.logout();
        }
        this.logger.info("\u4f01\u4e1a\u7aef\u767b\u5f55\u9875");
        model.addAttribute("platformLoginUrl", (Object)(this.platformLoginUrl + "/yc"));
        model.addAttribute("superviseLoginUrl", (Object)(this.superviseLoginUrl + "/yc"));
        return "/views/login/ycMicrocom/login";
    }

    @RequestMapping(value={"logout"}, method={RequestMethod.GET})
    public String logout(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u767b\u5f55\u9875\uff1a\uff1a{}", (Object)this.adminPath);
        Subject subject = UserUtils.getSubject();
        if (subject.isAuthenticated()) {
            subject.logout();
        }
        return "redirect:/login/yc";
    }

    @RequestMapping(value={"logoutAll"}, method={RequestMethod.GET})
    public String logoutAll(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u767b\u5f55\u9875\uff1a\uff1a{}", (Object)this.adminPath);
        Subject subject = UserUtils.getSubject();
        String username = null;
        if (subject.isAuthenticated()) {
            username = UserUtils.getCurrentUser().getUsername();
            this.kickOutUserByScan(username);
            subject.logout();
        }
        return "redirect:/login/yc";
    }

    public Integer kickOutUserByScan(String username) {
        String zlwqKeyPrefix = "zlwq:shiro:session:smarthse:";
        Long startTime = System.currentTimeMillis();
        Integer deletedCount = 0;
        Integer scannedCount = 0;
        if (StringUtils.isEmpty((CharSequence)username)) {
            return 0;
        }
        try {
            ScanOptions scanOptions = ScanOptions.scanOptions().match(zlwqKeyPrefix + "*").count(100L).build();
            Cursor cursor = this.redisTemplate.scan(scanOptions);
            while (cursor.hasNext()) {
                String redisKey = (String)cursor.next();
                Integer n = scannedCount;
                scannedCount = scannedCount + 1;
                String sessionId = null;
                if (redisKey.startsWith(zlwqKeyPrefix)) {
                    sessionId = redisKey.substring(zlwqKeyPrefix.length());
                }
                if (sessionId == null) continue;
                if (this.isSessionBelongsToUser(sessionId, username).booleanValue()) {
                    this.redisTemplate.delete((Object)redisKey);
                    Integer n2 = deletedCount;
                    deletedCount = deletedCount + 1;
                }
                if (scannedCount % 100 == 0) {
                    this.logger.debug("\u5df2\u626b\u63cf {} \u4e2a\u4f1a\u8bdd\uff0c\u5220\u9664 {} \u4e2a", (Object)scannedCount, (Object)deletedCount);
                }
                if (System.currentTimeMillis() - startTime <= 10000L) continue;
                this.logger.error("SCAN\u64cd\u4f5c\u8d85\u65f6\uff0c\u5df2\u626b\u63cf {} \u4e2a", (Object)scannedCount);
                break;
            }
            cursor.close();
        }
        catch (Exception e) {
            this.logger.error("SCAN\u5904\u7406\u5931\u8d25{}", (Throwable)e);
        }
        long costTime = System.currentTimeMillis() - startTime;
        this.logger.info("SCAN\u8e22\u51fa\u5b8c\u6210\uff1a\u7528\u6237 {}\uff0c\u626b\u63cf {} \u4e2a\uff0c\u5220\u9664 {} \u4e2a\uff0c\u8017\u65f6 {}ms", new Object[]{username, scannedCount, deletedCount, costTime});
        return deletedCount;
    }

    private Boolean isSessionBelongsToUser(String sessionId, String username) {
        try {
            Session session = this.redisSessionDAO.readSession((Serializable)((Object)sessionId));
            if (session == null) {
                return false;
            }
            Object principal = session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
            if (principal == null) {
                return false;
            }
            String sessionUsername = this.extractUsernameSafely(principal);
            if (username.equals(sessionUsername)) {
                return true;
            }
            Object otherUsername = null;
            String suffix = "-hse";
            otherUsername = username.endsWith(suffix) ? username.substring(0, username.length() - suffix.length()) : username + suffix;
            return ((String)otherUsername).equals(sessionUsername);
        }
        catch (Exception e) {
            this.logger.warn("{}\u68c0\u67e5\u4f1a\u8bdd\u5931\u8d25: {}", (Object)sessionId, (Object)e);
            return false;
        }
    }

    private String extractUsernameSafely(Object principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof ShiroPrincipal) {
            return ((ShiroPrincipal)principal).getUsername();
        }
        return principal.toString();
    }
}

