/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.entity.base.company.grade.vo.CompanyGradeVoV3;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserParamVo;
import cn.smarthse.modules.health.enums.check.DiagnosedTypeEnum;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportHarmJudgeInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.modules.health.service.work.zjhome.IZjHomeWorkDataService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalOdService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.service.sys.ISysParamService;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.modules.health.vo.work.train.TrainPlanCountView;
import cn.smarthse.services.hfi.api.pojo.vo.CompanyCheckListVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.ICheckStatisticService;
import cn.smarthse.util.common.date.DateUtils;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.controller.HomeControllerHelper;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"${adminPath}/supervisehome"})
public class SuperviseHomeController
extends ControllerSupport {
    @Autowired
    private HomeControllerHelper helper;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService superviseService;
    @DubboReference
    ILiteArchiveService liteArchiveService;
    @DubboReference
    ITrainPlanService trainPlanService;
    @DubboReference
    IZjHomeWorkDataService zjHomeWorkDataService;
    @DubboReference
    private IOnlineDeviceService onlineDeviceService;
    @DubboReference
    ICheckResultService checkResultService;
    @DubboReference
    ISelfInspectionRiskAssessmentReportHarmJudgeInfoService selfInspectionRiskAssessmentReportHarmJudgeInfoService;
    @DubboReference
    IReformItemBasicService reformItemBasicService;
    @DubboReference
    ISysParamService sysParamService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @DubboReference
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    private ICheckStatisticService checkStatisticService;
    @DubboReference
    ISupervisePhcPhysicalOdService supervisePhcPhysicalOdService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService hseService;
    @DubboReference
    private IReformItemBasicService reformService;
    @DubboReference
    ICompanyGradeV3Service companyGradeV3Service;
    @DubboReference
    ICompanyGradeV3RecService gradeV3RecService;
    @DubboReference
    ICertificateStaffDetailService certificateStaffDetailService;

    @Deprecated
    @RequestMapping(method={RequestMethod.GET})
    public String page_loginIndex(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        model.addAttribute("isActualize", (Object)this.isActualize);
        long cid = UserUtils.getLoginStaffCompanyId();
        CompanySuperviseModel superviseModel = this.superviseService.getCompanyInfoById(Long.valueOf(cid));
        if (superviseModel != null && "\u6d59\u6c5f\u7701".equals(superviseModel.getProvinceName())) {
            model.addAttribute("isZj", (Object)"isZj");
        }
        model.addAttribute("company", (Object)superviseModel);
        CompanyGradeV3Rec companyGradeV3 = this.gradeV3RecService.getGradeRecByCid(Long.valueOf(cid));
        CompanyGradeVoV3 companyGradeVoV3 = new CompanyGradeVoV3();
        if (companyGradeV3 != null) {
            BeanUtils.copyProperties((Object)companyGradeV3, (Object)companyGradeVoV3);
        }
        this.setClassLow2Height(model, Optional.ofNullable(companyGradeVoV3.getRiskLevel()), "Riskclass");
        this.setClassLow2Height(model, Optional.ofNullable(companyGradeVoV3.getGrade()), "RiskClassifyclass");
        this.setClassLow2Height(model, Optional.ofNullable(companyGradeVoV3.getJudgeLevel()), "JudgeResultClass");
        model.addAttribute("info", (Object)companyGradeVoV3);
        model.addAttribute("occTypeClass", (Object)this.setClassOccType(companyGradeVoV3.getOccType()));
        int thisYear = DateUtils.getYear();
        int prevYear = thisYear - 1;
        model.addAttribute("thisYear", (Object)thisYear);
        model.addAttribute("prevYear", (Object)prevYear);
        Map<String, Integer> map = this.helper.evaluateCheckOverPointCount(cid, null);
        model.addAttribute("evaluateCheckOverPointCount", map);
        model.addAttribute("isHaveOnlineMonitoring", (Object)false);
        model.addAttribute("isHaveOnlineCamera", (Object)false);
        List deviceList = this.onlineDeviceService.getDeviceListInfoByCid(Long.valueOf(cid));
        if (CollectionUtils.isNotEmpty((Collection)deviceList)) {
            boolean isHaveOnlineMonitoring = deviceList.stream().anyMatch(d -> Objects.equals(d.getType(), (byte)1) || Objects.equals(d.getType(), (byte)2));
            boolean isHaveOnlineCamera = deviceList.stream().anyMatch(d -> Objects.equals(d.getType(), (byte)3));
            model.addAttribute("isHaveOnlineMonitoring", (Object)isHaveOnlineMonitoring);
            model.addAttribute("isHaveOnlineCamera", (Object)isHaveOnlineCamera);
        }
        model.addAttribute("jdnum", (Object)0);
        model.addAttribute("cfnum", (Object)0);
        return "/supervisehomeV313";
    }

    @RequestMapping(value={"occStaffPage"})
    public String occStaff(Model model) throws Exception {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = currentCompany.getId();
        int thisYear = DateUtils.getYear();
        model.addAttribute("thisYear", (Object)thisYear);
        String unifiedSocialCc = currentCompany.getUnifiedSocialCc();
        Map<String, Integer> map = this.helper.basePhyCheckCount(cid, unifiedSocialCc);
        model.addAttribute("data", map);
        JqGridParam p1 = new JqGridParam();
        p1.setRows(1);
        p1.setPage(1);
        PhcThirdOccupationalDiseaserParamVo vo = new PhcThirdOccupationalDiseaserParamVo();
        vo.setCid(cid);
        vo.setReportStatus(Byte.valueOf((byte)10));
        vo.setDiagnosedType(DiagnosedTypeEnum.appraisal.getCode());
        PageInfo pageInfo = this.supervisePhcPhysicalOdService.checkJdInfos(p1, vo);
        long total = pageInfo.getTotal();
        vo.setDiagnosedType(DiagnosedTypeEnum.diagnosed.getCode());
        pageInfo = this.supervisePhcPhysicalOdService.checkJdInfos(p1, vo);
        long total1 = pageInfo.getTotal();
        model.addAttribute("total", (Object)(total + total1));
        return "/homedataSupervise/occstaffV310";
    }

    @RequestMapping(value={"physicacheckPage"})
    public String physicacheckPage(Model model) throws Exception {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = currentCompany.getId();
        int thisYear = DateUtils.getYear();
        Date endTime = new Date(thisYear - 1900, 0, 1);
        model.addAttribute("endTime", (Object)endTime);
        model.addAttribute("thisYear", (Object)thisYear);
        String unifiedSocialCc = currentCompany.getUnifiedSocialCc();
        Map<String, Integer> map = this.helper.phyCheckCount(cid, unifiedSocialCc);
        model.addAttribute("data", map);
        Map<String, Integer> map2 = this.helper.phyCheckSuspectDiseaseCount(cid, unifiedSocialCc);
        model.addAttribute("data2", map2);
        Map<String, Integer> map3 = this.helper.phyCheckOCCount(cid, unifiedSocialCc);
        model.addAttribute("data3", map3);
        Map<String, Integer> map4 = this.helper.phyCheckReCheckCount(cid, unifiedSocialCc);
        model.addAttribute("data4", map4);
        return "homedataSupervise/physicacheckV310";
    }

    @GetMapping(value={"/monitorPage"})
    public String monitorPage(Model model) {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = currentCompany.getId();
        CompanyCheckListVo vo = this.checkStatisticService.countCheck(cid);
        model.addAttribute("currentYearCount", (Object)vo.getCurrentYearCount());
        model.addAttribute("currentPreCount", (Object)vo.getPreYearCount());
        model.addAttribute("thisYear", (Object)DateUtils.getYear());
        return "homedataSupervise/monitorV310";
    }

    @GetMapping(value={"/standardPointPage"})
    public String standardPointPage(Model model) {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = currentCompany.getId();
        int thisYear = DateUtils.getYear();
        int prevYear = thisYear - 1;
        List thislist = this.checkResultService.queryFactorTypeCheckPoint2(cid, Integer.valueOf(thisYear));
        List prelist = this.checkResultService.queryFactorTypeCheckPoint2(cid, Integer.valueOf(prevYear));
        model.addAttribute("thislist", (Object)thislist);
        model.addAttribute("prelist", (Object)prelist);
        return "homedataSupervise/standardpointV310";
    }

    @RequestMapping(value={"tranPage"})
    public String tranPage(Model model) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int thisYear = DateUtils.getYear();
        TrainPlanCountView view = this.trainPlanService.getTrainPlanCountView(cid);
        model.addAttribute("thisYear", (Object)thisYear);
        model.addAttribute("train", (Object)view);
        return "/homedataSupervise/tranV310";
    }

    @RequestMapping(value={"archivePage"})
    public String archivePage(Model model) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int thisYear = DateUtils.getYear();
        model.addAttribute("thisYear", (Object)thisYear);
        ZjArchiveCountView view = this.liteArchiveService.getZjArchiveCountViewByCid(cid);
        model.addAttribute("archive", (Object)view);
        ZjArchiveCountView lastview = this.liteArchiveService.getLastZjArchiveCountViewByCid(cid);
        model.addAttribute("lastArchive", (Object)lastview);
        return "/homedataSupervise/archiveV310";
    }

    @GetMapping(value={"/RectificationPage"})
    public String RectificationPage(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer finishedNum = this.reformItemBasicService.getFinishedNum(cid, Byte.valueOf((byte)3));
        Integer unFinishedNum = this.reformItemBasicService.getUnFinishedNum(cid, Byte.valueOf((byte)3));
        model.addAttribute("finishedNum", (Object)finishedNum);
        model.addAttribute("unFinishedNum", (Object)unFinishedNum);
        Integer OccuNum = this.reformItemBasicService.getFinishedNum(cid, Byte.valueOf((byte)4));
        Integer UnOccuNum = this.reformItemBasicService.getUnFinishedNum(cid, Byte.valueOf((byte)4));
        model.addAttribute("OccuNum", (Object)OccuNum);
        model.addAttribute("UnOccuNum", (Object)UnOccuNum);
        Integer SuspectNum = this.reformItemBasicService.getFinishedNum(cid, Byte.valueOf((byte)5));
        Integer UnSuspectNum = this.reformItemBasicService.getUnFinishedNum(cid, Byte.valueOf((byte)5));
        model.addAttribute("SuspectNum", (Object)SuspectNum);
        model.addAttribute("UnSuspectNum", (Object)UnSuspectNum);
        Integer reviewNum = this.reformItemBasicService.getFinishedNum(cid, Byte.valueOf((byte)6));
        Integer UnreviewNum = this.reformItemBasicService.getUnFinishedNum(cid, Byte.valueOf((byte)6));
        model.addAttribute("reviewNum", (Object)reviewNum);
        model.addAttribute("UnreviewNum", (Object)UnreviewNum);
        return "/homedataSupervise/rectificationV310";
    }

    private LocalDateTime calcCurrYearDate(LocalDateTime date1) {
        if (date1 != null) {
            int monthValue = date1.getMonthValue();
            int dayOfMonth = date1.getDayOfMonth();
            int year = LocalDate.now().getYear();
            LocalDateTime result = LocalDateTime.of(year, monthValue, dayOfMonth, 0, 0, 0);
            return result;
        }
        return null;
    }

    private LocalDateTime calcCurrYearDate(Date date1) {
        if (date1 != null) {
            LocalDateTime fromDate = DateUtils.getFromDate((Date)date1);
            return fromDate;
        }
        return null;
    }

    public Date formatStringDate(String time) {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        Date reformDate = null;
        try {
            reformDate = ft.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return reformDate;
    }

    public int isInYear(LocalDateTime org2, LocalDateTime org1) {
        int sum = 0;
        int year1 = org1.getYear();
        int year2 = org2.getYear();
        int month1 = org1.getMonthValue();
        int month2 = org2.getMonthValue();
        int day1 = org1.getDayOfMonth();
        int day2 = org2.getDayOfMonth();
        if (year1 - year2 > 1) {
            sum = sum + year1 - year2;
        } else {
            if (month1 > month2) {
                ++sum;
            }
            if (month1 < month2 && day1 < day2) {
                ++sum;
            }
        }
        return sum;
    }

    private String getClassesOccRisk(Integer occType) {
        String classes = "type-card-none";
        if (occType == null) {
            return classes;
        }
        switch (occType) {
            case 2: {
                return "type-card-success";
            }
            case 1: {
                return "type-card-primary";
            }
            case 0: {
                return "type-card-danger";
            }
        }
        return "type-card-none";
    }

    @RequestMapping(value={"workNotice"})
    public String keyworkPage(Model model) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List data = this.zjHomeWorkDataService.getSuperviseHomeDataWorkByCid(cid);
        model.addAttribute("homedataSupervise", (Object)data);
        return "/homedataSupervise/workNotice";
    }

    private void setLevelClass(Model model, Long riskLevel, String riskclass) {
        switch (riskLevel.intValue()) {
            case 1: {
                model.addAttribute(riskclass, (Object)"type-card-success");
                break;
            }
            case 2: {
                model.addAttribute(riskclass, (Object)"type-card-primary");
                break;
            }
            default: {
                model.addAttribute(riskclass, (Object)"type-card-danger");
            }
        }
    }

    private void setClassLow2Height(Model model, Optional<Integer> riskLevel, String riskclass) {
        if (riskLevel.isPresent()) {
            switch (riskLevel.get()) {
                case 1: {
                    model.addAttribute(riskclass, (Object)"type-card-success");
                    break;
                }
                case 2: {
                    model.addAttribute(riskclass, (Object)"type-card-warning");
                    break;
                }
                case 3: {
                    model.addAttribute(riskclass, (Object)"type-card-danger");
                    break;
                }
                default: {
                    model.addAttribute(riskclass, (Object)"type-card-none");
                    break;
                }
            }
        } else {
            model.addAttribute(riskclass, (Object)"type-card-none");
        }
    }

    private String setClassOccType(Integer occType) {
        String classes = "type-card-none";
        if (occType == null) {
            return classes;
        }
        switch (occType) {
            case 3: {
                return "type-card-primary";
            }
            case 2: {
                return "type-card-success";
            }
            case 0: {
                return "type-card-danger";
            }
        }
        return "type-card-none";
    }

    private void setClassHeight2Low(Model model, Optional<Integer> riskLevel, String riskclass) {
        if (riskLevel.isPresent()) {
            switch (riskLevel.get()) {
                case 1: {
                    model.addAttribute(riskclass, (Object)"type-card-danger");
                    break;
                }
                case 2: {
                    model.addAttribute(riskclass, (Object)"type-card-warning");
                    break;
                }
                case 3: {
                    model.addAttribute(riskclass, (Object)"type-card-success");
                    break;
                }
                default: {
                    model.addAttribute(riskclass, (Object)"type-card-none");
                    break;
                }
            }
        } else {
            model.addAttribute(riskclass, (Object)"type-card-none");
        }
    }
}

