/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.cas.CasCore;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.CookieUtil;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.common.util.MD5Utils;
import cn.smarthse.common.util.NoSpecalCrypUtil;
import cn.smarthse.common.util.RandomGenerator;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.encrypt.MD5;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyLoginModel;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderService;
import cn.smarthse.modules.health.entity.base.company.CompanySoft;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.sys.SecUserRole;
import cn.smarthse.modules.health.entity.sys.SysThirdUser;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.SysUserLogin;
import cn.smarthse.modules.health.entity.sys.vo.ResetPasswordVo;
import cn.smarthse.modules.health.entity.sys.vo.SysThirdUserVO;
import cn.smarthse.modules.health.enums.staff.StaffAddFromEnum;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanySoftService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.IParamService;
import cn.smarthse.modules.health.service.sys.ISecUserRoleService;
import cn.smarthse.modules.health.service.sys.ISysThirdUserService;
import cn.smarthse.modules.health.service.sys.ISysUserLoginService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.health.supervise.entity.companyChange.ResetBusinessLog;
import cn.smarthse.modules.health.supervise.service.company.IDcCompanyService;
import cn.smarthse.modules.health.supervise.service.companyChange.ICompanyBusinessRenewService;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.util.common.JsonUtils;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.security.shiro.ShiroUsernamePasswordToken;
import cn.smarthse.web.util.AppConfigHolder;
import cn.smarthse.web.util.LoginUtil;
import cn.smarthse.web.util.RSAUtils;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.code.kaptcha.Producer;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;
import org.redisson.api.RLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/login"})
public class LoginController
extends ControllerSupport {
    @DubboReference
    ICompanySoftService companySoftService;
    @DubboReference
    ISysUserLoginService userLoginService;
    @DubboReference
    ISysThirdUserService sysThirdUserService;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    ISysUserService userService;
    @DubboReference
    ICompanyService companyService;
    @Autowired
    Producer captchaProducer = null;
    @DubboReference
    IParamService paramService;
    @DubboReference(version="1.0.0")
    ISMSProviderService smsProviderService;
    @DubboReference(timeout=500000)
    ISMSProvideMasService smsProvideMasService;
    private static final String VCODECACHENAME = "vcodeCache";
    private static final String VCODECACHENAMERATE = "vcodeCacheRate";
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    ISecUserRoleService secUserRoleService;
    @DubboReference(timeout=5000000)
    IDcCompanyService dcCompanyService;
    @Value(value="${platform.login.url}")
    protected String platformLoginUrl;
    @Value(value="${superviseLoginUrl}")
    protected String superviseLoginUrl;
    @Value(value="${platform.login.hour}")
    protected Integer platformLoginHour;
    @Value(value="${bx.singleLogin.appId}")
    private String bxAppId;
    @Value(value="${bx.singleLogin.appSecret}")
    private String bxAppSecret;
    @Value(value="${bx.singleLogin.url}")
    private String bxLoginUrl;
    private static final Object PRESENT = new Object();
    private static final String vcode_template = "\u60a8\u6240\u5728\u4f01\u4e1a\u7684\u201c\u6d59\u91cc\u536b\u4f01\u2014\u7528\u4eba\u5355\u4f4d\u7aef\u201d\u8d26\u53f7\uff1a %s \uff0c\u6b63\u5728\u8fdb\u884c\u6062\u590d\u8425\u4e1a\u72b6\u6001\u7684\u64cd\u4f5c\uff0c\u9a8c\u8bc1\u7801\u662f\uff1a%s\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u52ff\u5c06\u9a8c\u8bc1\u7801\u6cc4\u6f0f\u7ed9\u4ed6\u4eba";
    @DubboReference(check=false)
    private ICompanyBusinessRenewService businessRenewService;
    @Autowired
    private RedisClient redisClient;
    @Value(value="${health_online_training_aes_key}")
    private String aesKey;

    @ResponseBody
    @RequestMapping(value={"isLoginOut"}, method={RequestMethod.POST})
    public Boolean isLoginOut() {
        return SecurityUtils.getSubject() == null ? true : !SecurityUtils.getSubject().isAuthenticated();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String page_loginIndex(HttpServletRequest request, HttpServletResponse response, Model model) {
        String areaId;
        this.logger.info("\u767b\u5f55\u9875\uff1a\uff1a{}", (Object)this.adminPath);
        this.clearSession();
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null && principal.getAreaId() != null && (areaId = principal.getAreaId().toString()).startsWith("11")) {
            this.clearSession();
            model.addAttribute("superviseLoginUrl", (Object)this.superviseLoginUrl);
            String usernameCookie = CookieUtil.getCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"account_cookie_username", (boolean)false);
            model.addAttribute("cookie_username", (Object)usernameCookie);
            return "login/bj/login";
        }
        String loginForm = this.getCookie(request, "loginFrom");
        if ("plat".equals(loginForm)) {
            return "redirect:" + this.platformLoginUrl;
        }
        String usernameCookie = CookieUtil.getCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"account_cookie_username", (boolean)false);
        model.addAttribute("cookie_username", (Object)usernameCookie);
        return this.getLoginPage();
    }

    @GetMapping(value={"/CompanyNameList"})
    @ResponseBody
    public ResponseData<List<CompanyLoginModel>> CompanyNameList(String unifiedSocialCc) {
        if (StringUtil.isEmpty((String)unifiedSocialCc)) {
            return new ResponseData();
        }
        List list = this.companyProvideBySuperviseService.getLoginModelByUnifiedSocialCc(unifiedSocialCc);
        ResponseData data = new ResponseData();
        data.setResult((Object)list);
        return data;
    }

    private void clearSession() {
        Subject subject = UserUtils.getSubject();
        if (subject.isAuthenticated()) {
            subject.logout();
        }
    }

    @RequestMapping(value={"smarthse"}, method={RequestMethod.GET})
    public String page_loginIndex2(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u767b\u5f55\u9875\uff1a\uff1a{}", (Object)this.adminPath);
        this.clearSession();
        String usernameCookie = CookieUtil.getCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"account_cookie_username", (boolean)false);
        model.addAttribute("cookie_username", (Object)usernameCookie);
        return this.getLoginPage();
    }

    @GetMapping(value={"/toChangeBind"})
    public String toChangeBind(HttpServletRequest request, HttpServletResponse response, Model model) {
        Subject subject = UserUtils.getSubject();
        if (!subject.isAuthenticated()) {
            return "redirect:/login";
        }
        return "views/businessComponents/aboutBindPhone/changeBindPhone/innerHtml";
    }

    @GetMapping(value={"/toApplyRebind"})
    public String toApplyRebind(HttpServletRequest request, HttpServletResponse response, Model model) {
        Subject subject = UserUtils.getSubject();
        if (!subject.isAuthenticated()) {
            return "redirect:/login";
        }
        return "views/businessComponents/aboutBindPhone/applyRebindPhone/innerHtml";
    }

    private String getLoginPage() {
        if ("true".equals(this.isActualize)) {
            String companyName = AppConfigHolder.getConfig("actualizeCompanyName");
            if ("huaDong".equals(companyName)) {
                return "/login/loginHuad";
            }
            if ("changXing".equals(companyName)) {
                return "/login/loginA";
            }
            return "commons/404";
        }
        return "forward:/login/supervise";
    }

    @RequestMapping(value={"supervise"}, method={RequestMethod.GET})
    public String superviseLogin(HttpServletRequest request, HttpServletResponse response, Model model) {
        String areaId;
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null && principal.getAreaId() != null && (areaId = principal.getAreaId().toString()).startsWith("11")) {
            this.clearSession();
            model.addAttribute("superviseLoginUrl", (Object)this.superviseLoginUrl);
            String usernameCookie = CookieUtil.getCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"account_cookie_username", (boolean)false);
            model.addAttribute("cookie_username", (Object)usernameCookie);
            return "login/bj/login";
        }
        this.clearSession();
        this.logger.info("\u4f01\u4e1a\u7aef\u767b\u5f55\u9875");
        model.addAttribute("superviseLoginUrl", (Object)this.superviseLoginUrl);
        if ("true".equals(this.isZjProj)) {
            return "/views/login/general/index";
        }
        return "/login/supervise";
    }

    @RequestMapping(value={"superviseJs"}, method={RequestMethod.GET})
    public String jsSuperviseLogin(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.clearSession();
        this.logger.info("\u5609\u5584\u76d1\u7ba1\u4f01\u4e1a\u7aef\u767b\u5f55\u9875\uff1a\uff1a{}", (Object)this.adminPath);
        model.addAttribute("superviseLoginUrl", (Object)this.superviseLoginUrl);
        return "/login/loginJiashan";
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public ResponseData<String> ajax_login(HttpServletRequest request, HttpServletResponse response) {
        ResponseData r = new ResponseData();
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            r.setState(ResponseStateEnum.success);
            r.setResult((Object)this.adminPath);
            return r;
        }
        String username = WebUtils.getCleanParam((ServletRequest)request, (String)"username");
        boolean rememberMe = WebUtils.isTrue((ServletRequest)request, (String)"rememberMe");
        String exception = (String)request.getAttribute("shiroLoginFailure");
        String message = (String)request.getAttribute("message");
        if (exception.equals("org.apache.shiro.authc.ExcessiveAttemptsException")) {
            message = "\u7981\u6b62\u767b\u5f55\uff0c\u767b\u5f55\u8d85\u8fc7\u8bbe\u5b9a\u6b21\u6570!";
        } else if (exception.equals("org.apache.shiro.authc.LockedAccountException")) {
            message = "\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef5\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7b49\u5f8530\u5206\u949f\u518d\u5c1d\u8bd5\u767b\u5f55\uff0c\u5982\u6709\u7591\u95ee\u53ef\u8054\u7cfb\u5ba2\u670d\uff1a0571-89978771/89978775\u3002";
        } else if (StringUtils.isBlank((CharSequence)message) || StringUtils.equals((CharSequence)message, (CharSequence)"null")) {
            message = "\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.";
        }
        r.setState(ResponseStateEnum.fail);
        r.setContent(message);
        return r;
    }

    @RequestMapping(value={"cas"}, method={RequestMethod.GET})
    public String caslogin(String username, String sign, String token, String time, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        this.logger.info("[\u804c\u4e1a\u536b\u751f]-CAS-\u5e73\u53f0CAS-username={}, token={}", (Object)username, (Object)token);
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            Object valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? (String)valueStr + values[i] : (String)valueStr + values[i] + ",";
            }
            params.put(name, (String)valueStr);
            this.logger.info(name + "=" + (String)valueStr);
        }
        SysUserLogin userLogin = this.userLoginService.getByToken(token);
        if (userLogin == null) {
            model.put((Object)"cas-message", (Object)"token\u5f02\u5e38");
            this.logger.info("[token\u5f02\u5e38]:" + token);
            return "commons/403";
        }
        Long cid = userLogin.getCid();
        CompanySoft csoft = this.companySoftService.getByCId(cid);
        if (csoft == null) {
            this.logger.info("[\u65e0\u4f01\u4e1a\u8f6f\u4ef6!]:" + cid);
            model.put((Object)"cas-message", (Object)"\u65e0\u4f01\u4e1a\u8f6f\u4ef6!");
            return "commons/403";
        }
        Long platformCid = csoft.getPlatformCid();
        this.logger.info("[\u9a8c\u8bc1\u53c2\u6570\uff1a]:" + String.valueOf(params));
        if (CasCore.verifySign(params, (String)String.valueOf(cid))) {
            SysUser user = UserUtils.getSysUserById(userLogin.getUserId());
            Subject subject = SecurityUtils.getSubject();
            ShiroUsernamePasswordToken uptoken = null;
            uptoken = new ShiroUsernamePasswordToken(0, UserSystemWideEnum.ZLWQ_COMPANY.getCode());
            uptoken.setUsername(user.getUsername());
            uptoken.setUserId(user.getId());
            try {
                subject.login((AuthenticationToken)uptoken);
                this.setLoginFrom("plat", response);
                return "redirect:/home";
            }
            catch (Exception re) {
                re.printStackTrace();
            }
        }
        this.logger.info("[\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25!]:" + cid);
        return "commons/403";
    }

    private void setLoginFrom(String loginFrom, HttpServletResponse response) {
        Cookie hit = new Cookie("loginFrom", loginFrom);
        hit.setMaxAge(this.platformLoginHour * 60 * 60);
        response.addCookie(hit);
    }

    private String getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookieName == null || cookieName.equals("")) {
            return null;
        }
        for (Cookie c : cookies) {
            if (!c.getName().equals(cookieName)) continue;
            return c.getValue();
        }
        return null;
    }

    @RequestMapping(value={"third"}, method={RequestMethod.GET})
    public String thirdLogin(SysThirdUserVO thirdUserVO, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        this.logger.info("[\u804c\u4e1a\u536b\u751f]-thirdLogin-\u5e73\u53f0:" + thirdUserVO.toString());
        if (StringUtils.isEmpty((CharSequence)thirdUserVO.getUsername())) {
            model.put((Object)"thirdLoginMessage", (Object)"\u7f3a\u5c11\u7528\u6237\u540d");
            this.logger.info("[\u7f3a\u5c11\u7528\u6237\u540d\u5f02\u5e38]");
            return "commons/401";
        }
        if (StringUtils.isEmpty((CharSequence)thirdUserVO.getCompanyName())) {
            model.put((Object)"thirdLoginMessage", (Object)"\u7f3a\u5c11\u4f01\u4e1a\u540d\u79f0");
            this.logger.info("[\u7f3a\u5c11\u4f01\u4e1a\u540d\u79f0\u5f02\u5e38]");
            return "commons/401";
        }
        if (StringUtils.isEmpty((CharSequence)thirdUserVO.getWorkNo())) {
            model.put((Object)"thirdLoginMessage", (Object)"\u7f3a\u5c11\u5de5\u53f7");
            this.logger.info("[\u7f3a\u5c11\u5de5\u53f7\u5f02\u5e38]");
            return "commons/401";
        }
        Company company = this.companyService.getByName(thirdUserVO.getCompanyName(), this.isActualize);
        if (company == null || company.getId() == null) {
            model.put((Object)"thirdLoginMessage", (Object)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u5b58\u5728");
            this.logger.info("[\u4f01\u4e1a\u540d\u79f0\u5f02\u5e38]:" + thirdUserVO.getCompanyName());
            return "commons/401";
        }
        Long cid = company.getId();
        SysThirdUser thirdUser = this.sysThirdUserService.getByUsername(cid, thirdUserVO.getUsername());
        if (thirdUser == null) {
            thirdUser = this.sysThirdUserService.addThirdUser(cid, thirdUserVO);
        }
        SysUser user = UserUtils.getSysUserById(thirdUser.getSysUserId());
        Subject subject = SecurityUtils.getSubject();
        ShiroUsernamePasswordToken uptoken = null;
        uptoken = new ShiroUsernamePasswordToken(0, UserSystemWideEnum.ZLWQ_COMPANY.getCode());
        uptoken.setUsername(user.getUsername());
        uptoken.setUserId(thirdUser.getSysUserId());
        try {
            subject.login((AuthenticationToken)uptoken);
            return "redirect:/home";
        }
        catch (Exception re) {
            re.printStackTrace();
            model.put((Object)"thirdLoginMessage", (Object)re.getMessage());
            return "commons/401";
        }
    }

    @RequestMapping(value={"captcha"}, method={RequestMethod.GET})
    public void getLoginCaptcha(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("\u767b\u5f55\u65f6\u8bf7\u6c42\u83b7\u53d6\u56fe\u5f62\u9a8c\u8bc1\u7801,sessionId\uff1a{}", (Object)SecurityUtils.getSubject().getSession().getId());
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("image/jpeg");
        String capText = this.captchaProducer.createText();
        LoginUtil.setLoginCaptcha(capText);
        BufferedImage bi = this.captchaProducer.createImage(capText);
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
        out.flush();
    }

    private Boolean isBindedMobile(String username, String mobile) {
        SysUser user = UserUtils.getByLoginName(username);
        if (user != null && StringUtils.isNotEmpty((String)mobile) && mobile.trim().equals(user.getMobile())) {
            return true;
        }
        return false;
    }

    @RequestMapping(value={"findBackPasswordByMobile"}, method={RequestMethod.GET})
    public String findBackPasswordByMobile(HttpServletRequest request, Model model) {
        return "/login/findBackPasswordByMobile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/singleLogin"})
    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module2)
    public String singleLogin(String userMsg, Model model, HttpServletRequest request, HttpServletResponse httpServletResponse) {
        String decrypt = null;
        try {
            decrypt = NoSpecalCrypUtil.decrypt((String)userMsg, (String)this.aesKey);
        }
        catch (Exception e) {
            model.addAttribute("msg", (Object)"\u53c2\u6570\u9519\u8bef");
            return "single_login";
        }
        if (decrypt == null || decrypt.isEmpty()) {
            model.addAttribute("msg", (Object)"\u53c2\u6570\u9519\u8bef");
            return "single_login";
        }
        JSONObject jsonObject = JSON.parseObject((String)decrypt);
        String username = jsonObject.getString("username");
        String loginTime = jsonObject.getString("loginTime");
        String companyCode = jsonObject.getString("companyCode");
        String jumpUrl = jsonObject.getString("jumpUrl");
        Long cid = jsonObject.getLong("cid");
        String loginUserType = jsonObject.getString("loginUserType");
        String superviseFullName = jsonObject.getString("superviseFullName");
        String superviseUserName = jsonObject.getString("superviseUserName");
        String superviseUserTel = jsonObject.getString("superviseUserTel");
        Long superviseLoginUserId = jsonObject.getLong("superviseLoginUserId");
        Byte superviseLevel = jsonObject.getByte("superviseLevel");
        String isDyProj = jsonObject.getString("isDyProj");
        Boolean isYcPro = jsonObject.getBoolean("isYcPro");
        if (cid == null) {
            model.addAttribute("msg", (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return "single_login";
        }
        try {
            SysUser user = null;
            RLock lock = this.redissonClient.getLock("singleLogin:" + username + ":lock");
            if (lock.tryLock(1L, TimeUnit.MINUTES)) {
                try {
                    if (username != null) {
                        user = this.userService.getUserByuserameAndCid(username, cid);
                    }
                    if (user == null) {
                        user = this.createUser(username, cid);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            Integer systemSource = Boolean.TRUE.equals(isYcPro) ? UserSystemWideEnum.COMPANY_YC.getCode() : UserSystemWideEnum.ZLWQ_COMPANY.getCode();
            ShiroUsernamePasswordToken shiroUsernamePasswordToken = new ShiroUsernamePasswordToken(0, systemSource);
            shiroUsernamePasswordToken.setUsername(username);
            shiroUsernamePasswordToken.setUserId(user.getId());
            SecurityUtils.getSubject().login((AuthenticationToken)shiroUsernamePasswordToken);
            CookieUtil.setCookie((HttpServletResponse)httpServletResponse, (String)"uid", (String)user.getId().toString(), (int)31536000);
            CompanyBaseInfoModel cbm = this.companyProvideByHSEService.getCompanyById(cid);
            Boolean victimsIdentify = false;
            switch (cbm.getVictimsIdentify()) {
                case 0: {
                    victimsIdentify = Objects.isNull(cbm.getPickupCount()) || cbm.getPickupCount() >= 3;
                    break;
                }
                case 1: {
                    victimsIdentify = false;
                    break;
                }
                case 2: {
                    victimsIdentify = true;
                    break;
                }
            }
            this.session.setAttribute("victimsIdentify", (Object)victimsIdentify);
            this.session.setAttribute("victimsNum", (Object)cbm.getPickupCount());
            this.session.setAttribute("loginUserType", (Object)loginUserType);
            this.session.setAttribute("superviseFullName", (Object)superviseFullName);
            this.session.setAttribute("superviseUserTel", (Object)(ObjectUtil.isNull((Object)superviseUserTel) ? "" : superviseUserTel));
            this.session.setAttribute("superviseLoginUserId", (Object)superviseLoginUserId);
            this.session.setAttribute("superviseLevel", (Object)superviseLevel);
            this.session.setAttribute("isDec", (Object)cbm.getIsDec());
            this.session.setAttribute("companyType", (Object)cbm.getCompanyType());
            this.session.setAttribute("superviseUserName", (Object)superviseUserName);
            this.session.setAttribute("isDyProj", (Object)isDyProj);
            this.session.setAttribute("isYcPro", (Object)isYcPro);
            if (StringUtils.isNotBlank((CharSequence)jumpUrl)) {
                return cbm.getIsDec() != false || cbm.getDataSource() != null && CompanyDataSourceEnum.NEW_COMPANY_GUIDE.getValue().equals(cbm.getDataSource()) ? "redirect:/" + jumpUrl : "redirect:/company/index";
            }
            return Boolean.TRUE.equals(isYcPro) ? "redirect:/microcom/base/classificationSelfAssessment/selfJudge/listPage" : (Boolean.FALSE.equals(cbm.getIsDec()) && cbm.getAreaId() != 330783000000L ? "redirect:/indexhomev2" : "redirect:/company/index");
        }
        catch (Exception e) {
            this.logger.error("\u4f01\u4e1a\u7aef\u5355\u70b9\u767b\u5f55\u5f02\u5e38\uff1a", (Throwable)e);
            return "single_login";
        }
    }

    private synchronized SysUser createUser(String username, Long cid) {
        SysUser userByuserameAndCid = this.userService.getUserByuserameAndCid(username, cid);
        if (userByuserameAndCid != null) {
            return userByuserameAndCid;
        }
        StaffInfo staffForm = new StaffInfo();
        staffForm.setCid(cid);
        staffForm.setIsThirdParty(Global.FALSE);
        staffForm.setIsValid(Global.TRUE);
        staffForm.setCreateDate(new Date());
        staffForm.setUpdateDate(new Date());
        staffForm.setCreateBy(Long.valueOf(0L));
        staffForm.setUpdateBy(Long.valueOf(0L));
        staffForm.setAddFrom(Integer.valueOf(StaffAddFromEnum.supervise_manager_or_single_add1.getValue().byteValue()));
        StaffBasicInfo bas = new StaffBasicInfo();
        bas.setCid(cid);
        bas.setRealName(username);
        bas.setCid(cid);
        bas.setIsValid(Global.TRUE);
        bas.setCreateDate(new Date());
        bas.setUpdateDate(new Date());
        bas.setCreateBy(Long.valueOf(0L));
        bas.setUpdateBy(Long.valueOf(0L));
        staffForm.setStaffBasicInfo(bas);
        staffForm = this.staffInfoService.addStaffInfoSubmit(staffForm);
        SysUser user = new SysUser();
        user.setStaffId(staffForm.getId());
        user.setCid(cid);
        user.setUsername(username);
        user.setFullname(username);
        user.setIsManger(Boolean.valueOf(false));
        user.setIsForbidden(Global.FALSE);
        user.setUsername(username);
        user.setCreateBy(Long.valueOf(0L));
        user.setCreateDate(new Date());
        user.setUpdateDate(new Date());
        user.setUpdateBy(Long.valueOf(0L));
        this.entryptPassword(user, MD5.MD5Encode((String)"Zyj@2022"));
        user = (SysUser)this.userService.add((Object)user);
        SecUserRole userRole = new SecUserRole();
        userRole.setIsValid(Global.TRUE);
        userRole.setSecRoleId(Long.valueOf(33000000000001L));
        userRole.setSysUserId(user.getId());
        userRole.setCreateBy(Long.valueOf(0L));
        userRole.setCreateDate(new Date());
        userRole.setUpdateDate(new Date());
        userRole.setUpdateBy(Long.valueOf(0L));
        this.secUserRoleService.add((Object)userRole, null, cid);
        this.secUserRoleService.addSysUserRoleV3(user.getId(), Long.valueOf(3002L));
        return user;
    }

    public SysUser entryptPassword(SysUser user, String plainPassword) {
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
        return user;
    }

    @RequestMapping(value={"/getPublicKeyStr"})
    public String getPublicKeyStr() {
        return JsonUtils.toJsonString((Object)RSAUtils.getPublicKeyStr());
    }

    @GetMapping(value={"/bx/login"})
    public String testLogin(String userName) {
        long requestTime = System.currentTimeMillis();
        String sign = MD5Utils.getMD5String((String)("appId=" + this.bxAppId + "&appSecret=" + this.bxAppSecret + "&requestTime=" + requestTime));
        String finalUrl = this.bxLoginUrl + "?appId=" + this.bxAppId + "&requestTime=" + requestTime + "&userName=" + userName + "&userType=4&sign=" + sign;
        this.logger.info("\u6807\u73ba\u767b\u5f55\u63a5\u53e3\u4e3a:{}", (Object)finalUrl);
        return "redirect:" + finalUrl;
    }

    @RequestLimit
    @ResponseBody
    @RequestMapping(value={"sendVcodeByPicCode"}, method={RequestMethod.POST})
    @ApiEncrypt(request=true)
    public ResponseData<String> sendVcode(HttpServletRequest request, @RequestBody ResetPasswordVo vo) {
        SysUser user = UserUtils.getByLoginName(vo.getUsername());
        if (user == null) {
            return ResponseData.fail((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)vo.getMobile())) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CommonUtil.checkMobile((String)vo.getMobile())) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!LoginUtil.validate(request, vo.getPicCode())) {
            return ResponseData.fail((String)"\u56fe\u7247\u9a8c\u8bc1\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.");
        }
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(user.getCid());
        if (Objects.equals(CompanyBusinessState.NORMAL.getCode().byteValue(), company.getBusinessState())) {
            return ResponseData.fail((String)("\u8d26\u53f7:" + vo.getUsername() + "\u8425\u4e1a\u72b6\u6001\u65e0\u9700\u53d8\u66f4\u3002"));
        }
        if (Objects.equals((byte)0, company.getIrsBusinessState())) {
            return ResponseData.fail((String)"\u8be5\u4f01\u4e1a\u5728\u5de5\u5546\u6570\u636e\u4e2d\u5df2\u6ce8\u9500\uff0c\u65e0\u6cd5\u6062\u590d\u6b63\u5e38\u8425\u4e1a");
        }
        String rateLimitKey = VCODECACHENAMERATE + vo.getMobile();
        Map lastSentData = (Map)this.redisClient.get(rateLimitKey);
        if (lastSentData != null) {
            long lastSentTime = Long.parseLong(lastSentData.get("timestamp").toString());
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastSentTime < 60000L) {
                return ResponseData.fail((String)"\u9891\u7e41\u64cd\u4f5c\uff1a\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e00\u5206\u949f\u53ea\u80fd\u53d1\u4e00\u6b21");
            }
        }
        String vcode = RandomGenerator.getRandomNum((int)6);
        this.smsProvideMasService.sendSms(vo.getMobile(), String.format(vcode_template, user.getUsername(), vcode));
        this.logger.info("\u804c\u4e1a\u5065\u5eb7==\u300b\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801  \u624b\u673a\uff1a" + vo.getMobile() + ", \u9a8c\u8bc1\u7801\uff1a" + vcode);
        HashMap<String, Object> rateLimitData = new HashMap<String, Object>();
        rateLimitData.put("vcode", vcode);
        rateLimitData.put("timestamp", System.currentTimeMillis());
        this.redisClient.set(rateLimitKey, rateLimitData, 60L);
        this.redisClient.set(VCODECACHENAME + vo.getMobile(), (Object)vcode, 300L);
        return ResponseData.success((String)"\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536");
    }

    @RequestLimit
    @ResponseBody
    @RequestMapping(value={"resetBusinessState"}, method={RequestMethod.POST})
    public ResponseData<String> resetBusinessState(@RequestBody ResetPasswordVo vo) {
        SysUser user = UserUtils.getByLoginName(vo.getUsername());
        if (user == null) {
            return ResponseData.fail((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(user.getCid());
        if (company == null) {
            return ResponseData.fail((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        if (company.getMainLeaderTel() == null) {
            return ResponseData.fail((String)("\u8d26\u53f7:" + vo.getUsername() + "\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u8054\u7cfb\u65b9\u5f0f\u4e3a\u7a7a"));
        }
        if (Objects.equals(CompanyBusinessState.NORMAL.getCode().byteValue(), company.getBusinessState())) {
            return ResponseData.fail((String)("\u8d26\u53f7:" + vo.getUsername() + "\u8425\u4e1a\u72b6\u6001\u65e0\u9700\u53d8\u66f4\u3002"));
        }
        if (Objects.equals((byte)0, company.getIrsBusinessState())) {
            return ResponseData.fail((String)"\u8be5\u4f01\u4e1a\u5728\u5de5\u5546\u6570\u636e\u4e2d\u5df2\u6ce8\u9500\uff0c\u65e0\u6cd5\u6062\u590d\u6b63\u5e38\u8425\u4e1a");
        }
        Byte beforeBusinessState = company.getBusinessState();
        String vcodeCacheKey = VCODECACHENAME + vo.getMobile();
        String cachedCode = (String)this.redisClient.get(vcodeCacheKey);
        if (cachedCode == null || !cachedCode.equals(vo.getSmsCode())) {
            return ResponseData.fail((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5\u3002");
        }
        RpcContext.getContext().setAttachment("operator_name", vo.getMobile());
        int resetCode = this.userService.resetPassword(vo.getUsername(), "Zyj@2022");
        RpcContext.getContext().setAttachment("operator_name", vo.getMobile());
        boolean stateChanged = this.dcCompanyService.changeBusinessState(company.getId(), Byte.valueOf(CompanyBusinessState.NORMAL.getCode().byteValue()), company.getId());
        ResetBusinessLog log = new ResetBusinessLog();
        log.setCid(company.getId());
        log.setUserId(user.getId());
        log.setCreateBy(Long.valueOf(vo.getMobile()));
        log.setMobile(vo.getMobile());
        log.setStatue(Boolean.valueOf(resetCode == 0 && stateChanged));
        log.setBeforeInfo(beforeBusinessState);
        if (log.getStatue().booleanValue()) {
            log.setAfterInfo(Byte.valueOf(CompanyBusinessState.NORMAL.getCode().byteValue()));
        } else {
            log.setAfterInfo(company.getBusinessState());
        }
        this.businessRenewService.add((Object)log);
        if (log.getStatue().booleanValue()) {
            return ResponseData.success((String)String.format("\u5bc6\u7801\u5df2\u7ecf\u91cd\u7f6e\u4e3a\u201c%s\u201d\uff0c\u8bf7\u53ca\u65f6\u767b\u9646\u7cfb\u7edf\u5e76\u4fee\u6539\u5bc6\u7801\u3002", "Zyj@2022"));
        }
        return ResponseData.fail((String)("\u8d26\u53f7:" + vo.getUsername() + "\u6062\u590d\u8425\u4e1a\u72b6\u6001\u5931\u8d25\u3002"));
    }

    private Boolean judgeStaffBasicInfoExistByStaffId(Long staffId) {
        if (staffId == null) {
            return Boolean.FALSE;
        }
        String realName = this.staffInfoService.getStaffBasicInfoRealNameByStaffId(staffId);
        if (StrUtil.isBlank((CharSequence)realName)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

