/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller;

import cn.hutool.core.util.PhoneUtil;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.provider.log.ISysOperLogProviderService;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.health.bind.entity.SysUserBind;
import cn.smarthse.modules.health.bind.enums.UserBindLogTypeEnum;
import cn.smarthse.modules.health.bind.model.ForgetPWDParam;
import cn.smarthse.modules.health.bind.model.SmsRequestParam;
import cn.smarthse.modules.health.bind.service.ISysUserBindService;
import cn.smarthse.modules.health.bind.vo.SysUserBindVo;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.sys.annotation.PasswordLog;
import cn.smarthse.modules.sys.enumd.BusinessTypeEnum;
import cn.smarthse.modules.sys.enumd.OperatorDataSourceEnum;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.AppConfigHolder;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@RequestMapping(value={"/login/next"})
@Validated
public class LoginCheckController
extends ControllerSupport {
    @DubboReference
    private ISMSProviderWelinkService smsProvider;
    @DubboReference
    private ISysUserService userService;
    @DubboReference
    private ISysUserBindService userBindService;
    @DubboReference
    private ISysOperLogProviderService sysOperLogService;
    @Autowired
    private SessionDAO sessionDAO;
    private final RedisClient redisClient;
    private static final String vcode_template = "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u6b63\u5728\u767b\u5f55\u201d\u6d59\u91cc\u536b\u4f01\u5e94\u7528-\u7528\u4eba\u5355\u4f4d\u7aef\u201c\uff0c\u767b\u5f55\u9a8c\u8bc1\u7801\u4e3a %s \uff08\u5207\u52ff\u544a\u77e5\u4ed6\u4eba\uff09\uff0c5\u5206\u949f\u5185\u6709\u6548\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002";
    private static final String vcode_template_rebind = "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u6b63\u5728\u8fdb\u884c\u7ed1\u5b9a\u624b\u673a\u53f7\u7684\u64cd\u4f5c\uff0c\u9a8c\u8bc1\u7801\u662f\uff1a %s \uff08\u5207\u52ff\u544a\u77e5\u4ed6\u4eba\uff09\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002";
    private static final String vcode_template_change = "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u6b63\u5728\u91cd\u7f6e\u201c\u6d59\u91cc\u536b\u4f01\u5e94\u7528-\u7528\u4eba\u5355\u4f4d\u7aef\u201d\u5bc6\u7801\uff0c\u60a8\u83b7\u53d6\u7684\u9a8c\u8bc1\u7801\u4e3a\uff1a %s \uff08\u5207\u52ff\u544a\u77e5\u4ed6\u4eba\uff09\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002";
    private static final String sms_cache_name = "sms_login:web:";
    private static final String VCODECACHENAMERATE = "bindVcodeCacheRate:web";

    @RequestLimit
    @PostMapping(value={"sendVcode"})
    public ResponseData<String> sendVcode(@RequestBody SmsRequestParam type) {
        if (!SecurityUtils.getSubject().isAuthenticated()) {
            return ResponseData.fail((String)"\u767b\u5f55\u5931\u6548\uff0c\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff01");
        }
        SysUserBind userBind = this.userBindService.getByUserId(UserUtils.getPrincipal().getUserId(), UserUtils.getPrincipal().getCid(), UserSystemWideEnum.ZLWQ_COMPANY.getCode());
        String mobile = userBind.getBindTel();
        if (!StringUtils.checkMobile((String)mobile)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        String rateLimitKey = VCODECACHENAMERATE + mobile;
        Map lastSentData = (Map)this.redisClient.get(rateLimitKey);
        if (lastSentData != null) {
            long lastSentTime = Long.parseLong(lastSentData.get("timestamp").toString());
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastSentTime < 60000L) {
                return ResponseData.fail((String)"\u9891\u7e41\u64cd\u4f5c\uff1a\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e00\u5206\u949f\u53ea\u80fd\u53d1\u4e00\u6b21");
            }
        }
        String vcode = StringUtils.getRandomNum((int)6);
        this.logger.info("LoginCheckController:sendVcode:vcode:{}", (Object)vcode);
        String template = Objects.equals(UserBindLogTypeEnum.REBIND.getValue(), type.getType()) ? vcode_template_rebind : vcode_template;
        this.smsProvider.singleSendSms(mobile, String.format(template, vcode));
        ShiroPrincipal principal = UserUtils.getPrincipal();
        principal.setBindTel(DesensitizationUtils.desensitized((CharSequence)mobile, (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        UserUtils.reflushPrincipal(principal);
        HashMap<String, Object> rateLimitData = new HashMap<String, Object>();
        rateLimitData.put("vcode", vcode);
        rateLimitData.put("timestamp", System.currentTimeMillis());
        this.redisClient.set(rateLimitKey, rateLimitData, 60L);
        this.redisClient.set(sms_cache_name + mobile, (Object)vcode, 300L, TimeUnit.SECONDS);
        return ResponseData.success();
    }

    @RequestLimit
    @PostMapping(value={"sendVcodeByUsername"})
    @ApiEncrypt(request=true)
    public ResponseData<String> sendVcodeByUsername(@RequestBody ForgetPWDParam param) {
        String username = param.getUsername();
        String cid = param.getCid();
        this.logger.debug("sendVcodeByUsername: {}, {}", (Object)username, (Object)cid);
        SysUser user = this.getUserByUsernameOrCid(username, cid);
        ResponseData<SysUserBind> bindResult = this.getValidBindPhone(user);
        if (!bindResult.getState().equals(ResponseStateEnum.success)) {
            return ResponseData.fail((String)bindResult.getContent());
        }
        SysUserBind userBind = (SysUserBind)bindResult.getResult();
        String rateLimitKey = VCODECACHENAMERATE + userBind.getBindTel();
        Map lastSentData = (Map)this.redisClient.get(rateLimitKey);
        if (lastSentData != null) {
            long lastSentTime = Long.parseLong(lastSentData.get("timestamp").toString());
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastSentTime < 60000L) {
                return ResponseData.fail((String)"\u9891\u7e41\u64cd\u4f5c\uff1a\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e00\u5206\u949f\u53ea\u80fd\u53d1\u4e00\u6b21");
            }
        }
        String vcode = StringUtils.getRandomNum((int)6);
        this.logger.info("LoginCheckController:sendVcodeByUsername:vcode:{}", (Object)vcode);
        this.smsProvider.singleSendSms(userBind.getBindTel(), String.format(vcode_template_change, vcode));
        HashMap<String, Object> rateLimitData = new HashMap<String, Object>();
        rateLimitData.put("vcode", vcode);
        rateLimitData.put("timestamp", System.currentTimeMillis());
        this.redisClient.set(rateLimitKey, rateLimitData, 60L);
        this.redisClient.set(sms_cache_name + userBind.getBindTel(), (Object)vcode, 300L, TimeUnit.SECONDS);
        return ResponseData.success((String)String.format("\u5df2\u5411\u5f53\u524d\u8d26\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536", new Object[0]));
    }

    @PostMapping(value={"check1"})
    public ResponseData<SysUserBindVo> check1(String vcode) {
        Subject subject = SecurityUtils.getSubject();
        if (!subject.isAuthenticated()) {
            throw new HealthException("\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u8d26\u53f7\u5bc6\u7801\u767b\u5f55\uff01");
        }
        ShiroPrincipal principal = UserUtils.getPrincipal();
        SysUserBind userBind = this.userBindService.getByUserId(principal.getUserId(), principal.getCid(), UserSystemWideEnum.ZLWQ_COMPANY.getCode());
        if (!this.checkVcode(userBind.getBindTel(), vcode)) {
            throw new HealthException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.checkMultiAccountLogin(subject);
        principal.setCheckVcode(1);
        UserUtils.reflushPrincipal(principal);
        SysUserBindVo vo = new SysUserBindVo();
        vo.setRedirect("/indexhome");
        vo.setBindTel(DesensitizationUtils.desensitized((CharSequence)principal.getBindTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        return ResponseData.success((Object)vo);
    }

    @PostMapping(value={"check2"})
    public ResponseData<String> check2(String vcode) {
        if (!SecurityUtils.getSubject().isAuthenticated()) {
            return ResponseData.fail((String)"\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u8d26\u53f7\u5bc6\u7801\u767b\u5f55\uff01");
        }
        ShiroPrincipal principal = UserUtils.getPrincipal();
        SysUserBind userBind = this.userBindService.getByUserId(principal.getUserId(), principal.getCid(), UserSystemWideEnum.ZLWQ_COMPANY.getCode());
        if (!this.checkVcode(userBind.getBindTel(), vcode)) {
            return ResponseData.fail((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.redisClient.set(sms_cache_name + principal.getUserId(), (Object)"checkSuccess", 1800L, TimeUnit.SECONDS);
        return ResponseData.success();
    }

    @PostMapping(value={"check3"})
    @ApiEncrypt(request=true)
    public ResponseData<String> check3(@RequestBody ForgetPWDParam param) {
        String username = param.getUsername();
        String cid = param.getCid();
        String vcode = param.getVcode();
        SysUser user = this.getUserByUsernameOrCid(username, cid);
        ResponseData<SysUserBind> bindResult = this.getValidBindPhone(user);
        if (!bindResult.getState().equals(ResponseStateEnum.success)) {
            return ResponseData.fail((String)bindResult.getContent());
        }
        SysUserBind userBind = (SysUserBind)bindResult.getResult();
        if (!this.checkVcode(userBind.getBindTel(), vcode)) {
            return ResponseData.fail((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.redisClient.set(sms_cache_name + user.getUsername(), (Object)"checkSuccess", 1800L, TimeUnit.SECONDS);
        return ResponseData.success();
    }

    @PasswordLog(businessType=BusinessTypeEnum.CHANGEPASSWORD, dataOf=OperatorDataSourceEnum.ENTERPRISE)
    @RequestLimit
    @RequestMapping(value={"changePass"}, method={RequestMethod.POST})
    @ApiEncrypt(request=true)
    public ResponseData<String> changePass(@RequestBody ForgetPWDParam param, HttpServletRequest request) {
        String username = param.getUsername();
        String cid = param.getCid();
        String password = param.getPassword();
        SysUser userByname = this.getUserByUsernameOrCid(username, cid);
        if (userByname == null) {
            return ResponseData.success((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        String cache = (String)this.redisClient.get(sms_cache_name + userByname.getUsername());
        if (cache == null || !cache.equals("checkSuccess")) {
            return ResponseData.fail((String)"\u8be5\u8d26\u53f7\u672a\u8fdb\u884c\u65e7\u624b\u673a\u9a8c\u8bc1\uff0c\u65e0\u6cd5\u4fee\u6539\u5bc6\u7801");
        }
        if (cn.smarthse.common.util.StringUtils.isBlank((CharSequence)password)) {
            return ResponseData.fail((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (this.sysOperLogService.isPasswordAvailable(password, userByname.getUsername(), OperatorDataSourceEnum.ENTERPRISE.getValue()).booleanValue()) {
            return ResponseData.fail((String)"\u4e0d\u53ef\u4f7f\u7528\u5386\u53f2\u5bc6\u7801\u6216\u521d\u59cb\u5bc6\u7801");
        }
        SysUser user = new SysUser();
        user.setId(userByname.getId());
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])password.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
        user.setIsDefaultPwd(Boolean.valueOf(false));
        Date date = new Date();
        user.setUpdateDate(date);
        RpcContext.getContext().setAttachment("operator_name", userByname.getUsername());
        this.userService.update((Object)user, userByname.getId());
        request.setAttribute("cid", (Object)userByname.getCid().toString());
        request.setAttribute("username", (Object)userByname.getUsername());
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes(request));
        this.redisClient.del(new String[]{sms_cache_name + user.getUsername()});
        return ResponseData.success((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f\uff0c\u8bf7\u8fd4\u56de\u767b\u5f55");
    }

    private boolean checkVcode(String mobile, String vcode) {
        boolean result;
        String cache = (String)this.redisClient.get(sms_cache_name + mobile);
        boolean bl = result = cache != null && cache.equalsIgnoreCase(vcode);
        if (result) {
            this.redisClient.del(new String[]{sms_cache_name + mobile});
        }
        return result;
    }

    @RequestMapping(value={"/logout"})
    public void logout() {
        try {
            Subject subject = UserUtils.getSubject();
            if (subject != null && subject.isAuthenticated()) {
                subject.logout();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SysUser getUserByUsernameOrCid(String username, String cid) {
        List userManager;
        if (StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)cid)) {
            return null;
        }
        SysUser user = null;
        if (StringUtils.isNotBlank((CharSequence)username)) {
            user = this.userService.getUserByuserame(username);
        }
        if (user == null && StringUtils.isNotBlank((CharSequence)cid) && CollectionUtils.isNotEmpty((Collection)(userManager = this.userService.getUserManager(Long.valueOf(cid.trim()))))) {
            user = (SysUser)userManager.get(0);
        }
        return user;
    }

    public ResponseData<SysUserBind> getValidBindPhone(SysUser user) {
        if (user == null) {
            return ResponseData.fail((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        SysUserBind userBind = this.userBindService.getByUserId(user.getId(), user.getCid(), UserSystemWideEnum.ZLWQ_COMPANY.getCode());
        if (userBind == null) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u901a\u8fc7\u6280\u672f\u652f\u6301\u7fa4\u8054\u7cfb\u5ba2\u670d\u91cd\u7f6e\u5bc6\u7801");
        }
        if (!PhoneUtil.isMobile((CharSequence)userBind.getBindTel())) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\uff01");
        }
        return ResponseData.success((Object)userBind);
    }

    private void checkMultiAccountLogin(Subject subject) {
        if (!AppConfigHolder.enableMultiAccountLogin()) {
            Serializable thisSessionId = subject.getSession().getId();
            for (Session a : this.sessionDAO.getActiveSessions()) {
                if (a == null) continue;
                String id = String.valueOf(a.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY));
                if (a.getId() == null || a.getId().equals(thisSessionId) || !cn.smarthse.common.util.StringUtils.equals((CharSequence)id, (CharSequence)subject.getPrincipal().toString())) continue;
                this.logger.debug("\u8d26\u53f7:\u201c{}\u201d\u5728\u522b\u5904\u767b\u5f55\uff0c\u4f60\u88ab\u8e22\u51fa\u7cfb\u7edf\u4e86\u2026\u2026", (Object)id);
                this.sessionDAO.delete(a);
            }
        }
    }

    @Generated
    public LoginCheckController(RedisClient redisClient) {
        this.redisClient = redisClient;
    }
}

