/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.bx.service.IBxZybService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.entity.base.company.grade.vo.CompanyGradeVoV3;
import cn.smarthse.modules.health.entity.sys.workremind.SysWorkRemind;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserParamVo;
import cn.smarthse.modules.health.enums.check.DiagnosedTypeEnum;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.param.FcythSearchParam;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.sys.workremind.ISysWorkRemindService;
import cn.smarthse.modules.health.service.temporary.ICompanyGradeV3TemporaryService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.modules.health.service.work.zjhome.IZjHomeWorkDataService;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategory;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalOdService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.service.supervisionlaw.ISupervisionLawService;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.modules.health.vo.work.reform.RiskLevelVo;
import cn.smarthse.modules.health.vo.work.train.TrainPlanCountView;
import cn.smarthse.util.common.date.DateUtils;
import cn.smarthse.web.controller.CacheControllerSupport;
import cn.smarthse.web.controller.HomeControllerHelper;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/indexhomev2"})
public class IndexHomeV2Controller
extends CacheControllerSupport {
    @Autowired
    private HomeControllerHelper helper;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService superviseService;
    @DubboReference
    ILiteArchiveService liteArchiveService;
    @DubboReference
    ITrainPlanService trainPlanService;
    @DubboReference
    IZjHomeWorkDataService zjHomeWorkDataService;
    @DubboReference
    private IOnlineDeviceService onlineDeviceService;
    @DubboReference
    ITsProjectSimpleService tsProjectSimpleService;
    @DubboReference
    IReformItemBasicService reformItemBasicService;
    @DubboReference
    ISupervisePhcPhysicalOdService supervisePhcPhysicalOdService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService hseService;
    @DubboReference
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    ICompanyGradeV3RecService gradeV3RecService;
    @DubboReference
    ISysWorkRemindService workRemindService;
    @DubboReference(timeout=60000)
    private ISupervisionLawService supervisionLawService;
    @DubboReference(timeout=600000, check=false)
    ICompanyGradeV3TemporaryService companyGradeV3TemporaryService;
    @DubboReference(check=false)
    private IComplianceCompanyInfoService complianceCompanyInfoService;
    @DubboReference(check=false)
    private INewComplianceCompanyInfoService newComplianceCompanyInfoService;
    @DubboReference
    private IBxZybService bxZybService;
    private static final String CACHE_NAME = "index_home_cachename";
    private static final String PRE_PATH = "/homedatav2/";

    @RequestMapping(method={RequestMethod.GET})
    @RequiresPermissions(value={"visual.index", "visual.base", "visual.keyFactor", "visual.archive", "visual.assist", "visual.risk"}, logical=Logical.OR)
    public String pageLoginIndexCompanySuperviseV3221(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        List importantTypeByCids;
        Boolean isDyProj = Convert.toBool((Object)this.session.getAttribute("isDyProj"));
        model.addAttribute("isDyProj", (Object)isDyProj);
        ShiroPrincipal principal = UserUtils.getPrincipal();
        Long cid = UserUtils.getLoginStaffCompanyId();
        model.addAttribute("isActualize", (Object)this.isActualize);
        model.addAttribute("cid", (Object)cid);
        CompanyBaseInfoModel cbm = this.companyProvideByHSEService.getCompanyById(cid);
        CompanySuperviseModel csm = this.superviseService.getCompanyInfoById(cid);
        Boolean victimsIdentify = false;
        switch (cbm.getVictimsIdentify()) {
            case 0: {
                victimsIdentify = Objects.isNull(cbm.getPickupCount()) || cbm.getPickupCount() >= 3;
                break;
            }
            case 1: {
                victimsIdentify = false;
                break;
            }
            case 2: {
                victimsIdentify = true;
                break;
            }
        }
        cbm.setPickupCount(Integer.valueOf(3));
        System.out.println(Objects.isNull(cbm.getPickupCount()) || cbm.getPickupCount() >= 3);
        this.session.setAttribute("victimsIdentify", (Object)victimsIdentify);
        this.session.setAttribute("victimsNum", (Object)cbm.getPickupCount());
        this.session.setAttribute("companyType", (Object)cbm.getCompanyType());
        NewComplianceCompanyInfo compliance = this.newComplianceCompanyInfoService.getLastByCid(cbm.getCid());
        if (compliance != null) {
            model.addAttribute("complianceStatus", (Object)compliance.getStatus());
            model.addAttribute("complianceScore", (Object)compliance.getComplianceScore());
            model.addAttribute("complianceId", (Object)compliance.getId());
            model.addAttribute("complianceAccordingType", (Object)compliance.getComplianceAccordingType());
        }
        if (csm != null) {
            if (Boolean.FALSE.equals(csm.getIsDec()) && csm.getAreaId() != 330783000000L) {
                return "redirect:/company/index";
            }
            if ("\u6d59\u6c5f\u7701".equals(csm.getProvinceName())) {
                model.addAttribute("isZj", (Object)"isZj");
            }
            DesensitizationUtils.setDesensitizationFieldFromObject((Object)csm);
            model.addAttribute("company", (Object)csm);
            this.session.setAttribute("isDec", (Object)csm.getIsDec());
        }
        CompanyGradeV3Rec companyGradeV3 = this.gradeV3RecService.getGradeRecByCid(cid);
        Integer creditSupervise = Optional.ofNullable(csm).map(CompanyBaseInfoModel::getCreditSupervise).orElse(null);
        model.addAttribute("creditSupervise", (Object)(creditSupervise == null ? 0 : creditSupervise));
        if (cid != null && CollectionUtils.isNotEmpty((Collection)(importantTypeByCids = this.complianceCompanyInfoService.getImportantTypeByCids(Arrays.asList(cid))))) {
            ImportantIndustryCategory importantIndustryCategory = (ImportantIndustryCategory)importantTypeByCids.get(0);
            model.addAttribute("importantIndustryType", (Object)importantIndustryCategory.getImportantTypeStr());
        }
        CompanyGradeVoV3 companyGradeVoV3 = new CompanyGradeVoV3();
        if (companyGradeV3 != null) {
            BeanUtils.copyProperties((Object)companyGradeV3, (Object)companyGradeVoV3);
            this.setClassLow2Height(model, Optional.ofNullable(companyGradeV3.getRiskLevel()), "Riskclass");
            this.setClassLow2Height(model, Optional.ofNullable(companyGradeV3.getGrade()), "RiskClassifyclass");
            this.setClassLow2Height(model, Optional.ofNullable(companyGradeV3.getJudgeLevel()), "JudgeResultClass");
        }
        int thisYear = DateUtils.getYear();
        int prevYear = thisYear - 1;
        model.addAttribute("thisYear", (Object)thisYear);
        model.addAttribute("prevYear", (Object)prevYear);
        if (cbm.getCompanyType() == 2) {
            companyGradeVoV3.setGrade(Integer.valueOf(1));
        }
        model.addAttribute("info", (Object)companyGradeVoV3);
        model.addAttribute("occTypeClass", (Object)this.setClassOccType(companyGradeVoV3.getOccType()));
        this.setClassLow2Height(model, Optional.ofNullable(companyGradeVoV3.getRiskLevel()), "Riskclass");
        this.setClassLow2Height(model, Optional.ofNullable(companyGradeVoV3.getGrade()), "RiskClassifyclass");
        this.setClassLow2Height(model, Optional.ofNullable(companyGradeVoV3.getJudgeLevel()), "JudgeResultClass");
        Map map = this.getCacheData(CACHE_NAME, "evaluateCheckOverPointCount" + cid, () -> this.helper.evaluateCheckOverPointCount(cid, null));
        model.addAttribute("evaluateCheckOverPointCount", (Object)map);
        model.addAttribute("isHaveOnlineMonitoring", (Object)false);
        model.addAttribute("isHaveOnlineCamera", (Object)false);
        List deviceList = this.getCacheData(CACHE_NAME, "getDeviceListInfoByCid" + cid, () -> this.onlineDeviceService.getDeviceListInfoByCid(cid));
        model.addAttribute("deviceList", (Object)deviceList);
        if (CollectionUtils.isNotEmpty((Collection)deviceList)) {
            List collect = deviceList.stream().filter(item -> Objects.equals("3", item.getType())).collect(Collectors.toList());
            model.addAttribute("cameras", collect);
            boolean isHaveOnlineMonitoring = deviceList.stream().anyMatch(d -> Objects.equals(d.getType(), "1") || Objects.equals(d.getType(), "2"));
            boolean isHaveOnlineCamera = deviceList.stream().anyMatch(d -> Objects.equals(d.getType(), "3"));
            model.addAttribute("isHaveOnlineMonitoring", (Object)isHaveOnlineMonitoring);
            model.addAttribute("isHaveOnlineCamera", (Object)isHaveOnlineCamera);
        }
        Map remindInfoByCid = this.workRemindService.getRemindInfoByCid(cid);
        model.addAttribute("remind", (Object)remindInfoByCid);
        Map<String, Integer> rmap = this.RectificationPageMap();
        model.addAttribute("rmap", rmap);
        Integer jdnum = this.supervisionLawService.countSupInfoByCidAndYear(cid, Integer.valueOf(thisYear));
        Integer cfnum = this.supervisionLawService.countLawInfoByCidAndYear(cid, Integer.valueOf(thisYear));
        model.addAttribute("jdnum", (Object)jdnum);
        model.addAttribute("cfnum", (Object)cfnum);
        List riskLevelVos = this.reformItemBasicService.getRiskLevelListData(cid);
        Long count = 0L;
        for (RiskLevelVo r : riskLevelVos) {
            count = count + r.getRiskLevelNum();
        }
        model.addAttribute("nowRiskNum", cbm.getCompanyType() == 2 ? "-" : count);
        FcythSearchParam fcythSearchParam = new FcythSearchParam();
        fcythSearchParam.setUnifiedSocialCc(Objects.requireNonNull(UserUtils.getCurrentCompanyFromDataCenter()).getUnifiedSocialCc());
        PageInfo allZybPatientList = this.bxZybService.getZybPatientList(fcythSearchParam, Integer.valueOf(3));
        model.addAttribute("allZybNumber", (Object)(ObjectUtil.isNotNull((Object)allZybPatientList) ? allZybPatientList.getTotal() : 0L));
        fcythSearchParam.setYear(Integer.valueOf(thisYear));
        PageInfo thisYearZybPatientList = this.bxZybService.getZybPatientList(fcythSearchParam, Integer.valueOf(3));
        model.addAttribute("thisYearZybNumber", (Object)(ObjectUtil.isNotNull((Object)thisYearZybPatientList) ? thisYearZybPatientList.getTotal() : 0L));
        return "/supervisehomeV313";
    }

    @GetMapping(value={"/baseInfo"})
    public String baseInfo(Model model) {
        long cid = UserUtils.getLoginStaffCompanyId();
        CompanySuperviseModel superviseModel = this.superviseService.getCompanyInfoById(Long.valueOf(cid));
        model.addAttribute("company", (Object)superviseModel);
        CompanyGradeV3Rec companyGradeV3 = this.companyGradeV3TemporaryService.getGradeRecByCid(Long.valueOf(cid));
        CompanyGradeVoV3 companyGradeVoV3 = new CompanyGradeVoV3();
        model.addAttribute("Riskclass", (Object)"type-card-none");
        model.addAttribute("RiskClassifyclass", (Object)"type-card-none");
        model.addAttribute("JudgeResultClass", (Object)"type-card-none");
        if (companyGradeV3 != null) {
            BeanUtils.copyProperties((Object)companyGradeV3, (Object)companyGradeVoV3);
            this.setClassLow2Height(model, Optional.ofNullable(companyGradeV3.getRiskLevel()), "Riskclass");
            this.setClassLow2Height(model, Optional.ofNullable(companyGradeV3.getGrade()), "RiskClassifyclass");
            this.setClassLow2Height(model, Optional.ofNullable(companyGradeV3.getJudgeLevel()), "JudgeResultClass");
        }
        model.addAttribute("info", (Object)companyGradeVoV3);
        model.addAttribute("occTypeClass", (Object)this.setClassOccType(companyGradeVoV3.getOccType()));
        int thisYear = DateUtils.getYear();
        int prevYear = thisYear - 1;
        model.addAttribute("thisYear", (Object)thisYear);
        model.addAttribute("prevYear", (Object)prevYear);
        Integer jdnum = this.companyGradeV3TemporaryService.countSupInfoByCidAndYear(cid, thisYear);
        Integer cfnum = this.companyGradeV3TemporaryService.countLawInfoByCidAndYear(cid, thisYear);
        model.addAttribute("jdnum", (Object)jdnum);
        model.addAttribute("cfnum", (Object)cfnum);
        return "/homedatav2/baseInfo";
    }

    private void setClassLow2Height(Model model, Optional<Integer> riskLevel, String riskclass) {
        if (riskLevel.isPresent()) {
            switch (riskLevel.get()) {
                case 1: {
                    model.addAttribute(riskclass, (Object)"type-card-success");
                    break;
                }
                case 2: {
                    model.addAttribute(riskclass, (Object)"type-card-warning");
                    break;
                }
                case 3: {
                    model.addAttribute(riskclass, (Object)"type-card-danger");
                    break;
                }
                default: {
                    model.addAttribute(riskclass, (Object)"type-card-none");
                    break;
                }
            }
        } else {
            model.addAttribute(riskclass, (Object)"type-card-none");
        }
    }

    private String setClassOccType(Integer occType) {
        String classes = "type-card-none";
        if (occType == null) {
            return classes;
        }
        switch (occType) {
            case 3: {
                return "type-card-primary";
            }
            case 2: {
                return "type-card-success";
            }
            case 0: {
                return "type-card-danger";
            }
        }
        return "type-card-none";
    }

    @RequestMapping(value={"occStaffPage"})
    public String occStaff(Model model) throws Exception {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = UserUtils.getLoginStaffCompanyId();
        int thisYear = DateUtils.getYear();
        model.addAttribute("thisYear", (Object)thisYear);
        String unifiedSocialCc = currentCompany.getUnifiedSocialCc();
        Map map = this.getCacheData(CACHE_NAME, "getPhyCheckCount" + cid, () -> this.helper.basePhyCheckCount(cid, unifiedSocialCc));
        model.addAttribute("data", (Object)map);
        Integer total = this.getCacheData(CACHE_NAME, "getPhyCheckJdNum" + cid, () -> {
            PhcThirdOccupationalDiseaserParamVo vo = new PhcThirdOccupationalDiseaserParamVo();
            vo.setCid(cid);
            vo.setReportStatus(Byte.valueOf((byte)10));
            vo.setDiagnosedType(DiagnosedTypeEnum.appraisal.getCode());
            return this.supervisePhcPhysicalOdService.getCheckNum(vo);
        });
        Integer total1 = this.getCacheData(CACHE_NAME, "getPhyCheckZDNum" + cid, () -> {
            PhcThirdOccupationalDiseaserParamVo vo = new PhcThirdOccupationalDiseaserParamVo();
            vo.setCid(cid);
            vo.setReportStatus(Byte.valueOf((byte)10));
            vo.setDiagnosedType(DiagnosedTypeEnum.diagnosed.getCode());
            return this.supervisePhcPhysicalOdService.getCheckNum(vo);
        });
        model.addAttribute("total", (Object)(total + total1));
        model.addAttribute("totalAppraisal", (Object)total);
        model.addAttribute("totalDiagnosed", (Object)total1);
        return "/homedata/occstaffV310";
    }

    @RequestMapping(value={"physicacheckPage"})
    public String physicacheckPage(Model model) throws Exception {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = UserUtils.getLoginStaffCompanyId();
        int thisYear = DateUtils.getYear();
        Date endTime = new Date(thisYear - 1900, 0, 1);
        model.addAttribute("endTime", (Object)endTime);
        model.addAttribute("thisYear", (Object)thisYear);
        String unifiedSocialCc = currentCompany.getUnifiedSocialCc();
        Integer currYearCheckNum = this.phcPhysicalCheckService.getCheckNumByCid(cid, Integer.valueOf(thisYear));
        Integer preYearCheckNum = this.phcPhysicalCheckService.getCheckNumByCid(cid, Integer.valueOf(thisYear - 1));
        model.addAttribute("currYearCheckNum", (Object)currYearCheckNum);
        model.addAttribute("preYearCheckNum", (Object)preYearCheckNum);
        Map<String, Integer> map2 = this.helper.phyCheckSuspectDiseaseCount(cid, unifiedSocialCc);
        model.addAttribute("yearSuspectDiseaseCount", (Object)map2.get("yearSuspectDiseaseCount"));
        model.addAttribute("preyearSuspectDiseaseCount", (Object)map2.get("allSuspectDiseaseCount"));
        Map<String, Integer> map3 = this.helper.phyCheckOCCount(cid, unifiedSocialCc);
        model.addAttribute("yearOcCount", (Object)map3.get("yearOcCount"));
        model.addAttribute("preyearOcCount", (Object)map3.get("ocCount"));
        if (currYearCheckNum == null || currYearCheckNum == 0) {
            model.addAttribute("currYearCheckNum", (Object)"\u672a\u8fdb\u884c");
            model.addAttribute("yearSuspectDiseaseCount", (Object)"\u672a\u8fdb\u884c");
            model.addAttribute("yearOcCount", (Object)"\u672a\u8fdb\u884c");
        }
        if (preYearCheckNum == null || preYearCheckNum == 0) {
            model.addAttribute("preYearCheckNum", (Object)"\u672a\u8fdb\u884c");
            model.addAttribute("preyearSuspectDiseaseCount", (Object)"\u672a\u8fdb\u884c");
            model.addAttribute("preyearOcCount", (Object)"\u672a\u8fdb\u884c");
        }
        return "/homedatav2/physicacheckV310";
    }

    @GetMapping(value={"thirdtimePage"})
    public String thirdtimePage(Model model) throws Exception {
        int year = DateUtils.getYear();
        int thisYear = DateUtils.getYear();
        model.addAttribute("thisYear", (Object)thisYear);
        int prevYear = thisYear - 1;
        long cid = UserUtils.getLoginStaffCompanyId();
        Map countForVisualize = this.tsProjectSimpleService.getCountForVisualize(Long.valueOf(cid));
        Map preMap = countForVisualize.getOrDefault("\u9884\u8bc4", new HashMap());
        Map controMap = countForVisualize.getOrDefault("\u63a7\u8bc4", new HashMap());
        Object thisYearPreENum = preMap.getOrDefault(thisYear, null);
        Object thisYearContrENum = controMap.getOrDefault(thisYear, null);
        Object preYearPreENum = preMap.getOrDefault(thisYear - 1, null);
        Object preYearContrENum = controMap.getOrDefault(thisYear - 1, null);
        Object thisYearPreEStr = "";
        Object thisYearContrEStr = "";
        Object preYearPreEStr = "";
        Object preYearContrEStr = "";
        thisYearPreEStr = thisYearPreENum == null ? "\u65e0" : String.valueOf(thisYearPreENum);
        thisYearContrEStr = thisYearContrENum == null ? "\u65e0" : String.valueOf(thisYearContrENum);
        preYearPreEStr = preYearPreENum == null ? "\u65e0" : String.valueOf(preYearPreENum);
        preYearContrEStr = preYearContrENum == null ? "\u65e0" : String.valueOf(preYearContrENum);
        model.addAttribute("thisYearPreEStr", thisYearPreEStr);
        model.addAttribute("thisYearContrEStr", thisYearContrEStr);
        model.addAttribute("preYearPreEStr", preYearPreEStr);
        model.addAttribute("preYearContrEStr", preYearContrEStr);
        return "/homedatav2/thirdtimeV310";
    }

    @RequestMapping(value={"tranPage"})
    public String tranPage(Model model) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int thisYear = DateUtils.getYear();
        TrainPlanCountView view = this.trainPlanService.getTrainPlanCountView(cid);
        model.addAttribute("thisYear", (Object)thisYear);
        model.addAttribute("train", (Object)view);
        return "/homedatav2/tranV310";
    }

    @RequestMapping(value={"archivePage"})
    public String archivePage(Model model) throws Exception {
        int thisYear = DateUtils.getYear();
        model.addAttribute("thisYear", (Object)thisYear);
        Long cid = UserUtils.getLoginStaffCompanyId();
        ZjArchiveCountView view = this.liteArchiveService.getZjArchiveCountViewByCid(cid);
        model.addAttribute("archive", (Object)view);
        return "/homedatav2/archiveV310";
    }

    @GetMapping(value={"/RectificationPage"})
    public String RectificationPage(Model model) {
        Map<String, Integer> stringIntegerMap = this.RectificationPageMap();
        model.addAllAttributes(stringIntegerMap);
        return "/homedatav2/rectificationV310";
    }

    public Map<String, Integer> RectificationPageMap() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map finishNumMap = this.reformItemBasicService.getFinishedNumByGenerationSource(cid);
        Map unFinishNumMap = this.reformItemBasicService.getUnFinishedNumByGenerationSource(cid);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer finishedNum = finishNumMap.get(3) != null ? (Integer)finishNumMap.get(3) : 0;
        Integer unFinishedNum = unFinishNumMap.get(3) != null ? (Integer)unFinishNumMap.get(3) : 0;
        result.put("finishedNum", finishedNum);
        result.put("unFinishedNum", unFinishedNum);
        Integer OccuNum = finishNumMap.get(4) != null ? (Integer)finishNumMap.get(4) : 0;
        Integer UnOccuNum = unFinishNumMap.get(4) != null ? (Integer)unFinishNumMap.get(4) : 0;
        result.put("OccuNum", OccuNum);
        result.put("UnOccuNum", UnOccuNum);
        Integer SuspectNum = finishNumMap.get(5) != null ? (Integer)finishNumMap.get(5) : 0;
        Integer UnSuspectNum = unFinishNumMap.get(5) != null ? (Integer)unFinishNumMap.get(5) : 0;
        result.put("SuspectNum", SuspectNum);
        result.put("UnSuspectNum", UnSuspectNum);
        Integer reviewNum = finishNumMap.get(6) != null ? (Integer)finishNumMap.get(6) : 0;
        Integer UnreviewNum = unFinishNumMap.get(6) != null ? (Integer)unFinishNumMap.get(6) : 0;
        result.put("reviewNum", reviewNum);
        result.put("UnreviewNum", UnreviewNum);
        Integer cameraNum = finishNumMap.get(9) != null ? (Integer)finishNumMap.get(9) : 0;
        Integer UncameraNum = unFinishNumMap.get(9) != null ? (Integer)unFinishNumMap.get(9) : 0;
        result.put("cameraNum", cameraNum);
        result.put("UncameraNum", UncameraNum);
        Integer monitorNum = finishNumMap.get(8) != null ? (Integer)finishNumMap.get(8) : 0;
        Integer UnmonitorNum = unFinishNumMap.get(8) != null ? (Integer)unFinishNumMap.get(8) : 0;
        result.put("monitorNum", monitorNum);
        result.put("UnmonitorNum", UnmonitorNum);
        Integer selfNum = finishNumMap.get(1) != null ? (Integer)finishNumMap.get(1) : 0;
        Integer UnselfNum = unFinishNumMap.get(1) != null ? (Integer)unFinishNumMap.get(1) : 0;
        result.put("selfNum", selfNum);
        result.put("UnselfNum", UnselfNum);
        return result;
    }

    @RequestMapping(value={"keyworkPage"})
    public String keyworkPage(Model model) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List data = this.getCacheData(CACHE_NAME, "getZjHomeDataWorkByCid" + cid, () -> this.zjHomeWorkDataService.getZjHomeDataWorkByCid(cid));
        model.addAttribute("homeData", (Object)data);
        return "/homedata/keywork";
    }

    @RequestMapping(value={"selfPage"})
    public String selfPage(Model model) throws Exception {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = currentCompany.getId();
        String unifiedSocialCc = currentCompany.getUnifiedSocialCc();
        List list = this.getCacheData(CACHE_NAME, "selfJudge" + cid + unifiedSocialCc, () -> this.helper.selfJudge(cid, unifiedSocialCc));
        model.addAttribute("lastYear", list.get(0));
        model.addAttribute("year", list.get(1));
        return "/homedata/self";
    }

    @Log(title="\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58", type=21)
    @RequestMapping(value={"/updateOccType"}, method={RequestMethod.POST})
    @ResponseBody
    @RepeatUrlFormData
    public ResponseData<Company> updateOccTypeByInduId(Long induId) {
        ResponseData resultData = new ResponseData();
        long cid = UserUtils.getLoginStaffCompanyId();
        this.companyProvideByHSEService.updateIndustryCategory(induId, Long.valueOf(cid));
        resultData.setContent("\u4fee\u6539\u6210\u529f");
        return resultData;
    }

    @Log(title="\u91cd\u7f6e\u9996\u9875\u5de5\u4f5c\u63d0\u9192", type=21)
    @RequestMapping(value={"/clearWorkRemind"}, method={RequestMethod.POST})
    @ResponseBody
    @RepeatUrlFormData
    public ResponseData<Company> workRemindService(SysWorkRemind workRemind) {
        ResponseData resultData = new ResponseData();
        long cid = UserUtils.getLoginStaffCompanyId();
        Long currentUserId = UserUtils.getCurrentUserId();
        workRemind.setCid(Long.valueOf(cid));
        workRemind.setUpdateDate(new Date());
        workRemind.setStatus(Integer.valueOf(0));
        workRemind.setUpdateBy(currentUserId);
        this.workRemindService.updateWorkRemind(workRemind);
        resultData.setContent("\u4fee\u6539\u6210\u529f");
        return resultData;
    }

    @RequestMapping(value={"keyworkpage"})
    public String keyworkpage(Model model, String work) throws Exception {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = currentCompany.getId();
        model.addAttribute("work", (Object)work);
        return "/homedatav2/keyworkpage";
    }
}

