/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserParamVo;
import cn.smarthse.modules.health.enums.check.DiagnosedTypeEnum;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportHarmJudgeInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendExpireService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.modules.health.service.work.zjhome.IZjHomeWorkDataService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalOdService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.service.supervisionlaw.ISupervisionLawService;
import cn.smarthse.modules.health.supervise.service.sys.ISysParamService;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.modules.health.vo.work.train.TrainPlanCountView;
import cn.smarthse.services.hfi.api.pojo.vo.CompanyCheckListVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.ICheckStatisticService;
import cn.smarthse.util.common.date.DateUtils;
import cn.smarthse.web.controller.CacheControllerSupport;
import cn.smarthse.web.controller.HomeControllerHelper;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/indexhome"})
public class IndexHomeController
extends CacheControllerSupport {
    @Autowired
    private HomeControllerHelper helper;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService superviseService;
    @DubboReference
    ILiteArchiveService liteArchiveService;
    @DubboReference
    ITrainPlanService trainPlanService;
    @DubboReference
    IZjHomeWorkDataService zjHomeWorkDataService;
    @DubboReference
    private IOnlineDeviceService onlineDeviceService;
    @DubboReference
    ICheckResultService checkResultService;
    @DubboReference
    ISelfInspectionRiskAssessmentReportHarmJudgeInfoService selfInspectionRiskAssessmentReportHarmJudgeInfoService;
    @DubboReference
    ICompanyHsePreventionControlSelfJudgeService controlSelfJudgeService;
    @DubboReference
    IReformItemBasicService reformItemBasicService;
    @DubboReference
    private ICheckStatisticService checkStatisticService;
    @DubboReference
    ISupervisePhcPhysicalOdService supervisePhcPhysicalOdService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService hseService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @DubboReference
    ISysParamService sysParamService;
    @DubboReference
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    private IReformItemBasicService reformService;
    @DubboReference
    IShieldSendExpireService shieldSendExpireService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    ICompanyGradeV3Service companyGradeV3Service;
    @DubboReference
    ICompanyGradeV3RecService gradeV3RecService;
    private static final String CACHE_NAME = "index_home_cachename";
    @DubboReference(timeout=60000)
    private ISupervisionLawService supervisionLawService;

    @RequestMapping(method={RequestMethod.GET})
    @RequiresPermissions(value={"visual"})
    public String page_loginIndex(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyBaseInfoModel cbm = this.companyProvideByHSEService.getCompanyById(cid);
        this.session.setAttribute("isDec", (Object)cbm.getIsDec());
        if (Objects.equals(UserUtils.getPrincipal().getIsNewCompanyGuide(), true)) {
            return "redirect:/newCompanyGuide/index";
        }
        if (Objects.equals(UserUtils.getPrincipal().getIsYcPro(), true)) {
            return "redirect:/microcom/base/classificationSelfAssessment/selfJudge/listPage";
        }
        return Objects.equals(cbm.getIsDec(), true) ? "redirect:/indexhomev2" : "redirect:/company/index";
    }

    private void setClassLow2Height(Model model, Optional<Integer> riskLevel, String riskclass) {
        if (riskLevel.isPresent()) {
            switch (riskLevel.get()) {
                case 1: {
                    model.addAttribute(riskclass, (Object)"type-card-success");
                    break;
                }
                case 2: {
                    model.addAttribute(riskclass, (Object)"type-card-warning");
                    break;
                }
                case 3: {
                    model.addAttribute(riskclass, (Object)"type-card-danger");
                    break;
                }
                default: {
                    model.addAttribute(riskclass, (Object)"type-card-none");
                    break;
                }
            }
        } else {
            model.addAttribute(riskclass, (Object)"type-card-none");
        }
    }

    private String setClassOccType(Integer occType) {
        String classes = "type-card-none";
        if (occType == null) {
            return classes;
        }
        switch (occType) {
            case 3: {
                return "type-card-primary";
            }
            case 2: {
                return "type-card-success";
            }
            case 0: {
                return "type-card-danger";
            }
        }
        return "type-card-none";
    }

    private void setClassHeight2Low(Model model, Optional<Integer> riskLevel, String riskclass) {
        if (riskLevel.isPresent()) {
            switch (riskLevel.get()) {
                case 1: {
                    model.addAttribute(riskclass, (Object)"type-card-danger");
                    break;
                }
                case 2: {
                    model.addAttribute(riskclass, (Object)"type-card-warning");
                    break;
                }
                case 3: {
                    model.addAttribute(riskclass, (Object)"type-card-success");
                    break;
                }
                default: {
                    model.addAttribute(riskclass, (Object)"type-card-none");
                    break;
                }
            }
        } else {
            model.addAttribute(riskclass, (Object)"type-card-none");
        }
    }

    @RequestMapping(value={"occStaffPage"})
    public String occStaff(Model model) throws Exception {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = UserUtils.getLoginStaffCompanyId();
        int thisYear = DateUtils.getYear();
        model.addAttribute("thisYear", (Object)thisYear);
        String unifiedSocialCc = currentCompany.getUnifiedSocialCc();
        Map map = this.getCacheData(CACHE_NAME, "getPhyCheckCount" + cid, () -> this.helper.basePhyCheckCount(cid, unifiedSocialCc));
        model.addAttribute("data", (Object)map);
        Integer total = this.getCacheData(CACHE_NAME, "getPhyCheckJdNum" + cid, () -> {
            PhcThirdOccupationalDiseaserParamVo vo = new PhcThirdOccupationalDiseaserParamVo();
            vo.setCid(cid);
            vo.setReportStatus(Byte.valueOf((byte)10));
            vo.setDiagnosedType(DiagnosedTypeEnum.appraisal.getCode());
            return this.supervisePhcPhysicalOdService.getCheckNum(vo);
        });
        Integer total1 = this.getCacheData(CACHE_NAME, "getPhyCheckZDNum" + cid, () -> {
            PhcThirdOccupationalDiseaserParamVo vo = new PhcThirdOccupationalDiseaserParamVo();
            vo.setCid(cid);
            vo.setReportStatus(Byte.valueOf((byte)10));
            vo.setDiagnosedType(DiagnosedTypeEnum.diagnosed.getCode());
            return this.supervisePhcPhysicalOdService.getCheckNum(vo);
        });
        model.addAttribute("total", (Object)(total + total1));
        model.addAttribute("totalAppraisal", (Object)total);
        model.addAttribute("totalDiagnosed", (Object)total1);
        Integer jdnum = this.supervisionLawService.countSupInfoByCidAndYear(cid, Integer.valueOf(thisYear));
        Integer cfnum = this.supervisionLawService.countLawInfoByCidAndYear(cid, Integer.valueOf(thisYear));
        model.addAttribute("jdnum", (Object)jdnum);
        model.addAttribute("cfnum", (Object)cfnum);
        return "/homedata/occstaffV310";
    }

    @RequestMapping(value={"physicacheckPage"})
    public String physicacheckPage(Model model) throws Exception {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = UserUtils.getLoginStaffCompanyId();
        int thisYear = DateUtils.getYear();
        Date endTime = new Date(thisYear - 1900, 0, 1);
        model.addAttribute("endTime", (Object)endTime);
        model.addAttribute("thisYear", (Object)thisYear);
        String unifiedSocialCc = currentCompany.getUnifiedSocialCc();
        Map map = this.getCacheData(CACHE_NAME, "getPhyCount" + cid, () -> this.helper.phyCheckCount(cid, unifiedSocialCc));
        model.addAttribute("data", (Object)map);
        Map map2 = this.getCacheData(CACHE_NAME, "phyCheckSuspectDiseaseCount" + cid, () -> this.helper.phyCheckSuspectDiseaseCount(cid, unifiedSocialCc));
        model.addAttribute("data2", (Object)map2);
        Map map3 = this.getCacheData(CACHE_NAME, "phyCheckOCCount" + cid, () -> this.helper.phyCheckOCCount(cid, unifiedSocialCc));
        model.addAttribute("data3", (Object)map3);
        Map map4 = this.getCacheData(CACHE_NAME, "phyCheckReCheckCount" + cid, () -> this.helper.phyCheckReCheckCount(cid, unifiedSocialCc));
        model.addAttribute("data4", (Object)map4);
        return "homedata/physicacheckV310";
    }

    @GetMapping(value={"/monitorPage"})
    public String monitorPage(Model model) {
        model.addAttribute("thisYear", (Object)DateUtils.getYear());
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = currentCompany.getId();
        CompanyCheckListVo vo = this.getCacheData(CACHE_NAME, "monitorPage_countCheck_cache" + cid, () -> this.checkStatisticService.countCheck(cid));
        model.addAttribute("currentYearCount", (Object)(vo.getCurrentYearCount() == null ? 0 : vo.getCurrentYearCount()));
        model.addAttribute("currentPreCount", (Object)(vo.getPreYearCount() == null ? 0 : vo.getPreYearCount()));
        model.addAttribute("currentPre3Count", (Object)(vo.getPre3YearCount() == null ? 0 : vo.getPre3YearCount()));
        List dateDatas = this.getCacheData(CACHE_NAME, "monitorPage_getCheckBeginDates_cache" + cid, () -> this.checkStatisticService.getCheckBeginDates(cid));
        Integer oneYearRangeTotalCount = dateDatas.stream().collect(Collectors.summingInt(s -> s != null && LocalDate.now().plusYears(-1L).isBefore((ChronoLocalDate)s) && LocalDate.now().isAfter((ChronoLocalDate)s) ? 1 : 0));
        model.addAttribute("oneYearRangeTotalCount", (Object)(oneYearRangeTotalCount == null ? 0 : oneYearRangeTotalCount));
        Integer threeYearRangeTotalCount = dateDatas.stream().collect(Collectors.summingInt(s -> s != null && LocalDate.now().plusYears(-3L).isBefore((ChronoLocalDate)s) && LocalDate.now().isAfter((ChronoLocalDate)s) ? 1 : 0));
        model.addAttribute("threeYearRangeTotalCount", (Object)(threeYearRangeTotalCount == null ? 0 : threeYearRangeTotalCount));
        Integer preOneYearRangeTotalCount = dateDatas.stream().collect(Collectors.summingInt(s -> s != null && LocalDate.now().plusYears(-2L).isBefore((ChronoLocalDate)s) && LocalDate.now().plusYears(-1L).isAfter((ChronoLocalDate)s) ? 1 : 0));
        model.addAttribute("preOneYearRangeTotalCount", (Object)(preOneYearRangeTotalCount == null ? 0 : preOneYearRangeTotalCount));
        Integer preThreeYearRangeTotalCount = dateDatas.stream().collect(Collectors.summingInt(s -> s != null && LocalDate.now().plusYears(-4L).isBefore((ChronoLocalDate)s) && LocalDate.now().plusYears(-1L).isAfter((ChronoLocalDate)s) ? 1 : 0));
        model.addAttribute("preThreeYearRangeTotalCount", (Object)(preThreeYearRangeTotalCount == null ? 0 : preThreeYearRangeTotalCount));
        return "homedata/monitorV310";
    }

    @GetMapping(value={"/standardPointPage"})
    public String standardPointPage(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyCheckListVo vo = this.getCacheData(CACHE_NAME, "monitorPage_countCheck_cache" + cid, () -> this.checkStatisticService.countCheck(cid));
        model.addAttribute("currentYearCount", (Object)(vo.getCurrentYearCount() == null ? 0 : vo.getCurrentYearCount()));
        model.addAttribute("currentPreCount", (Object)(vo.getPreYearCount() == null ? 0 : vo.getPreYearCount()));
        int thisYear = DateUtils.getYear();
        int prevYear = thisYear - 1;
        List thislist = this.getCacheData(CACHE_NAME, "queryFactorTypeCheckPoint2-cache" + cid + thisYear, () -> this.checkResultService.queryFactorTypeCheckPoint2(cid, Integer.valueOf(thisYear)));
        List prelist = this.getCacheData(CACHE_NAME, "queryFactorTypeCheckPoint2-cache" + cid + prevYear, () -> this.checkResultService.queryFactorTypeCheckPoint2(cid, Integer.valueOf(prevYear)));
        model.addAttribute("thislist", (Object)thislist);
        model.addAttribute("prelist", (Object)prelist);
        return "homedata/standardpointV310";
    }

    @GetMapping(value={"thirdtimePage"})
    public String thirdtimePage(Model model) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int thisYear = DateUtils.getYear();
        int prevYear = thisYear - 1;
        model.addAttribute("thisYear", (Object)thisYear);
        return "/homedata/thirdtimeV310";
    }

    @RequestMapping(value={"tranPage"})
    public String tranPage(Model model) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int thisYear = DateUtils.getYear();
        TrainPlanCountView view = this.getCacheData(CACHE_NAME, "getTrainPlanCountView" + cid, () -> this.trainPlanService.getTrainPlanCountView(cid));
        model.addAttribute("thisYear", (Object)thisYear);
        model.addAttribute("train", (Object)view);
        return "/homedata/tranV310";
    }

    @RequestMapping(value={"archivePage"})
    public String archivePage(Model model) throws Exception {
        int thisYear = DateUtils.getYear();
        model.addAttribute("thisYear", (Object)thisYear);
        Long cid = UserUtils.getLoginStaffCompanyId();
        ZjArchiveCountView view = this.getCacheData(CACHE_NAME, "getZjArchiveCountViewByCid" + cid, () -> this.liteArchiveService.getZjArchiveCountViewByCid(cid));
        ZjArchiveCountView lastview = this.getCacheData(CACHE_NAME, "getLastZjArchiveCountViewByCid" + cid, () -> this.liteArchiveService.getLastZjArchiveCountViewByCid(cid));
        if (lastview != null && view != null) {
            lastview.setStaffState(view.getStaffState());
            lastview.setStaffStateStr(view.getStaffStateStr());
        }
        model.addAttribute("lastArchive", (Object)lastview);
        model.addAttribute("archive", (Object)view);
        return "/homedata/archiveV310";
    }

    private LocalDateTime calcCurrYearDate(LocalDateTime date1) {
        if (date1 != null) {
            int monthValue = date1.getMonthValue();
            int dayOfMonth = date1.getDayOfMonth();
            int year = LocalDate.now().getYear();
            LocalDateTime result = LocalDateTime.of(year, monthValue, dayOfMonth, 0, 0, 0);
            return result;
        }
        return null;
    }

    private LocalDateTime calcCurrYearDate(Date date1) {
        if (date1 != null) {
            LocalDateTime fromDate = DateUtils.getFromDate((Date)date1);
            return this.calcCurrYearDate(fromDate);
        }
        return null;
    }

    private LocalDate getThisYearDate(LocalDate date, Integer year, Integer month) {
        if (date == null || year != null) {
            // empty if block
        }
        return date;
    }

    public Date formatStringDate(String time) {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        Date reformDate = null;
        try {
            reformDate = ft.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return reformDate;
    }

    @GetMapping(value={"/RectificationPage"})
    public String RectificationPage(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map finishNumMap = this.getCacheData(CACHE_NAME, "getFinishedNumByGenerationSource" + cid, () -> this.reformItemBasicService.getFinishedNumByGenerationSource(cid));
        Map unFinishNumMap = this.getCacheData(CACHE_NAME, "getUnFinishedNumByGenerationSource" + cid, () -> this.reformItemBasicService.getUnFinishedNumByGenerationSource(cid));
        Integer finishedNum = finishNumMap.get(3) != null ? (Integer)finishNumMap.get(3) : 0;
        Integer unFinishedNum = unFinishNumMap.get(3) != null ? (Integer)unFinishNumMap.get(3) : 0;
        model.addAttribute("finishedNum", (Object)finishedNum);
        model.addAttribute("unFinishedNum", (Object)unFinishedNum);
        Integer OccuNum = finishNumMap.get(4) != null ? (Integer)finishNumMap.get(4) : 0;
        Integer UnOccuNum = unFinishNumMap.get(4) != null ? (Integer)unFinishNumMap.get(4) : 0;
        model.addAttribute("OccuNum", (Object)OccuNum);
        model.addAttribute("UnOccuNum", (Object)UnOccuNum);
        Integer SuspectNum = finishNumMap.get(5) != null ? (Integer)finishNumMap.get(5) : 0;
        Integer UnSuspectNum = unFinishNumMap.get(5) != null ? (Integer)unFinishNumMap.get(5) : 0;
        model.addAttribute("SuspectNum", (Object)SuspectNum);
        model.addAttribute("UnSuspectNum", (Object)UnSuspectNum);
        Integer reviewNum = finishNumMap.get(6) != null ? (Integer)finishNumMap.get(6) : 0;
        Integer UnreviewNum = unFinishNumMap.get(6) != null ? (Integer)unFinishNumMap.get(6) : 0;
        model.addAttribute("reviewNum", (Object)reviewNum);
        model.addAttribute("UnreviewNum", (Object)UnreviewNum);
        Integer cameraNum = finishNumMap.get(8) != null ? (Integer)finishNumMap.get(8) : 0;
        Integer UncameraNum = unFinishNumMap.get(8) != null ? (Integer)unFinishNumMap.get(8) : 0;
        model.addAttribute("cameraNum", (Object)cameraNum);
        model.addAttribute("UncameraNum", (Object)UncameraNum);
        Integer monitorNum = finishNumMap.get(9) != null ? (Integer)finishNumMap.get(9) : 0;
        Integer UnmonitorNum = unFinishNumMap.get(9) != null ? (Integer)unFinishNumMap.get(9) : 0;
        model.addAttribute("monitorNum", (Object)monitorNum);
        model.addAttribute("UnmonitorNum", (Object)UnmonitorNum);
        return "/homedata/rectificationV310";
    }

    @RequestMapping(value={"checkPlanPage"})
    public String checkPlanPage(Model model) throws Exception {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = currentCompany.getId();
        int thisYear = DateUtils.getYear();
        model.addAttribute("thisYear", (Object)thisYear);
        String unifiedSocialCc = currentCompany.getUnifiedSocialCc();
        Map map = this.getCacheData(CACHE_NAME, "factorCheckCount" + cid + unifiedSocialCc, () -> this.helper.factorCheckCount(cid, unifiedSocialCc));
        model.addAttribute("data", (Object)map);
        Map map2 = this.getCacheData(CACHE_NAME, "checkOverPointCount" + cid + unifiedSocialCc, () -> this.helper.checkOverPointCount(cid, unifiedSocialCc));
        model.addAttribute("data2", (Object)map2);
        return "/homedata/checkplan";
    }

    @RequestMapping(value={"keyworkPage"})
    public String keyworkPage(Model model) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List data = this.getCacheData(CACHE_NAME, "getZjHomeDataWorkByCid" + cid, () -> this.zjHomeWorkDataService.getZjHomeDataWorkByCid(cid));
        model.addAttribute("homeData", (Object)data);
        return "/homedata/keywork";
    }

    @RequestMapping(value={"selfPage"})
    public String selfPage(Model model) throws Exception {
        Company currentCompany = UserUtils.getCurrentCompany();
        Long cid = currentCompany.getId();
        String unifiedSocialCc = currentCompany.getUnifiedSocialCc();
        List list = this.getCacheData(CACHE_NAME, "selfJudge" + cid + unifiedSocialCc, () -> this.helper.selfJudge(cid, unifiedSocialCc));
        model.addAttribute("lastYear", list.get(0));
        model.addAttribute("year", list.get(1));
        return "/homedata/self";
    }

    @Log(title="\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58", type=21)
    @RequestMapping(value={"/updateOccType"}, method={RequestMethod.POST})
    @ResponseBody
    @RepeatUrlFormData
    public ResponseData<Company> updateOccTypeByInduId(Long induId) {
        ResponseData resultData = new ResponseData();
        long cid = UserUtils.getLoginStaffCompanyId();
        this.companyProvideByHSEService.updateIndustryCategory(induId, Long.valueOf(cid));
        resultData.setContent("\u4fee\u6539\u6210\u529f");
        return resultData;
    }
}

