/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeRecord;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeV308;
import cn.smarthse.modules.health.entity.work.check.vo.PhcOccupationalDiseaserParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormalParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserParamVo;
import cn.smarthse.modules.health.enums.check.DiagnosedAddFromEnum;
import cn.smarthse.modules.health.enums.check.DiagnosedTypeEnum;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeRecordService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalOdService;
import cn.smarthse.services.hfi.api.model.list.CheckPlanListParam;
import cn.smarthse.services.hfi.api.pojo.vo.CompanyCheckListVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckStatisticService;
import cn.smarthse.util.common.date.DateUtils;
import com.github.pagehelper.PageInfo;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HomeControllerHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HomeControllerHelper.class);
    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    @DubboReference
    private IPhcPhysicalCheckDataResultService phcPhysicalCheckDataResultService;
    @DubboReference
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    IPhcOccupationalDiseaserService phcOccupationalDiseaserService;
    @DubboReference
    private ICheckPlanService hazardCheckPlanService;
    @DubboReference
    private ICheckStatisticService checkStatisticService;
    @DubboReference
    private IOccupationalSelfJudgeRecordService selfJudgeRecordService;
    @DubboReference
    private ISupervisePhcPhysicalOdService supervisePhcPhysicalOdService;

    private JqGridParam getJqGridParam(Long cid) {
        JqGridParam jqGridParam = new JqGridParam();
        jqGridParam.setCid(cid);
        jqGridParam.setRows(1);
        jqGridParam.setPage(1);
        return jqGridParam;
    }

    private Date getNowYearStart() {
        try {
            return DateUtils.parseDate((String)(LocalDate.now().getYear() + "-01-01 00:00:00"), (String)TIME_PATTERN);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Date getNowYearEnd() {
        try {
            return DateUtils.parseDate((String)(LocalDate.now().getYear() + "-12-31 23:59:59"), (String)TIME_PATTERN);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Date getPreYearStart() {
        try {
            return DateUtils.parseDate((String)(LocalDate.now().getYear() - 1 + "-01-01 00:00:00"), (String)TIME_PATTERN);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Date getPreYearEnd() {
        try {
            return DateUtils.parseDate((String)(LocalDate.now().getYear() - 1 + "-12-31 23:59:59"), (String)TIME_PATTERN);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Integer> basePhyCheckCount(Long cid, String occCode) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        JqGridParam jqGridParam = this.getJqGridParam(cid);
        PhcOccupationalDiseaserParam param = new PhcOccupationalDiseaserParam();
        param.setCid(cid);
        map.put("allDiseaseCount", this.phcOccupationalDiseaserService.getSuperviseNum(param));
        param.setBeginTime(this.getNowYearStart());
        param.setEndTime(this.getNowYearEnd());
        map.put("yearDiseaseCount", this.phcOccupationalDiseaserService.getSuperviseNum(param));
        map.put("yearDiagnoseCount", this.zdCount(cid));
        map.put("yearAppraisalCount", this.jdCount(cid));
        return map;
    }

    private Integer zdCount(Long cid) {
        PhcThirdOccupationalDiseaserParamVo checkParam = new PhcThirdOccupationalDiseaserParamVo();
        checkParam.setDiagnosedType(DiagnosedTypeEnum.diagnosed.getCode());
        checkParam.setAddFrom(DiagnosedAddFromEnum.supervise.getCode());
        checkParam.setCid(cid);
        checkParam.setBeginTime(this.getNowYearStart());
        checkParam.setEndTime(this.getNowYearEnd());
        checkParam.setReportStatus(Byte.valueOf((byte)10));
        return this.supervisePhcPhysicalOdService.getCheckNum(checkParam);
    }

    private Integer jdCount(Long cid) {
        PhcThirdOccupationalDiseaserParamVo checkParam = new PhcThirdOccupationalDiseaserParamVo();
        checkParam.setDiagnosedType(DiagnosedTypeEnum.appraisal.getCode());
        checkParam.setAddFrom(DiagnosedAddFromEnum.supervise.getCode());
        checkParam.setCid(cid);
        checkParam.setBeginTime(this.getNowYearStart());
        checkParam.setEndTime(this.getNowYearEnd());
        checkParam.setReportStatus(Byte.valueOf((byte)10));
        return this.supervisePhcPhysicalOdService.getCheckNum(checkParam);
    }

    public Map<String, Integer> phyCheckCount(Long cid, String occCode) {
        HashMap lastYearMap;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        PhcPhysicalCheckParam param = new PhcPhysicalCheckParam();
        param.setCid(cid);
        Integer year = LocalDate.now().getYear();
        Integer lastYear = LocalDate.now().getYear() - 1;
        param.setCheckYear(year);
        Map checkTypeMap = this.phcPhysicalCheckService.getCheckTypeNum(param);
        HashMap thisYearMap = (HashMap)checkTypeMap.get(year);
        if (thisYearMap == null) {
            thisYearMap = new HashMap();
        }
        if ((lastYearMap = (HashMap)checkTypeMap.get(lastYear)) == null) {
            lastYearMap = new HashMap();
        }
        map.put("yearPhcCheckCount", thisYearMap.get(year.toString()) != null ? (Integer)thisYearMap.get(year.toString()) : 0);
        map.put("phcCheckCount", lastYearMap.get(lastYear.toString()) != null ? (Integer)lastYearMap.get(lastYear.toString()) : 0);
        map.put("PreOnDuty", lastYearMap.get("2") != null ? (Integer)lastYearMap.get("2") : 0);
        map.put("thisYearOnDuty", thisYearMap.get("2") != null ? (Integer)thisYearMap.get("2") : 0);
        map.put("PreBeforeDuty", lastYearMap.get("1") != null ? (Integer)lastYearMap.get("1") : 0);
        map.put("thisYearBeforeDuty", thisYearMap.get("1") != null ? (Integer)thisYearMap.get("1") : 0);
        map.put("PreLeaveDuty", lastYearMap.get("3") != null ? (Integer)lastYearMap.get("3") : 0);
        map.put("thisYearLeaveDuty", thisYearMap.get("3") != null ? (Integer)thisYearMap.get("3") : 0);
        return map;
    }

    public Map<String, Integer> phyCheckCount2(Long cid, String occCode) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        PhcPhysicalCheckParam param = new PhcPhysicalCheckParam();
        param.setCid(cid);
        Integer year = LocalDate.now().getYear();
        Integer lastYear = LocalDate.now().getYear() - 1;
        param.setCheckYear(year);
        Integer currYearCheckNum = this.phcPhysicalCheckService.getCheckNumByCid(cid, year);
        Integer preYearCheckNum = this.phcPhysicalCheckService.getCheckNumByCid(cid, Integer.valueOf(year - 1));
        map.put("currYearCheckNum", currYearCheckNum != null ? currYearCheckNum : 0);
        map.put("preYearCheckNum", preYearCheckNum != null ? preYearCheckNum : 0);
        return map;
    }

    public Map<String, Integer> phyCheckSuspectDiseaseCount(Long cid, String occCode) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        PhcPhysicalCheckAbnormalParam param = new PhcPhysicalCheckAbnormalParam();
        param.setCid(cid);
        param.setCheckYear(Integer.valueOf(LocalDate.now().getYear()));
        long thisYearNum = this.phcPhysicalCheckDataResultService.getSDNum(param).intValue();
        param.setCheckYear(Integer.valueOf(LocalDate.now().getYear() - 1));
        long preYearNum = this.phcPhysicalCheckDataResultService.getSDNum(param).intValue();
        map.put("yearSuspectDiseaseCount", (int)thisYearNum);
        map.put("allSuspectDiseaseCount", (int)preYearNum);
        return map;
    }

    public Map<String, Integer> phyCheckOCCount(Long cid, String occCode) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        PhcPhysicalCheckAbnormalParam param = new PhcPhysicalCheckAbnormalParam();
        param.setCid(cid);
        param.setBeginTime(this.getNowYearStart());
        param.setEndTime(this.getNowYearEnd());
        Integer thisYearNum = this.phcPhysicalCheckDataResultService.getOCNum(param);
        map.put("yearOcCount", thisYearNum);
        param.setBeginTime(this.getPreYearStart());
        param.setEndTime(this.getPreYearEnd());
        Integer preYearNum = this.phcPhysicalCheckDataResultService.getOCNum(param);
        map.put("ocCount", preYearNum);
        return map;
    }

    public Map<String, Integer> phyCheckReCheckCount(Long cid, String occCode) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        PhcPhysicalCheckAbnormalParam param = new PhcPhysicalCheckAbnormalParam();
        param.setCid(cid);
        Integer totalNum = this.phcPhysicalCheckDataResultService.getRecheckNum(param);
        param.setBeginTime(this.getNowYearStart());
        param.setEndTime(this.getNowYearEnd());
        Integer thisYearNum = this.phcPhysicalCheckDataResultService.getRecheckNum(param);
        map.put("reCheckCount", totalNum - thisYearNum);
        map.put("yearReCheckCount", thisYearNum);
        return map;
    }

    public Map<String, Integer> factorCheckCount(Long cid, String occCode) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        JqGridParam jqGridParam = this.getJqGridParam(cid);
        CheckPlanListParam hc = new CheckPlanListParam();
        hc.setStatus(Collections.singletonList(2));
        hc.setCid(cid);
        PageInfo pageInfo = this.hazardCheckPlanService.getCheckPlanPage(jqGridParam, hc, Boolean.valueOf(true));
        long totalNum = pageInfo.getTotal();
        hc.setCheckDateBegin(this.getNowYearStart());
        hc.setCheckDateEnd(this.getNowYearEnd());
        pageInfo = this.hazardCheckPlanService.getCheckPlanPage(jqGridParam, hc, Boolean.valueOf(true));
        long thisYearNum = pageInfo.getTotal();
        map.put("yearCheckPlanCount", (int)thisYearNum);
        map.put("checkPlanCount", (int)(totalNum - thisYearNum));
        return map;
    }

    public Map<String, Integer> getmonitorNum(Long cid) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        CompanyCheckListVo vo = this.checkStatisticService.countCheck(cid);
        map.put("currentYearCount", vo.getCurrentYearCount());
        map.put("PreCount", vo.getTotalCount() - vo.getCurrentYearCount());
        return map;
    }

    public Map<String, Integer> evaluateCheckOverPointCount(Long cid, String occCode) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        return map;
    }

    public Map<String, Integer> checkOverPointCount(Long cid, String occCode) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Integer allCount = this.checkStatisticService.countOverPoint(cid, null, null);
        Integer yearCount = this.checkStatisticService.countOverPoint(cid, Integer.valueOf(LocalDate.now().getYear()), null);
        map.put("allCheckOverPointCount", allCount - yearCount);
        map.put("yearCheckOverPointCount", yearCount);
        return map;
    }

    public List<Map<String, String>> selfJudge(Long cid, String occCode) {
        LinkedList<Map<String, String>> list = new LinkedList<Map<String, String>>();
        Integer year = LocalDate.now().getYear();
        OccupationalSelfJudgeV308 record = this.selfJudgeRecordService.getLastJudgeV308(cid, Integer.valueOf(year - 1), Integer.valueOf(2));
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("year", "" + (year - 1));
        map1.put("level", this.getJudgeLevelStrV308(record));
        map1.put("classes", this.getJudgeLevelClassV308(record));
        if (record != null) {
            map1.put("id", "" + record.getId());
        }
        list.add(map1);
        record = this.selfJudgeRecordService.getLastJudgeV308(cid, year, Integer.valueOf(2));
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("year", "" + year);
        map2.put("level", this.getJudgeLevelStrV308(record));
        map2.put("classes", this.getJudgeLevelClassV308(record));
        if (record != null) {
            map2.put("id", "" + record.getId());
        }
        list.add(map2);
        return list;
    }

    private String getJudgeLevelStr(OccupationalSelfJudgeRecord record) {
        if (record == null) {
            return "\u672a\u8bc4\u5b9a";
        }
        switch (record.getResultLevel()) {
            case 1: {
                return "A\u7ea7";
            }
            case 2: {
                return "B\u7ea7";
            }
            case 3: {
                return "C\u7ea7";
            }
        }
        return "\u672a\u8bc4\u5b9a";
    }

    private String getJudgeLevelStrV308(OccupationalSelfJudgeV308 record) {
        if (record == null) {
            return "\u672a\u8bc4\u5b9a";
        }
        switch (record.getResultLevel()) {
            case 1: {
                return "A\u7ea7";
            }
            case 2: {
                return "B\u7ea7";
            }
            case 3: {
                return "C\u7ea7";
            }
        }
        return "\u672a\u8bc4\u5b9a";
    }

    private String getJudgeLevelClass(OccupationalSelfJudgeRecord record) {
        if (record == null) {
            return "bg-danger";
        }
        switch (record.getResultLevel()) {
            case 1: {
                return "bg-success";
            }
            case 2: {
                return "bg-warning";
            }
            case 3: {
                return "bg-danger";
            }
        }
        return "bg-success";
    }

    private String getJudgeLevelClassV308(OccupationalSelfJudgeV308 record) {
        if (record == null) {
            return "bg-danger";
        }
        switch (record.getResultLevel()) {
            case 1: {
                return "bg-success";
            }
            case 2: {
                return "bg-warning";
            }
            case 3: {
                return "bg-danger";
            }
        }
        return "bg-success";
    }
}

