/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller;

import cn.smarthse.common.util.CookieUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.health.supervise.model.CreateUserModel;
import cn.smarthse.modules.health.supervise.model.CreateUserResult;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.security.shiro.ShiroUsernamePasswordToken;
import cn.smarthse.web.util.Pair;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/essologin"})
public class EssoLoginController
extends ControllerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EssoLoginController.class);
    @Value(value="${apiUrl:}")
    public String apiUrl;
    @Value(value="${accessKey:}")
    public String accessKey;
    @Value(value="${secretKey:}")
    public String secretKey;
    @DubboReference(timeout=60000, check=false)
    private ISysUserThirdService sysUserThirdService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideService;
    @DubboReference
    ISysUserService userService;

    @RequestMapping(value={"callback"})
    public String page_loginIndex(HttpServletRequest request, HttpServletResponse response, Model model) throws UnsupportedEncodingException, BusinessException {
        JSONObject jsonObj;
        int errCode;
        this.logger.info("\u5355\u70b9\u767b\u5f55\u9875\uff1a\uff1a{}", (Object)this.adminPath);
        request.setCharacterEncoding("UTF-8");
        String ssoticket = request.getParameter("ssoticket");
        String ssotoken = request.getParameter("ssotoken");
        log.info("ssoticket:{}, ssotoken:{}", (Object)ssoticket, (Object)ssotoken);
        String gotoUrl = request.getQueryString();
        if (StringUtils.isNotBlank((CharSequence)gotoUrl)) {
            gotoUrl = gotoUrl.substring(5);
            log.info("\u5177\u4f53\u4e1a\u52a1\u529e\u7406\u5730\u5740\uff1a {}", (Object)gotoUrl);
        }
        if (0 == (errCode = (jsonObj = this.createSign(ssotoken)).getInteger("errCode").intValue())) {
            String info = jsonObj.getString("info");
            log.info("\u9a8c\u8bc1\u4ee4\u724c\u5e76\u83b7\u53d6\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)info);
            JSONObject legalInfo = JSONObject.parseObject((String)info);
            String companyName = legalInfo.get((Object)"CompanyName").toString();
            if (StringUtils.isBlank((CharSequence)companyName)) {
                model.addAttribute("msg", (Object)"\u4f01\u4e1a\u540d\u79f0\u4e3a\u7a7a\uff01");
                return "single_login";
            }
            try {
                CompanySuperviseModel companySuperviseModel = this.companyProvideService.getByCompanyName(companyName, Integer.valueOf(1));
                if (companySuperviseModel == null) {
                    model.addAttribute("msg", (Object)String.format("\u4f01\u4e1a\u540d\u79f0\uff1a%s, \u5728\u6d59\u91cc\u536b\u4f01\u4e2d\u4e0d\u5b58\u5728\uff01", companyName));
                    return "single_login";
                }
                SysUser user = this.userService.getUserByuserameAndCid(companyName, companySuperviseModel.getId());
                if (user == null) {
                    user = this.createUser(companyName, companySuperviseModel.getId());
                }
                if (user.getId() == null) {
                    user = this.userService.getUserByuserameAndCid(companyName, companySuperviseModel.getId());
                }
                ShiroUsernamePasswordToken shiroUsernamePasswordToken = new ShiroUsernamePasswordToken(0, UserSystemWideEnum.ZLWQ_COMPANY.getCode());
                shiroUsernamePasswordToken.setUsername(companyName);
                shiroUsernamePasswordToken.setUserId(user.getId());
                SecurityUtils.getSubject().login((AuthenticationToken)shiroUsernamePasswordToken);
                CookieUtil.setCookie((HttpServletResponse)response, (String)"uid", (String)user.getId().toString(), (int)31536000);
            }
            catch (Exception re) {
                log.error("\u767b\u5f55\u5f02\u5e38\uff1a", (Throwable)re);
                model.addAttribute("msg", (Object)("\u767b\u5f55\u51fa\u9519:" + re.getMessage()));
                return "single_login";
            }
        } else {
            log.error("\u767b\u5f55\u5931\u8d25...");
        }
        return "redirect:/indexhomev2";
    }

    public JSONObject createSign(String token) {
        JSONObject obj = null;
        String resp = null;
        try {
            JSONObject ReqData = new JSONObject();
            ReqData.put("token", (Object)token);
            resp = this.post(ReqData, "post");
            obj = JSONObject.parseObject((String)resp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public String post(JSONObject data, String requestMethod) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = dateFormat.format(new Date());
        URL url = new URL(this.apiUrl);
        URI uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null);
        String canonicalQueryString = EssoLoginController.getCanonicalQueryString(uri.getQuery());
        String message = requestMethod.toUpperCase() + "\n" + uri.getPath() + "\n" + canonicalQueryString + "\n" + this.accessKey + "\n" + date + "\n";
        log.info("\u8bf7\u6c42\u53c2\u6570 message:{}", (Object)message);
        Mac hasher = Mac.getInstance("HmacSHA256");
        hasher.init(new SecretKeySpec(this.secretKey.getBytes(), "HmacSHA256"));
        byte[] hash = hasher.doFinal(message.getBytes());
        DatatypeConverter.printHexBinary((byte[])hash);
        String sign = DatatypeConverter.printBase64Binary((byte[])hash);
        log.info("\u7b7e\u540dsign\uff1a{}", (Object)sign);
        byte[] stream = data.toString().getBytes("UTF-8");
        HttpPost req = new HttpPost(this.apiUrl);
        req.addHeader("X-BG-HMAC-SIGNATURE", sign);
        req.addHeader("X-BG-HMAC-ALGORITHM", "hmac-sha256");
        req.addHeader("X-BG-HMAC-ACCESS-KEY", this.accessKey);
        req.addHeader("X-BG-DATE-TIME", date);
        req.addHeader("Content-Type", "application/json");
        ByteArrayEntity entity = new ByteArrayEntity(stream, ContentType.create((String)ContentType.APPLICATION_JSON.getMimeType(), (String)"UTF-8"));
        req.setEntity((HttpEntity)entity);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient cli = httpClientBuilder.build();
        CloseableHttpResponse res = cli.execute((HttpUriRequest)req);
        int statusCode = res.getStatusLine().getStatusCode();
        log.info("statusCode:{}", (Object)statusCode);
        InputStream in = res.getEntity().getContent();
        byte[] resp = EssoLoginController.readStream(in);
        String strRes = new String(resp, "UTF-8");
        log.info("\u8bf7\u6c42\u54cd\u5e94\u7ed3\u679c\uff1a strRes:{}", (Object)strRes);
        cli.close();
        return strRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStream(InputStream in) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[10240];
        try {
            int n = 0;
            while ((n = in.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            in.close();
            output.close();
        }
    }

    private static String getCanonicalQueryString(String query) {
        String[] params;
        if (query == null || query.trim().length() == 0) {
            return "";
        }
        ArrayList<Pair<String, String>> queryParamList = new ArrayList<Pair<String, String>>();
        for (String param2 : params = query.split("&")) {
            int eqIndex = param2.indexOf("=");
            String key = param2.substring(0, eqIndex);
            String value = param2.substring(eqIndex + 1);
            Pair<String, String> pair = new Pair<String, String>(key, value);
            queryParamList.add(pair);
        }
        List sortedParamList = queryParamList.stream().sorted(Comparator.comparing(param -> (String)param.getKey() + "=" + Optional.ofNullable((String)param.getValue()).orElse(""))).collect(Collectors.toList());
        ArrayList encodeParamList = new ArrayList();
        sortedParamList.stream().forEach(param -> {
            try {
                String key = URLEncoder.encode((String)param.getKey(), "utf-8");
                String value = URLEncoder.encode(Optional.ofNullable((String)param.getValue()).orElse(""), "utf-8").replaceAll("\\%2B", "%20").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~").replaceAll("\\%25", "%");
                encodeParamList.add(new Pair<String, String>(key, value));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("encoding error");
            }
        });
        StringBuilder queryParamString = new StringBuilder(64);
        for (Pair encodeParam : encodeParamList) {
            queryParamString.append((String)encodeParam.getKey()).append("=").append(Optional.ofNullable((String)encodeParam.getValue()).orElse(""));
            queryParamString.append("&");
        }
        return queryParamString.substring(0, queryParamString.length() - 1);
    }

    private SysUser createUser(String companyName, Long cid) {
        ArrayList<CreateUserModel> list = new ArrayList<CreateUserModel>();
        CreateUserModel createUserModel = new CreateUserModel();
        createUserModel.setCid(cid);
        createUserModel.setUsername(companyName);
        createUserModel.setPassword("Zyj@2022");
        list.add(createUserModel);
        CreateUserResult createUserResult = this.sysUserThirdService.create(list);
        SysUser user = new SysUser();
        if (CollectionUtils.isNotEmpty((Collection)createUserResult.getCreateUserModelList())) {
            user.setId(((CreateUserModel)createUserResult.getCreateUserModelList().get(0)).getUserId());
        }
        return user;
    }
}

