/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.beanvalidator.BeanValidators;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.web.enums.EmptyUpdateEntity;
import cn.smarthse.web.util.UserUtils;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public abstract class ControllerSupport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    protected OssClientBean ossClientBean;
    @Resource
    protected HttpSession session;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService fileService;
    @Value(value="${adminPath}")
    protected String adminPath;
    @Value(value="${isActualize}")
    protected String isActualize;
    @Value(value="${isChangxing}")
    protected String isChangXing;
    @Value(value="${isHuadong}")
    protected String isHuaDong;
    @Value(value="${isSharingSystem}")
    protected String isSharingSystem;
    @Value(value="${isZjProj}")
    protected String isZjProj;
    @Autowired
    protected Validator validator;
    @Autowired
    protected RedissonClient redissonClient;

    protected boolean beanValidator(Model model, Object object, Class<?> ... groups) {
        try {
            BeanValidators.validateWithException((Validator)this.validator, (Object)object, (Class[])groups);
        }
        catch (ConstraintViolationException ex) {
            List list = BeanValidators.extractPropertyAndMessageAsList((ConstraintViolationException)ex, (String)": ");
            list.add(0, "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a");
            this.addMessage(model, list.toArray(new String[0]));
            return false;
        }
        return true;
    }

    protected void addMessage(Model model, String ... messages) {
        StringBuilder sb = new StringBuilder();
        for (String message : messages) {
            sb.append(message).append(messages.length > 1 ? "<br/>" : "");
        }
        model.addAttribute("message", (Object)sb.toString());
    }

    protected void addMessage(RedirectAttributes redirectAttributes, String ... messages) {
        StringBuilder sb = new StringBuilder();
        for (String message : messages) {
            sb.append(message).append(messages.length > 1 ? "<br/>" : "");
        }
        redirectAttributes.addFlashAttribute("message", (Object)sb.toString());
    }

    protected String renderString(HttpServletResponse response, Object object) {
        return this.renderString(response, JsonMapper.toJsonString((Object)object), "application/json");
    }

    protected String renderString(HttpServletResponse response, String string, String type) {
        try {
            response.reset();
            response.setContentType(type);
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void binderUpateEmpty(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(text == null ? "" + Constants.EMPTY_NUMBER : StringEscapeUtils.escapeHtml4((String)text.trim()));
            }

            @Override
            public String getAsText() {
                Object value = this.getValue();
                return value != null ? value.toString() : "";
            }
        });
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.setValue(Constants.getInstance().getEmptyTemplateDate());
                } else {
                    this.setValue(DateUtils.parseDate((Object)text));
                }
            }
        });
        binder.registerCustomEditor(Integer.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.setValue(Constants.EMPTY_NUMBER.intValue());
                } else {
                    this.setValue(Integer.valueOf(text.trim()));
                }
            }
        });
        binder.registerCustomEditor(Byte.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.setValue(Constants.EMPTY_NUMBER);
                } else {
                    this.setValue(Byte.valueOf(text.trim()));
                }
            }
        });
        binder.registerCustomEditor(BigDecimal.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.setValue(new BigDecimal(Constants.EMPTY_NUMBER.byteValue()));
                } else {
                    this.setValue(new BigDecimal(text.trim()));
                }
            }
        });
        binder.registerCustomEditor(Long.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.setValue(Constants.EMPTY_NUMBER.longValue());
                } else if (StringUtils.isNumeric((CharSequence)text)) {
                    this.setValue(Long.valueOf(text.trim()));
                }
            }

            @Override
            public String getAsText() {
                Object value = this.getValue();
                return value != null ? value.toString() : "";
            }
        });
    }

    private void binderDefault(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(text == null ? null : StringEscapeUtils.escapeHtml4((String)text.trim()));
            }

            @Override
            public String getAsText() {
                Object value = this.getValue();
                return value != null ? value.toString() : "";
            }
        });
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(DateUtils.parseDate((Object)text));
                }
            }
        });
        binder.registerCustomEditor(Integer.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(Integer.valueOf(text.trim()));
                }
            }
        });
        binder.registerCustomEditor(Byte.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(Byte.valueOf(text.trim()));
                }
            }
        });
        binder.registerCustomEditor(BigDecimal.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    this.setValue(new BigDecimal(text.trim()));
                }
            }
        });
        binder.registerCustomEditor(Long.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.setValue(null);
                } else if (StringUtils.isNumeric((CharSequence)text)) {
                    this.setValue(Long.valueOf(text.trim()));
                }
            }

            @Override
            public String getAsText() {
                Object value = this.getValue();
                return value != null ? value.toString() : "";
            }
        });
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        String target;
        binder.setAutoGrowCollectionLimit(2048);
        String string = target = binder.getTarget() == null ? null : binder.getTarget().toString();
        if (EmptyUpdateEntity.isCanBeUpdateToEmpty(target)) {
            this.binderUpateEmpty(binder);
            return;
        }
        this.binderDefault(binder);
    }

    protected String getTemplateFilePath() {
        return this.getRealPath() + "/template/";
    }

    private String getRealPath() {
        return this.session.getServletContext().getRealPath("");
    }

    protected String getTempFilePath() {
        String tempDirPath = this.getRealPath() + "temp";
        File file = new File(tempDirPath);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdir();
        }
        return tempDirPath;
    }

    protected SysFileModel uploadOss(File zip, String ossPath, String fileName, String ext) throws IOException {
        SysFileModel file = new SysFileModel();
        String oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + "." + ext, zip, ossPath, fileName, null);
        file.setFileName(fileName);
        file.setResource(Integer.valueOf(FileResourceEnum.companyHealth_07.getValue()));
        file.setFileSize(FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)zip)));
        file.setFileExt(ext);
        file.setFileHash("" + FileUtils.checksumCRC32((File)zip));
        file.setOssUrl(oss);
        file.setDescription("");
        file.setCid(UserUtils.getLoginStaffCompanyId());
        file = this.fileService.addSysFile(file, Long.valueOf(0L));
        return file;
    }

    protected boolean isActualize() {
        return "true".equals(this.isActualize);
    }
}

