/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.web.controller.ControllerSupport;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.time.StopWatch;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class CacheControllerSupport
extends ControllerSupport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${defaultExpireSec:1800}")
    private Integer expireSec;
    @Value(value="${pagecount.cachetime:120}")
    public Integer pageCountCacheTime;
    @Autowired
    protected RedisClient redisClient;

    private String getCacheKey(String cacheName, String key) {
        return cacheName + ":" + key;
    }

    public String generateCacheKey(Object ... objs) {
        if (ArrayUtils.isNotEmpty((Object[])objs)) {
            StringBuffer sb = new StringBuffer();
            for (Object obj : objs) {
                if (obj == null) continue;
                sb.append(obj.toString() + ":");
            }
            return sb.toString();
        }
        return "";
    }

    public <T> T getCacheData(String cacheName, String key, Supplier<T> function) {
        return this.getCacheData(cacheName, key, function, this.expireSec, null);
    }

    public <T> T getCacheData(String cacheName, String key, Supplier<T> function, int inexpireSec) {
        return this.getCacheData(cacheName, key, function, inexpireSec, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getCacheData(String cacheName, String key, Supplier<T> function, int inexpireSec, Integer randSec) {
        String cacheKey = this.getCacheKey(cacheName, key);
        Object o = this.redisClient.get(cacheKey);
        if (o == null) {
            RLock lock = this.redissonClient.getLock(cacheKey + ":lock");
            lock.lock();
            try {
                this.logger.info("\u5f53\u524d\u8fdb\u5165\u7684\u9501\u5bf9\u8c61\uff1a{}", (Object)lock.toString());
                Object o2 = this.redisClient.get(cacheKey);
                if (o2 != null) {
                    Object object = o2;
                    return (T)object;
                }
                int randSecTemp = 0;
                if (randSec == null) {
                    Random random = new Random();
                    randSecTemp = random.nextInt(300);
                } else {
                    randSecTemp = randSec;
                }
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                T t = function.get();
                stopWatch.stop();
                this.logger.info("\u7f13\u5b58\u4e2d\u627e\u4e0d\u5230\u6570\u636e\uff1a cacheName:{},  key:{}, \u6570\u636e\u52a0\u8f7d\u8017\u65f6\uff1a{}ms", new Object[]{cacheName, key, stopWatch.getTime()});
                if (t != null) {
                    this.redisClient.set(cacheKey, t, (long)(inexpireSec + randSecTemp));
                }
                T t2 = t;
                return t2;
            }
            catch (Exception e) {
                this.logger.error("\u7f13\u5b58\u53d1\u751f\u9519\u8bef{}", (Throwable)e);
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
        return (T)o;
    }
}

