/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.config.shiro;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.cache.CacheException;
import org.crazycake.shiro.IRedisManager;
import org.redisson.api.RBucket;
import org.redisson.api.RKeys;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;

public class RedissonRedisManager
implements IRedisManager {
    private final RedissonClient redissonClient;

    public RedissonRedisManager(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public byte[] get(byte[] key) throws CacheException {
        try {
            RBucket bucket = this.redissonClient.getBucket(new String(key, StandardCharsets.UTF_8), (Codec)ByteArrayCodec.INSTANCE);
            return (byte[])bucket.get();
        }
        catch (Exception e) {
            throw new CacheException("\u4eceredis\u83b7\u53d6\u503c\u5931\u8d25", (Throwable)e);
        }
    }

    public byte[] set(byte[] key, byte[] value, int expireTime) throws CacheException {
        try {
            RBucket bucket = this.redissonClient.getBucket(new String(key, StandardCharsets.UTF_8), (Codec)ByteArrayCodec.INSTANCE);
            if (expireTime > 0) {
                bucket.set((Object)value, (long)expireTime, TimeUnit.SECONDS);
            } else {
                bucket.set((Object)value);
            }
            return value;
        }
        catch (Exception e) {
            throw new CacheException("\u5c06\u503c\u8bbe\u7f6e\u5230redis\u5931\u8d25", (Throwable)e);
        }
    }

    public void del(byte[] key) throws CacheException {
        try {
            this.redissonClient.getBucket(new String(key, StandardCharsets.UTF_8), (Codec)ByteArrayCodec.INSTANCE).delete();
        }
        catch (Exception e) {
            throw new CacheException("\u4eceredis\u4e2d\u5220\u9664key\u5931\u8d25", (Throwable)e);
        }
    }

    public Long dbSize(byte[] pattern) {
        try {
            RKeys keys = this.redissonClient.getKeys();
            return keys.countExists(new String[]{new String(pattern, StandardCharsets.UTF_8)});
        }
        catch (Exception e) {
            throw new CacheException("\u83b7\u53d6redis\u6570\u636e\u5e93\u5927\u5c0f\u5931\u8d25", (Throwable)e);
        }
    }

    public Set<byte[]> keys(byte[] pattern) {
        try {
            RKeys keys = this.redissonClient.getKeys();
            Iterable stringKeys = keys.getKeysByPattern(new String(pattern, StandardCharsets.UTF_8));
            if (stringKeys == null) {
                return Collections.emptySet();
            }
            HashSet<byte[]> result = new HashSet<byte[]>();
            for (String key : stringKeys) {
                result.add(key.getBytes(StandardCharsets.UTF_8));
            }
            return result;
        }
        catch (Exception e) {
            throw new CacheException("\u83b7\u53d6key\u5931\u8d25", (Throwable)e);
        }
    }
}

