/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.config;

import cn.smarthse.common.framework.mapper.CustomizeJsonMapper;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormInterceptor;
import cn.smarthse.common.interprecetor.CsrfInterceptor;
import cn.smarthse.common.interprecetor.MultipartRequestInterceptor;
import cn.smarthse.web.interprecetors.BigDataLogInterceptor;
import cn.smarthse.web.interprecetors.DefaultWebInterceptor;
import cn.smarthse.web.interprecetors.LogInterceptor;
import cn.smarthse.web.interprecetors.WorkAddInterceptor;
import cn.smarthse.web.loges.WebRequestLogInterceptor;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.accept.ContentNegotiationManagerFactoryBean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

@Configuration
@ComponentScan(basePackages={"cn.smarthse.web", "cn.smarthse.common", "cn.smarthse.framework.encrypt"})
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class WebConfig
implements WebMvcConfigurer {
    @Value(value="${adminPath}")
    private String adminPath;
    @Autowired
    private BigDataLogInterceptor bigDataLogInterceptor;
    @Autowired
    private DefaultWebInterceptor defaultWebInterceptor;
    @Autowired
    private LogInterceptor logInterceptor;
    @Autowired
    private WorkAddInterceptor workAddInterceptor;
    @Value(value="${maintain_enable}")
    private Boolean maintainEnable;
    @Value(value="${maintain_start}")
    private String maintainStart;
    @Value(value="${maintain_end}")
    private String maintainEnd;
    @Value(value="${maintain_jumpurl}")
    private String maintainJumpUrl;
    @Value(value="${spring.mvc.view.prefix}")
    private String viewPrefix;
    @Value(value="${spring.mvc.view.suffix}")
    private String viewSuffix;
    @Value(value="${web.view.order}")
    private Integer viewOrder;
    @Value(value="${htmlClean.enabled:true}")
    private Boolean htmlCleanEnable;
    @Value(value="${csrf.enabled:true}")
    private Boolean csrfEnabled;
    @Value(value="${csrf.allowedDomains:}")
    private String allowedDomains;
    @Value(value="${multipart.enabled:true}")
    private Boolean multipartEnabled;
    @Value(value="${multipart.excludeUrls:}")
    private String multipartExcludeUrls;
    @Value(value="${backHttps:false}")
    protected Boolean backHttps;
    private String webAppPath = "webapp";
    @Autowired
    private WebRequestLogInterceptor webRequestLogInterceptor;

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter();
        stringConverter.setDefaultCharset(StandardCharsets.UTF_8);
        converters.add(0, (HttpMessageConverter<?>)stringConverter);
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
        jsonConverter.setSupportedMediaTypes(List.of(MediaType.APPLICATION_JSON));
        jsonConverter.setPrettyPrint(false);
        jsonConverter.setObjectMapper(new CustomizeJsonMapper().objectMapper(this.htmlCleanEnable));
        converters.add(1, (HttpMessageConverter<?>)jsonConverter);
    }

    @Bean
    public ContentNegotiationManagerFactoryBean contentNegotiationManager() {
        ContentNegotiationManagerFactoryBean factoryBean = new ContentNegotiationManagerFactoryBean();
        Properties properties = new Properties();
        properties.put("json", "application/json");
        factoryBean.setMediaTypes(properties);
        factoryBean.setIgnoreAcceptHeader(true);
        factoryBean.setFavorPathExtension(true);
        return factoryBean;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{"/static/"}).setCachePeriod(Integer.valueOf(31536000));
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"/upload/"}).setCachePeriod(Integer.valueOf(31536000));
        registry.addResourceHandler(new String[]{"/template/**"}).addResourceLocations(new String[]{"/template/"}).setCachePeriod(Integer.valueOf(31536000));
        registry.addResourceHandler(new String[]{"/versionLog.txt"}).addResourceLocations(new String[]{"/versionLog.txt"}).setCachePeriod(Integer.valueOf(31536000));
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("redirect:" + this.adminPath);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new CsrfInterceptor(this.csrfEnabled, this.allowedDomains)).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/**/login/**"});
        registry.addInterceptor((HandlerInterceptor)new MultipartRequestInterceptor(this.multipartEnabled, this.multipartExcludeUrls)).addPathPatterns(new String[]{"/**"});
        registry.addInterceptor((HandlerInterceptor)this.defaultWebInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/base/staff/staffInfo/addStaffInfoPage", "/base/staff/staffInfo/isExistIdCard", "/base/staff/staffInfo/addStaffInfoSubmit"});
        registry.addInterceptor((HandlerInterceptor)this.workAddInterceptor).addPathPatterns(new String[]{"/work/check/diseaser/add", "/work/check/diseaser/report/add", "/work/check/add", "/work/shield/purchase/add", "/work/shield/send/add", "/work/hccheckplan/HcCheckPlan/getAddHcCheckPlanPage", "/work/certificate/addCerComp", "/work/certificate/addCerStaff", "/work/certificate/addCerDevice", "/work/planyear/daily/addPlan", "/work/planyear/addEveryYearPlan", "/work/accident/add", "/work/eme/emeDrill/add", "/wmbase/maint/proce/add", "/wmbase/add", "/device/maint/proce/add", "/work/informmanager/InformManager/getNewAddContractInformPage", "/work/reform/editUnfinished", "/work/harmFactorDeclare/addHarmFacDec", "/work/trainPlan/add", "/work/trainSummarize/add", "/work/evaluate/addevaluate", "/work/pdmonitor/edit", "/work/scene/normal/edit", "/work/scene/normal/superInspection", "/work/thirdtime/tsproject/addTsprojectPage"});
        registry.addInterceptor((HandlerInterceptor)this.logInterceptor).addPathPatterns(new String[]{this.adminPath + "/home/**", this.adminPath + "/base/**", this.adminPath + "/sys/**", this.adminPath + "/work/**", this.adminPath + "/file/**", this.adminPath + "/company/**", this.adminPath + "/complianceinfo/**"});
        registry.addInterceptor((HandlerInterceptor)this.bigDataLogInterceptor).addPathPatterns(new String[]{"/**"});
        registry.addInterceptor((HandlerInterceptor)this.webRequestLogInterceptor).addPathPatterns(new String[]{"/**"});
        registry.addInterceptor((HandlerInterceptor)new RepeatUrlFormInterceptor(this.maintainEnable.booleanValue(), this.maintainStart, this.maintainEnd, this.maintainJumpUrl)).addPathPatterns(new String[]{"/**"});
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor controllerAuthorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor advisor = new AuthorizationAttributeSourceAdvisor();
        advisor.setSecurityManager(securityManager);
        return advisor;
    }

    @Bean
    public InternalResourceViewResolver viewResolver() {
        InternalResourceViewResolver resolver = new InternalResourceViewResolver();
        resolver.setPrefix(this.viewPrefix);
        resolver.setSuffix(this.viewSuffix);
        resolver.setOrder(this.viewOrder.intValue());
        return resolver;
    }

    @Bean
    public WebServerFactoryCustomizer<TomcatServletWebServerFactory> customizer() {
        return factory -> {
            Object webAppPath;
            boolean isJar = this.getClass().getResource("").getProtocol().equals("jar");
            if (isJar) {
                String jarDir = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
                webAppPath = jarDir + File.separator + "webapp";
            } else {
                webAppPath = "src/main/webapp";
            }
            factory.setDocumentRoot(new File((String)webAppPath));
            if (this.backHttps.booleanValue()) {
                factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
                    connector.setScheme("https");
                    connector.setSecure(true);
                }});
            }
        };
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setPathMatcher((PathMatcher)new AntPathMatcher());
    }
}

