/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.config;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.modules.datacentre.provider.bigdata.IBigDataLogProviderService;
import cn.smarthse.modules.health.service.sys.ISysLogService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.web.config.shiro.RedissonRedisManager;
import cn.smarthse.web.security.shiro.ShiroAuthorizingCredentialsMatcher;
import cn.smarthse.web.security.shiro.ShiroAuthorizingRealm;
import cn.smarthse.web.security.shiro.ShiroFormAuthenticationFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.ModularRealmAuthorizer;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.JavaUuidSessionIdGenerator;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.filter.InvalidRequestFilter;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.RedisCacheManager;
import org.crazycake.shiro.RedisSessionDAO;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

@Configuration
public class ShiroConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShiroConfig.class);
    private static final String keyPrefix = "shiro:session:smarthse:";
    @Value(value="${two-factor-check}")
    private boolean twoFactorCheck;
    @Value(value="${session.sessionTimeout}")
    private long sessionTimeout;
    @Value(value="${session.sessionTimeoutClean}")
    private long sessionTimeoutClean;
    @Value(value="${session.sessionIdCookie}")
    private String sessionIdCookie;
    @Value(value="${ehcache.loginTypeTryCount}")
    private Integer retryCount;
    @Value(value="${ehcache.loginFailCount}")
    private Integer retryFailCount;
    @Value(value="${adminPath}")
    private String adminPath;
    @Value(value="${cookie_login_password}")
    public String cookieLoginPassword;
    @Value(value="${isActualize}")
    private String isActualize;
    @Value(value="${yc.system}")
    private Boolean ycSystem;
    @Value(value="${cookie.secure:true}")
    private Boolean cookieSecure;
    @DubboReference
    private ISysUserService sysUserService;
    @Autowired
    private RedisClient redisClient;
    @DubboReference
    private ISysLogService sysLogService;
    @DubboReference
    private IBigDataLogProviderService bigDataLogProviderService;
    @Value(value="${appCode}")
    private String appCode;
    @Autowired
    private RedissonClient redissonClient;

    @Bean
    public SessionIdGenerator sessionIdGenerator() {
        return new JavaUuidSessionIdGenerator();
    }

    @Bean
    public SimpleCookie cookie() {
        SimpleCookie cookie = new SimpleCookie(this.sessionIdCookie);
        cookie.setHttpOnly(true);
        cookie.setSecure(this.cookieSecure.booleanValue());
        cookie.setPath("/");
        return cookie;
    }

    @Bean(value={"redisManager"})
    public IRedisManager redisManager(RedissonClient redissonClient) {
        RedissonRedisManager redisManager = new RedissonRedisManager(redissonClient);
        return redisManager;
    }

    @Bean
    @DependsOn(value={"redisManager", "sessionIdGenerator"})
    public RedisSessionDAO redisSessionDAO(IRedisManager redisManager, SessionIdGenerator sessionIdGenerator) {
        RedisSessionDAO redisSessionDAO = new RedisSessionDAO();
        redisSessionDAO.setRedisManager(redisManager);
        redisSessionDAO.setSessionIdGenerator(sessionIdGenerator);
        redisSessionDAO.setKeyPrefix(keyPrefix);
        return redisSessionDAO;
    }

    @Bean(value={"sessionManager"})
    @DependsOn(value={"redisManager", "sessionIdGenerator"})
    public DefaultWebSessionManager sessionManager(RedisSessionDAO sessionDAO, IRedisManager redisManager, SessionIdGenerator sessionIdGenerator, SimpleCookie sessionIdCookie) {
        DefaultWebSessionManager webSessionManager = new DefaultWebSessionManager();
        webSessionManager.setSessionDAO((SessionDAO)sessionDAO);
        webSessionManager.setGlobalSessionTimeout(this.sessionTimeout);
        webSessionManager.setDeleteInvalidSessions(true);
        webSessionManager.setSessionIdCookieEnabled(true);
        webSessionManager.setSessionIdCookie((Cookie)sessionIdCookie);
        webSessionManager.setSessionValidationInterval(this.sessionTimeoutClean);
        webSessionManager.setSessionValidationSchedulerEnabled(true);
        return webSessionManager;
    }

    @Bean
    public RedisCacheManager redisCacheManager(IRedisManager redisManager) {
        RedisCacheManager cacheManager = new RedisCacheManager();
        cacheManager.setRedisManager(redisManager);
        return cacheManager;
    }

    public ShiroFormAuthenticationFilter getShiroFormAuthenticationFilter(SessionDAO sessionDAO) {
        ShiroFormAuthenticationFilter formAuthenticationFilter = new ShiroFormAuthenticationFilter(this.twoFactorCheck, this.cookieLoginPassword, this.isActualize, this.sysUserService, this.redisClient, sessionDAO, this.sysLogService, this.bigDataLogProviderService, this.appCode, this.redissonClient);
        return formAuthenticationFilter;
    }

    @Bean
    public InvalidRequestFilter getInvalidRequestFilter() {
        InvalidRequestFilter invalidRequestFilter = new InvalidRequestFilter();
        invalidRequestFilter.setBlockNonAscii(false);
        return invalidRequestFilter;
    }

    @Bean(name={"shiroFilter"})
    public ShiroFilterFactoryBean shiroFilter(SecurityManager securityManager, RedisSessionDAO sessionDAO) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        String loginUrl = Boolean.TRUE.equals(this.ycSystem) ? "/login/yc" : "/login";
        shiroFilterFactoryBean.setLoginUrl(loginUrl);
        shiroFilterFactoryBean.setSuccessUrl("/" + this.adminPath + "/home?success");
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.put("/static/**", "anon");
        filterChainDefinitionMap.put("/upload/**", "anon");
        filterChainDefinitionMap.put("/sys/es/pageErrorLog/addLog", "anon");
        filterChainDefinitionMap.put("/sys/userBind/appealBindInfo", "anon");
        filterChainDefinitionMap.put("/sys/userBind/confirmAccount", "anon");
        filterChainDefinitionMap.put("/file/appealUpload", "anon");
        filterChainDefinitionMap.put("/template/**", "anon");
        filterChainDefinitionMap.put("/sys/log/error/**", "anon");
        filterChainDefinitionMap.put("/versionLog.txt", "anon");
        filterChainDefinitionMap.put("/message/**", "anon");
        filterChainDefinitionMap.put("/weChat/**", "anon");
        filterChainDefinitionMap.put("/file/downloadLocal/**", "anon");
        filterChainDefinitionMap.put("/camera/**", "anon");
        filterChainDefinitionMap.put("/dtu/**", "anon");
        filterChainDefinitionMap.put("/temp/**", "anon");
        filterChainDefinitionMap.put("/workingRule/**", "anon");
        filterChainDefinitionMap.put("/template/msinfo/**", "anon");
        filterChainDefinitionMap.put("/work/personnelTrainingRecord/toPersonnelTrainingListPage", "anon");
        filterChainDefinitionMap.put("/work/personnelTrainingRecord/trainRecordListDataOut", "anon");
        filterChainDefinitionMap.put("/login/CompanyNameList", "anon");
        filterChainDefinitionMap.put("/company/newcompliantCard", "anon");
        filterChainDefinitionMap.put("/company/newcompliantCardQrCode", "anon");
        filterChainDefinitionMap.put("/complianceinfo/syncRefresh**", "anon");
        filterChainDefinitionMap.put("/base/staff/staffInfo/setWorkStatus", "anon");
        filterChainDefinitionMap.put("/login", "authc");
        filterChainDefinitionMap.put("/login/yc", "authc");
        filterChainDefinitionMap.put("/login/cas", "anon");
        filterChainDefinitionMap.put("/login/third", "anon");
        filterChainDefinitionMap.put("/login/supervise", "anon");
        filterChainDefinitionMap.put("/login/smarthse", "anon");
        filterChainDefinitionMap.put("/login/superviseJs", "anon");
        filterChainDefinitionMap.put("/login/captcha", "anon");
        filterChainDefinitionMap.put("/login/findBackPassword", "anon");
        filterChainDefinitionMap.put("/login/findBackPasswordByMobile", "anon");
        filterChainDefinitionMap.put("/login/resetPassword", "anon");
        filterChainDefinitionMap.put("/login/resetPasswordByMobile", "anon");
        filterChainDefinitionMap.put("/login/resetBusinessState", "anon");
        filterChainDefinitionMap.put("/login/next/**", "anon");
        filterChainDefinitionMap.put("/sys/userBind/sendVcode", "anon");
        filterChainDefinitionMap.put("/sys/userBind/bind", "anon");
        filterChainDefinitionMap.put("/login/sendVcodeByPicCode", "anon");
        filterChainDefinitionMap.put("/login/sendVcode", "anon");
        filterChainDefinitionMap.put("/login/sendVcodeByMobile", "anon");
        filterChainDefinitionMap.put("/login/singleLogin.html", "anon");
        filterChainDefinitionMap.put("/login/singleLogin", "anon");
        filterChainDefinitionMap.put("/login/isLoginOut", "anon");
        filterChainDefinitionMap.put("/login/bj", "anon");
        filterChainDefinitionMap.put("/logout/bj", "anon");
        filterChainDefinitionMap.put("/login/yc/logout", "anon");
        filterChainDefinitionMap.put("/login/yc/supervise", "anon");
        filterChainDefinitionMap.put("/essologin/**", "anon");
        filterChainDefinitionMap.put("/api/projectTrain/**", "anon");
        filterChainDefinitionMap.put("/api/checkPlan/**", "anon");
        filterChainDefinitionMap.put("/api/projectCheck/**", "anon");
        filterChainDefinitionMap.put("/information/**", "anon");
        filterChainDefinitionMap.put("/thirdOrgInfo/**", "anon");
        filterChainDefinitionMap.put("/bigText/**", "anon");
        filterChainDefinitionMap.put("/logout", "logout");
        filterChainDefinitionMap.put("/**/logout", "logout");
        filterChainDefinitionMap.put("/**", "authc,invalidRequest");
        HashMap<String, ShiroFormAuthenticationFilter> filters = new HashMap<String, ShiroFormAuthenticationFilter>();
        filters.put("authc", this.getShiroFormAuthenticationFilter((SessionDAO)sessionDAO));
        filters.put("invalidRequest", (ShiroFormAuthenticationFilter)this.getInvalidRequestFilter());
        shiroFilterFactoryBean.setFilters(filters);
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return shiroFilterFactoryBean;
    }

    @Bean(name={"credentialsMatcher"})
    public ShiroAuthorizingCredentialsMatcher credentialsMatcher() {
        ShiroAuthorizingCredentialsMatcher matcher = new ShiroAuthorizingCredentialsMatcher();
        matcher.setHashAlgorithmName("SHA-1");
        matcher.setHashIterations(1024);
        matcher.setStoredCredentialsHexEncoded(true);
        matcher.setRetryCount(this.retryCount);
        matcher.setRetryFailCount(this.retryFailCount);
        matcher.setPasswordRetryCacheName("passwordRetryCache");
        return matcher;
    }

    @Bean(name={"shiroAuthorizingRealm"})
    public Realm shiroAuthorizingRealm() {
        ShiroAuthorizingRealm realm = new ShiroAuthorizingRealm();
        realm.setCredentialsMatcher((CredentialsMatcher)this.credentialsMatcher());
        return realm;
    }

    @Bean(name={"modularRealmAuthorizer"})
    public ModularRealmAuthorizer modularRealmAuthorizer() {
        ModularRealmAuthorizer authorizer = new ModularRealmAuthorizer();
        authorizer.setRealms(Arrays.asList(this.shiroAuthorizingRealm()));
        return authorizer;
    }

    @Bean(value={"securityManager"})
    DefaultSecurityManager securityManager(DefaultWebSessionManager sessionManager, RedisCacheManager redisCacheManager) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setSessionManager((SessionManager)sessionManager);
        securityManager.setCacheManager((CacheManager)redisCacheManager);
        securityManager.setRealm(this.shiroAuthorizingRealm());
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
        return securityManager;
    }

    @Bean
    public SimpleMappingExceptionResolver simpleMappingExceptionResolver() {
        SimpleMappingExceptionResolver resolver = new SimpleMappingExceptionResolver();
        Properties mappings = new Properties();
        mappings.setProperty("org.apache.shiro.authz.UnauthorizedException", "/commons/403");
        resolver.setExceptionMappings(mappings);
        return resolver;
    }
}

