/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.config;

import cn.smarthse.common.filter.SqlInjectFilter;
import cn.smarthse.common.filter.XssFilter;
import cn.smarthse.web.common.filter.ResourceErrorFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FilterConfig {
    @Value(value="${xss.enabled:true}")
    private Boolean xssEnabled;
    @Value(value="${xss.excludeUrls:}")
    private String xssExcludeUrls;
    @Value(value="${sqlInject.enabled:true}")
    private Boolean sqlEnabled;
    @Value(value="${sqlInject.excludeUrls:}")
    private String sqlExcludeUrls;

    @Bean
    public FilterRegistrationBean<XssFilter> XssFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new XssFilter(this.xssEnabled, this.xssExcludeUrls));
        bean.addUrlPatterns(new String[]{"/*"});
        bean.setOrder(1);
        bean.setName("XssFilter");
        return bean;
    }

    @Bean
    public FilterRegistrationBean<SqlInjectFilter> SqlInjectFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new SqlInjectFilter(this.sqlEnabled, this.sqlExcludeUrls));
        bean.addUrlPatterns(new String[]{"/*"});
        bean.setOrder(2);
        bean.setName("SqlInjectFilter");
        return bean;
    }

    @Bean
    public FilterRegistrationBean<ResourceErrorFilter> getJspErrorLogFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        bean.setFilter((Filter)new ResourceErrorFilter());
        bean.addUrlPatterns(new String[]{"/*"});
        bean.setOrder(3);
        bean.setName("resourceErrorFilter");
        return bean;
    }
}

