/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.config;

import cn.smarthse.web.config.TaskExecutorProperties;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@SpringBootConfiguration
@EnableConfigurationProperties(value={TaskExecutorProperties.class})
public class ContentConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContentConfiguration.class);

    @Primary
    @Bean
    public ThreadPoolTaskExecutor threadPoolTaskExecutor(TaskExecutorProperties taskExecutorProperties) {
        log.info("\u914d\u7f6e\u901a\u7528 ThreadPoolTaskExecutor\uff1a {}", (Object)taskExecutorProperties.getThreadNamePrefix());
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix(taskExecutorProperties.getThreadNamePrefix());
        executor.setCorePoolSize(taskExecutorProperties.getCore_pool_size());
        executor.setMaxPoolSize(taskExecutorProperties.getMax_pool_size());
        executor.setQueueCapacity(taskExecutorProperties.getQueue_capacity());
        executor.setKeepAliveSeconds(taskExecutorProperties.getKeep_alive_seconds());
        executor.setRejectedExecutionHandler((r, executor1) -> log.error("\u7ebf\u7a0b\u6c60\u5df2\u6ee1\uff0c\u65e0\u6cd5\u6267\u884c\u65b0\u4efb\u52a1\uff0c\u4efb\u52a1\u4e22\u5f03"));
        executor.initialize();
        return executor;
    }

    @Bean(name={"captchaProducer"})
    public DefaultKaptcha captchaProducer() {
        DefaultKaptcha captchaProducer = new DefaultKaptcha();
        Properties properties = new Properties();
        properties.put("kaptcha.border", "no");
        properties.put("kaptcha.border.color", "105,179,90");
        properties.put("kaptcha.textproducer.font.color", "red");
        properties.put("kaptcha.image.width", "250");
        properties.put("kaptcha.textproducer.font.size", "90");
        properties.put("kaptcha.image.height", "90");
        properties.put("kaptcha.session.key", "code");
        properties.put("kaptcha.textproducer.char.string", "0123456789");
        properties.put("kaptcha.textproducer.char.length", "4");
        properties.put("kaptcha.textproducer.font.names", "\u5b8b\u4f53,\u6977\u4f53,\u5fae\u8f6f\u96c5\u9ed1,Times New Roman");
        Config config = new Config(properties);
        captchaProducer.setConfig(config);
        return captchaProducer;
    }
}

