/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.task.pullTask;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.services.wanda.api.entity.WandaZywsReportPoint;
import cn.smarthse.services.wanda.api.service.IWandaZywsReportPointService;
import cn.smarthse.services.wanda.task.pullTask.WandaBaseTask;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WandaZywsReportpPointTask
extends WandaBaseTask<WandaZywsReportPoint> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaZywsReportpPointTask.class);
    @DubboReference
    private IWandaZywsReportPointService reportPointService;
    @Autowired
    protected IdWorker idworker;

    @XxlJob(value="WandaZywsReportpPointTask-listData")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public synchronized void listData() throws UnsupportedEncodingException {
        log.info("\u5b9a\u65f6\u4efb\u52a1->BIZ_ZYWS_REPORT_POINT\u68c0\u6d4b\u5b50\u8868\uff1a\u68c0\u6d4b\u70b9\u4f4d:\u6570\u636e\u540c\u6b65\u5f00\u59cb=============================");
        long start = System.currentTimeMillis();
        ArrayList reslutList = new ArrayList();
        Date startDate = null;
        Date maxLoadTime = this.reportPointService.getMaxBizDate();
        startDate = Objects.nonNull(maxLoadTime) ? maxLoadTime : DateUtils.parseDate((Object)"1949-10-01 14:35:27");
        this.getDataFromUrl(reslutList, "1", startDate, DateUtils.addDay((Date)new Date(), (int)1));
        log.info("\u5b9a\u65f6\u4efb\u52a1->BIZ_ZYWS_REPORT_POINT\u68c0\u6d4b\u5b50\u8868\uff1a\u68c0\u6d4b\u70b9\u4f4d:\u6570\u636e\u540c\u6b65\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    @Override
    public String getAppkey() {
        return "BIZ_ZYWS_REPORT_POINT";
    }

    @Override
    public String getAppSecret() {
        return "123456";
    }

    @Override
    public void save(List<WandaZywsReportPoint> reslutList) {
        Map map = reslutList.parallelStream().filter(item -> item != null && item.getSourceId() != null).collect(Collectors.toMap(WandaZywsReportPoint::getSourceId, Function.identity(), (c1, c2) -> c1.getLoadTime().getTime() > c2.getLoadTime().getTime() ? c1 : c2));
        if (map.isEmpty()) {
            return;
        }
        this.reportPointService.deleteAndSave(new ArrayList(map.values()));
    }

    @Override
    public void parseData(List<WandaZywsReportPoint> reslutList, JSONArray data) {
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String sourceId = jsonObject.getString("ID");
                jsonObject.put("sourceId", (Object)sourceId);
                jsonObject.remove((Object)"ID");
                WandaZywsReportPoint object = (WandaZywsReportPoint)jsonObject.toJavaObject(WandaZywsReportPoint.class);
                object.setId(Long.valueOf(this.idworker.nextId()));
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                object.setIsValid(Boolean.valueOf(true));
                reslutList.add(object);
            }
        }
    }
}

