/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.task.pullTask;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.hccheckplan.WandOpStateEnum;
import cn.smarthse.services.wanda.api.entity.WandaCheckBackPushLog;
import cn.smarthse.services.wanda.api.entity.WandaZywsCheck;
import cn.smarthse.services.wanda.api.enums.WandCheckBackTypeEnm;
import cn.smarthse.services.wanda.api.service.IWandaCheckBackPushLogService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckService;
import cn.smarthse.services.wanda.task.pullTask.WandaBaseTask;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WandaZywsCheckTask
extends WandaBaseTask<WandaZywsCheck> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaZywsCheckTask.class);
    @DubboReference
    private IWandaZywsCheckService wandaZywsCheckService;
    @DubboReference
    private IWandaCheckBackPushLogService backPushLogService;

    @XxlJob(value="WandaZywsCheckTask-updateCompanyNameRecord")
    public void updateCompanyNameRecord() {
        JSONObject jsonObj;
        String jobParam = XxlJobHelper.getJobParam();
        String cids = "";
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null && StringUtils.isNotBlank((CharSequence)jsonObj.getString("cids"))) {
            cids = jsonObj.getString("cids");
        }
        this.wandaZywsCheckService.updateCompanyNameRecord(cids);
    }

    @XxlJob(value="WandaZywsCheckTask-hcFactorsListData")
    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void hcFactorsListData() throws UnsupportedEncodingException {
        this.wandaZywsCheckService.updateCompanyNameRecord(null);
        log.error("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u4e3b\u8868\u6570\u636e\u63d2\u5165\u5f00\u59cb=============================");
        long start = System.currentTimeMillis();
        ArrayList reslutList = new ArrayList();
        Date startDate = this.wandaZywsCheckService.getMaxBizDate();
        this.getDataFromUrl(reslutList, "1", startDate, DateUtils.addDay((Date)new Date(), (int)1));
        log.error("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u4e3b\u8868\u6570\u636e\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
        this.backPushLogService.pushNotBackCheckData();
    }

    @Override
    public String getAppkey() {
        return "BIZ_037_ZYWS_CHECK";
    }

    @Override
    public String getAppSecret() {
        return "123456ZJ";
    }

    @Override
    public void save(List<WandaZywsCheck> reslutList) {
        ArrayList<WandaZywsCheck> updateList = new ArrayList<WandaZywsCheck>();
        Map map = reslutList.parallelStream().filter(item -> item != null && item.getSourceId() != null).collect(Collectors.toMap(WandaZywsCheck::getSourceId, Function.identity(), (c1, c2) -> c1.getLoadTime().getTime() > c2.getLoadTime().getTime() ? c1 : c2));
        this.wandaZywsCheckService.insertCheckSourceList(new ArrayList(map.values()));
        map = this.wandaZywsCheckService.verifyData(map);
        if (CollectionUtils.isEmpty((Map)map)) {
            log.error("\u6ca1\u6709\u6709\u6548\u6570\u636e");
            return;
        }
        List sourceIdList = map.values().stream().map(WandaZywsCheck::getSourceId).collect(Collectors.toList());
        reslutList.clear();
        Map dataMap = this.wandaZywsCheckService.getDataMap(sourceIdList);
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)key)) continue;
            WandaZywsCheck value = (WandaZywsCheck)entry.getValue();
            WandaZywsCheck wandaZywsCheck = (WandaZywsCheck)dataMap.get(key);
            if (wandaZywsCheck != null) {
                if (wandaZywsCheck.getLoadTime().getTime() >= value.getLoadTime().getTime()) continue;
                value.setCreateDate(wandaZywsCheck.getCreateDate());
                updateList.add(value);
                continue;
            }
            updateList.add(value);
        }
        this.wandaZywsCheckService.batchUpdate(updateList);
    }

    @Override
    public void parseData(List<WandaZywsCheck> reslutList, JSONArray data) {
        if (data == null || data.size() <= 0) {
            return;
        }
        for (int i = 0; i < data.size(); ++i) {
            JSONObject jsonObject = data.getJSONObject(i);
            try {
                WandaZywsCheck object = (WandaZywsCheck)jsonObject.toJavaObject(WandaZywsCheck.class);
                if (object.getId() != null) {
                    object.setSourceId(object.getId());
                }
                if (object.getCheckOpState().equals(WandOpStateEnum.CHECK_OP_ADD.getState()) || object.getCheckOpState().equals(WandOpStateEnum.CHECK_OP_UPDATE.getState())) {
                    object.setOldCheckId(object.getId());
                }
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                reslutList.add(object);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                String sourceId = jsonObject.get((Object)"ID").toString();
                Object loadTime = jsonObject.get((Object)"LOAD_TIME");
                Object checkOpState = jsonObject.get((Object)"CHECK_OP_STATE");
                WandaCheckBackPushLog backPushLog = new WandaCheckBackPushLog();
                backPushLog.setCheckId(sourceId);
                backPushLog.setReason(e.getMessage());
                if (Objects.isNull(checkOpState)) {
                    backPushLog.setCreateDate(new Date());
                    backPushLog.setReason(backPushLog.getReason() + ",\u5e76\u4e14CHECK_OP_STATE\u4e3a\u7a7a");
                }
                if (Objects.isNull(loadTime)) {
                    backPushLog.setCreateDate(new Date());
                    backPushLog.setReason(backPushLog.getReason() + ",\u5e76\u4e14LOAD_TIME\u4e3a\u7a7a");
                } else {
                    Date date = DateUtils.parseDate((Object)loadTime.toString());
                    backPushLog.setCreateDate(date);
                }
                this.backPushLogService.distinctAddPushLog(Collections.singletonList(backPushLog), WandCheckBackTypeEnm.verifyMain.getCode());
                log.error("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u4e3b\u8868\u4e2a\u522b\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff0csourceId=" + sourceId + "\uff0c\u539f\u56e0" + e.getMessage());
            }
        }
    }
}

