/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.task.pullTask;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.services.wanda.api.entity.WandaCheckBackPushLog;
import cn.smarthse.services.wanda.api.entity.WandaZywsCheckFactors;
import cn.smarthse.services.wanda.api.enums.WandCheckBackTypeEnm;
import cn.smarthse.services.wanda.api.service.IWandaCheckBackPushLogService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckFactorsService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckService;
import cn.smarthse.services.wanda.task.pullTask.WandaFactorsBaseTask;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WandaZywsCheckFactorsTask
extends WandaFactorsBaseTask<WandaZywsCheckFactors> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaZywsCheckFactorsTask.class);
    @Autowired
    protected IdWorker idworker;
    @DubboReference
    private IWandaZywsCheckFactorsService checkFactorsService;
    @DubboReference
    private IWandaZywsCheckService wandaZywsCheckService;
    @DubboReference
    private IWandaCheckBackPushLogService backPushLogService;
    @Value(value="${spring.profiles.active:}")
    private String environment;

    @XxlJob(value="WandaZywsCheckFactorsTask-hcFactorsListData")
    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void hcFactorsListData() throws UnsupportedEncodingException {
        String[] appkeyArr = new String[]{"BIZ_037_ZYWS_CHECK_WEATHER", "BIZ_037_ZYWS_CHECK_UHFR", "BIZ_037_ZYWS_CHECK_NOISE", "BIZ_037_ZYWS_CHECK_MICRO_RADI", "BIZ_037_ZYWS_CHECK_LASER_RADI", "BIZ_037_ZYWS_CHECK_ION_SOURCE", "BIZ_037_ZYWS_CHECK_ION_RAY", "BIZ_037_ZYWS_CHECK_ILLUM", "BIZ_037_ZYWS_CHECK_HIGH_TEM", "BIZ_037_ZYWS_CHECK_HIGH_FREQ", "BIZ_037_ZYWS_CHECK_HAND_VIBR", "BIZ_037_ZYWS_CHECK_FRESH_AIR", "BIZ_037_ZYWS_CHECK_FREQUENCY", "BIZ_037_ZYWS_CHECK_DUST", "BIZ_037_ZYWS_CHECK_CHEMISTRY", "BIZ_037_ZYWS_CHECK_BIOLOGY", "BIZ_037_ZYWS_CHECK_AIR_SPEED", "BIZ_037_ZYWS_CHECK_ULTR_RAY"};
        Integer appkeyIndex = 1;
        for (String appkey : appkeyArr) {
            log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u5b50\u8868-\u68c0\u6d4b\u5371\u5bb3\u56e0\u7d20\u6570\u636e(" + appkey + ")\u63d2\u5165\u5f00\u59cb=============================");
            long start = System.currentTimeMillis();
            ArrayList reslutList = new ArrayList();
            Date startDate = this.checkFactorsService.getMaxBizDate(appkeyIndex);
            this.getDataFromUrl(appkeyIndex, appkey, reslutList, "1", startDate, DateUtils.addDay((Date)new Date(), (int)1));
            Integer n = appkeyIndex;
            appkeyIndex = appkeyIndex + 1;
            log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u5b50\u8868-\u68c0\u6d4b\u5371\u5bb3\u56e0\u7d20\u6570\u636e(" + appkey + ")\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
        }
        this.backPushLogService.pushNotBackCheckData();
    }

    @Override
    public void save(Integer appkeyIndex, String appkey, List<WandaZywsCheckFactors> addList) {
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u5b50\u8868-\u68c0\u6d4b\u5371\u5bb3\u56e0\u7d20\u6570\u636e(" + appkey + ")\u67e5\u8be2\u6570\u91cf\u4e3a \uff1a " + addList.size());
        ArrayList<WandaZywsCheckFactors> updateList = new ArrayList<WandaZywsCheckFactors>();
        Map map = addList.parallelStream().filter(item -> item != null && item.getSourceId() != null).collect(Collectors.toMap(WandaZywsCheckFactors::getSourceId, Function.identity(), (c1, c2) -> c1.getLoadTime().getTime() > c2.getLoadTime().getTime() ? c1 : c2));
        addList.clear();
        map = this.checkFactorsService.verifyData(map, appkey);
        if (CollectionUtils.isEmpty((Map)map)) {
            log.info("\u6ca1\u6709\u6709\u6548\u6570\u636e");
            return;
        }
        List sourceIdList = map.values().stream().map(WandaZywsCheckFactors::getSourceId).collect(Collectors.toList());
        Map dataMap = this.checkFactorsService.getDataMap(sourceIdList);
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            if (StringUtils.isBlank((CharSequence)key)) continue;
            WandaZywsCheckFactors value = (WandaZywsCheckFactors)entry.getValue();
            WandaZywsCheckFactors dbFactors = (WandaZywsCheckFactors)dataMap.get(key);
            if (dbFactors != null) {
                if (dbFactors.getLoadTime().getTime() >= value.getLoadTime().getTime()) continue;
                value.setCreateDate(dbFactors.getCreateDate());
                updateList.add(value);
                addList.add(value);
                continue;
            }
            addList.add(value);
        }
        int pageSize = 500;
        this.checkFactorsService.inertFactorsInfo(updateList, addList, appkeyIndex, Integer.valueOf(pageSize));
    }

    @Override
    public void parseData(String appkey, List<WandaZywsCheckFactors> reslutList, JSONArray data) {
        if (data == null || data.size() <= 0) {
            return;
        }
        for (int i = 0; i < data.size(); ++i) {
            JSONObject jsonObject = data.getJSONObject(i);
            try {
                WandaZywsCheckFactors object = (WandaZywsCheckFactors)jsonObject.toJavaObject(WandaZywsCheckFactors.class);
                if (object.getId() != null) {
                    object.setSourceId(object.getId());
                }
                if (StringUtils.isBlank((CharSequence)object.getOldItemId())) {
                    object.setOldItemId(object.getId());
                }
                object.setCheckCode(WandaZywsCheckFactors.generateCheckCode((WandaZywsCheckFactors)object));
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                reslutList.add(object);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                String sourceId = jsonObject.get((Object)"ID").toString();
                Object checkId = jsonObject.get((Object)"CHECK_ID");
                Object loadTime = jsonObject.get((Object)"LOAD_TIME");
                WandaCheckBackPushLog backPushLog = new WandaCheckBackPushLog();
                backPushLog.setReason(e.getMessage());
                if (Objects.isNull(loadTime)) {
                    backPushLog.setCreateDate(new Date());
                    backPushLog.setReason(backPushLog.getReason() + ",\u5e76\u4e14LOAD_TIME\u4e3a\u7a7a");
                } else {
                    Date date = DateUtils.parseDate((Object)loadTime.toString());
                    backPushLog.setCreateDate(date);
                }
                if (Objects.isNull(checkId)) {
                    backPushLog.setReason(backPushLog.getReason() + ",\u5e76\u4e14CHECK_ID\u4e3a\u7a7a");
                    backPushLog.setCheckId(sourceId);
                } else {
                    backPushLog.setCheckId(checkId.toString());
                }
                this.backPushLogService.distinctAddPushLog(Collections.singletonList(backPushLog), WandCheckBackTypeEnm.verifySecondary.getCode());
                log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u4e3b\u8868\u4e2a\u522b\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff0csourceId=" + sourceId + "\uff0c\u539f\u56e0" + e.getMessage());
            }
        }
    }
}

