/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.task.pullTask;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.wanda.api.entity.WandaBaseData;
import cn.smarthse.util.common.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class WandaFactorsBaseTask<T extends WandaBaseData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaFactorsBaseTask.class);
    @Value(value="${wanda.url}")
    private String url;
    @Value(value="${wanda.appSecret}")
    private String appSecret;
    private static String dataType = "json";
    private static String pageSize = "500";
    private Class<T> resultType;

    public abstract void save(Integer var1, String var2, List<T> var3);

    public WandaFactorsBaseTask() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            this.resultType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
    }

    public String getDataFromUrl(Integer appkeyIndex, String appkey, List<T> reslutList, String pageNum, Date start, Date end) throws UnsupportedEncodingException {
        JSONObject root;
        if (this.resultType == null) {
            throw new RuntimeException("\u8bf7\u6dfb\u52a0\u5177\u4f53\u6cdb\u578b\uff01");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        String dateStr = DateUtils.formatDateTime((Date)new Date());
        String sign = DigestUtils.md5Hex((String)(appkey + dateStr + this.appSecret));
        dateStr = URLEncoder.encode(dateStr, "UTF-8");
        param.put("appKey", appkey);
        param.put("strSysDatetime", dateStr);
        param.put("pageNum", pageNum);
        param.put("pageSize", pageSize);
        param.put("dataType", dataType);
        Object queryPara = "";
        String startStr = "";
        String endStr = "";
        if (start != null) {
            startStr = DateUtils.formatDateTime((Date)start);
            if (end == null) {
                end = DateUtils.addMonth((Date)start, (int)1);
            }
            endStr = DateUtils.formatDateTime((Date)end);
        }
        if (StringUtils.isNotBlank((CharSequence)startStr) && StringUtils.isNotBlank((CharSequence)endStr)) {
            queryPara = "{\"LOAD_TIME\":\"" + startStr + "," + endStr + "\"}";
            queryPara = URLEncoder.encode((String)queryPara, "UTF-8");
        } else {
            queryPara = "{}";
        }
        param.put("queryPara", (String)queryPara);
        param.put("sign", sign);
        String responseText = HttpUtil.doGet((String)this.url, param);
        JSONObject jsonObject = JSONObject.parseObject((String)responseText);
        if (jsonObject != null && jsonObject.containsKey((Object)"root") && (root = jsonObject.getJSONObject("root")).containsKey((Object)"request")) {
            JSONObject header;
            Integer pageSum;
            JSONObject dataList;
            JSONObject body;
            JSONObject request = root.getJSONObject("request");
            if (request.containsKey((Object)"body") && (body = request.getJSONObject("body")).containsKey((Object)"dataList") && (dataList = body.getJSONObject("dataList")).containsKey((Object)"data")) {
                JSONArray data = dataList.getJSONArray("data");
                this.parseData(appkey, reslutList, data);
            }
            if (request.containsKey((Object)"header") && (pageSum = (header = request.getJSONObject("header")).getInteger("pageSum")) != null && pageSum >= Integer.parseInt(pageNum)) {
                this.save(appkeyIndex, appkey, reslutList);
                reslutList.clear();
                this.getDataFromUrl(appkeyIndex, appkey, reslutList, "" + (Integer.parseInt(pageNum) + 1), start, end);
            }
        }
        return "\u63a5\u53e3\uff1a" + this.url + "?appKey=" + appkey + "&sign=" + sign + "&strSysDatetime=" + dateStr + "&pageNum=1&pageSize=500&dataType=" + dataType + "&queryPara=" + (String)queryPara;
    }

    public abstract void parseData(String var1, List<T> var2, JSONArray var3);
}

