/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.task.pullTask;

import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import cn.smarthse.services.wanda.task.pullTask.WandaBaseTask;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WandaDeclareTask
extends WandaBaseTask<WandaDeclare> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaDeclareTask.class);
    @Autowired
    protected IdWorker idworker;
    @DubboReference
    private IWandaDeclareService wandaDeclareService;

    @XxlJob(value="WandaDeclareTask-declareListData")
    public synchronized void declareListData() throws UnsupportedEncodingException {
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u7533\u62a5\u6570\u636e\u63d2\u5165\u5f00\u59cb=============================");
        long start = System.currentTimeMillis();
        ArrayList reslutList = new ArrayList();
        Date startDate = null;
        Date maxLoadTime = this.wandaDeclareService.getMaxBizDate();
        if (Objects.nonNull(maxLoadTime)) {
            startDate = maxLoadTime;
        }
        this.doTask(reslutList, "1", startDate, new Date());
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u7533\u62a5\u6570\u636e\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    @XxlJob(value="WandaDeclareTask-importCompany2024")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public synchronized void importCompany2024() {
        log.info("\u5b9a\u65f6\u4efb\u52a1->2024\u5e74\u7533\u62a5\u4f01\u4e1a\u5165\u5e93\u5f00\u59cb=============================");
        long start = System.currentTimeMillis();
        this.wandaDeclareService.importCompanyDeclare20240730(null);
        log.info("\u5b9a\u65f6\u4efb\u52a1->2024\u5e74\u7533\u62a5\u4f01\u4e1a\u5165\u5e93\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    @XxlJob(value="WandaDeclareTask-importCompanyWithReason")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public synchronized void importCompanyWithReason() {
        log.info("\u5b9a\u65f6\u4efb\u52a1->2024\u5e74\u7533\u62a5\u4f01\u4e1a\u5165\u5e93\u5f00\u59cb=============================");
        long start = System.currentTimeMillis();
        this.wandaDeclareService.importCompanyWithReason(null);
        log.info("\u5b9a\u65f6\u4efb\u52a1->2024\u5e74\u7533\u62a5\u4f01\u4e1a\u5165\u5e93\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    @XxlJob(value="WandaDeclareTask-matchWandaDeclareHistoryDate")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public synchronized void matchWandaDeclareHistoryDate() {
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u7533\u62a5\u5386\u53f2\u6570\u636e\u5339\u914d\u5f00\u59cb=============================");
        long start = System.currentTimeMillis();
        this.wandaDeclareService.matchWandaDeclareHistoryDate(null);
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u7533\u62a5\u5386\u53f2\u6570\u636e\u5339\u914d\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    @Override
    public String getAppkey() {
        return "BIZ_037_ZYWS_DECLARE_ZJ";
    }

    @Override
    public String getAppSecret() {
        return "123456ZJ";
    }

    @Override
    public void save(List<WandaDeclare> reslutList) {
        this.wandaDeclareService.batchInsert(reslutList);
    }

    @Override
    public void parseData(List<WandaDeclare> reslutList, JSONArray data) {
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String sourceId = jsonObject.getString("ID");
                jsonObject.put("sourceId", (Object)sourceId);
                jsonObject.remove((Object)"ID");
                WandaDeclare object = (WandaDeclare)jsonObject.toJavaObject(WandaDeclare.class);
                object.setId(Long.valueOf(this.idworker.nextId()));
                List models = this.wandaDeclareService.getCidByCode(object.getCreditCode().trim(), object.getEmpName().trim());
                if (CollectionUtils.isNotEmpty((Collection)models)) {
                    CompanySuperviseModel companySuperviseModel = models.stream().filter(CompanyBaseInfoModel::getIsDec).findFirst().orElse(null);
                    if (Objects.nonNull(companySuperviseModel)) {
                        object.setIsDec(Boolean.valueOf(true));
                        object.setCid(companySuperviseModel.getId());
                    } else {
                        object.setIsDec(Boolean.valueOf(false));
                        object.setCid(((CompanySuperviseModel)models.get(0)).getId());
                    }
                } else {
                    List companySuperviseModels = this.wandaDeclareService.getCompanyNameRecord(object.getCreditCode().trim(), object.getEmpName().trim());
                    if (CollectionUtils.isNotEmpty((Collection)companySuperviseModels)) {
                        object.setIsDec(Boolean.valueOf(true));
                        object.setCid(((CompanySuperviseModel)companySuperviseModels.get(0)).getId());
                    }
                }
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                object.setIsValid(Boolean.valueOf(true));
                reslutList.add(object);
            }
        }
    }

    public Map<String, Object> checkNewData() throws UnsupportedEncodingException {
        Map<String, Object> map = this.checkNewData(this.wandaDeclareService.getMaxBizDate());
        map.put("name", "declare");
        map.put("existNoConverted", "false");
        return map;
    }
}

