/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.task.pullTask;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.wanda.api.entity.WandaBaseData;
import cn.smarthse.services.wanda.api.model.WandaPullModel;
import cn.smarthse.services.wanda.task.pullTask.HealthCardTask;
import cn.smarthse.util.common.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class WandaBaseTask<T extends WandaBaseData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaBaseTask.class);
    @Value(value="${wanda.url}")
    private String url;
    private static String dataType = "json";
    private static String pageSize = "1000";
    @Autowired
    private HealthCardTask healthCardTask;
    private Class<T> resultType;

    public abstract String getAppkey();

    public abstract String getAppSecret();

    public abstract void save(List<T> var1);

    public WandaBaseTask() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            this.resultType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
    }

    public void doTask(List<T> reslutList, String pageNum, Date start, Date end) throws UnsupportedEncodingException {
        if (this.resultType == null) {
            throw new RuntimeException("\u8bf7\u6dfb\u52a0\u5177\u4f53\u6cdb\u578b\uff01");
        }
        String json = this.fetchData(pageNum, start, end);
        WandaPullModel wandaPullModel = this.convertJson(json);
        if (Objects.nonNull(wandaPullModel)) {
            int pageTotal = wandaPullModel.getPageTotal();
            int begin = Integer.parseInt(pageNum);
            Integer i = begin;
            while (i <= pageTotal) {
                WandaPullModel model = this.convertJson(this.fetchData("" + i, start, end));
                if (model != null) {
                    this.parseData(reslutList, model.getJsonArray());
                    if (pageTotal != model.getPageTotal()) {
                        pageTotal = model.getPageTotal();
                    }
                    this.save(reslutList);
                    reslutList.clear();
                }
                Integer n = i;
                i = i + 1;
            }
        }
    }

    public void doTask2(List<T> reslutList, String pageNum, Date start, Date end) throws UnsupportedEncodingException {
        if (this.resultType == null) {
            throw new RuntimeException("\u8bf7\u6dfb\u52a0\u5177\u4f53\u6cdb\u578b\uff01");
        }
        String json = this.fetchData(pageNum, start, end);
        WandaPullModel wandaPullModel = this.convertJson(json);
        if (Objects.nonNull(wandaPullModel)) {
            int pageTotal = wandaPullModel.getPageTotal();
            int begin = Integer.parseInt(pageNum);
            Integer i = begin;
            while (i <= pageTotal) {
                WandaPullModel model = this.convertJson(this.fetchData("" + i, start, end));
                if (model != null) {
                    this.parseData(reslutList, model.getJsonArray());
                    if (pageTotal != model.getPageTotal()) {
                        pageTotal = model.getPageTotal();
                    }
                    this.healthCardTask.save2(reslutList);
                    reslutList.clear();
                }
                Integer n = i;
                i = i + 1;
            }
        }
    }

    public Map<String, Object> checkNewData(Date loadTime) throws UnsupportedEncodingException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("loadTime", loadTime);
        boolean flag = true;
        String pageNum = "1";
        ArrayList reslutList = new ArrayList();
        ArrayList maxList = new ArrayList();
        String responseText = this.fetchData(pageNum, loadTime, new Date());
        if (StringUtils.isNotEmpty((String)responseText)) {
            WandaPullModel wandaPullModel = this.convertJson(responseText);
            if (Objects.nonNull(wandaPullModel)) {
                int begin;
                int pageTotal = wandaPullModel.getPageTotal();
                for (int i = begin = Integer.parseInt(pageNum); i <= pageTotal; ++i) {
                    reslutList.clear();
                    WandaPullModel model = this.convertJson(this.fetchData("" + i, loadTime, new Date()));
                    if (model == null) continue;
                    this.parseData(reslutList, model.getJsonArray());
                    if (pageTotal != model.getPageTotal()) {
                        pageTotal = model.getPageTotal();
                    }
                    reslutList.stream().max(Comparator.comparing(WandaBaseData::getLoadTime)).ifPresent(maxList::add);
                }
            }
            if (CollectionUtils.isNotEmpty(maxList)) {
                Date maxLoadTime = reslutList.stream().max(Comparator.comparing(WandaBaseData::getLoadTime)).get().getLoadTime();
                flag = !loadTime.before(maxLoadTime);
            }
        }
        resultMap.put("isNew", flag);
        return resultMap;
    }

    private String fetchData(String pageNum, Date start, Date end) throws UnsupportedEncodingException {
        HashMap<String, String> param = new HashMap<String, String>();
        String dateStr = DateUtils.formatDateTime((Date)new Date());
        String appSecret = this.getAppSecret();
        String sign = DigestUtils.md5Hex((String)(this.getAppkey() + dateStr + appSecret));
        dateStr = URLEncoder.encode(dateStr, "UTF-8");
        param.put("appKey", this.getAppkey());
        param.put("strSysDatetime", dateStr);
        param.put("pageNum", pageNum);
        param.put("pageSize", pageSize);
        param.put("dataType", dataType);
        Object queryPara = "";
        String startStr = "";
        String endStr = "";
        if (start != null) {
            startStr = this.getAppkey().equalsIgnoreCase("BIZ_037_ZYWS_HEALTH_CARD_ZJ") ? DateUtils.formatDateTime((Date)start) : DateUtils.format((Date)start, (String)"yyyyMMdd");
            if (end == null) {
                end = DateUtils.addMonth((Date)start, (int)1);
            }
            endStr = this.getAppkey().equalsIgnoreCase("BIZ_037_ZYWS_HEALTH_CARD_ZJ") ? DateUtils.formatDateTime((Date)end) : DateUtils.format((Date)end, (String)"yyyyMMdd");
        }
        if (StringUtils.isNotBlank((CharSequence)startStr) && StringUtils.isNotBlank((CharSequence)endStr)) {
            queryPara = "{\"LOAD_TIME\":\"" + startStr + "," + endStr + "\"}";
            queryPara = URLEncoder.encode((String)queryPara, "UTF-8");
        }
        param.put("queryPara", (String)queryPara);
        param.put("sign", sign);
        String responseText = HttpUtil.doGet((String)this.url, param);
        if (StringUtils.isEmpty((CharSequence)responseText)) {
            responseText = HttpUtil.doGet((String)this.url, param);
        }
        log.error("\u63a5\u53e3\uff1a" + this.url + "?appKey=" + this.getAppkey() + "&sign=" + sign + "&strSysDatetime=" + dateStr + "&pageNum=" + pageNum + "&pageSize=" + pageSize + "&dataType=" + dataType + "&queryPara=" + (String)queryPara);
        return responseText;
    }

    private WandaPullModel convertJson(String responseText) {
        JSONObject root;
        if (StringUtil.isEmpty((String)responseText)) {
            log.error("\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        WandaPullModel model = new WandaPullModel();
        JSONObject jsonObject = JSONObject.parseObject((String)responseText);
        if (jsonObject != null && jsonObject.containsKey((Object)"root") && (root = jsonObject.getJSONObject("root")).containsKey((Object)"request")) {
            JSONObject dataList;
            JSONObject body;
            JSONObject request = root.getJSONObject("request");
            if (request.containsKey((Object)"body") && (body = request.getJSONObject("body")).containsKey((Object)"dataList") && (dataList = body.getJSONObject("dataList")).containsKey((Object)"data")) {
                JSONArray data = dataList.getJSONArray("data");
                model.setJsonArray(data);
            }
            if (request.containsKey((Object)"header")) {
                JSONObject header = request.getJSONObject("header");
                Integer pageSum = header.getInteger("pageSum");
                model.setPageTotal(pageSum);
            }
        }
        if (Objects.isNull(model.getPageTotal())) {
            log.error("\u89e3\u6790\u603b\u9875\u6570\u5931\u8d25\uff0cjson\u6570\u636e\u4e3a\uff1a{}", (Object)responseText);
            model.setPageTotal(Integer.valueOf(0));
        }
        return model;
    }

    public String getDataFromUrl(List<T> reslutList, String pageNum, Date start, Date end) throws UnsupportedEncodingException {
        JSONObject root;
        if (this.resultType == null) {
            throw new RuntimeException("\u8bf7\u6dfb\u52a0\u5177\u4f53\u6cdb\u578b\uff01");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        String dateStr = DateUtils.formatDateTime((Date)new Date());
        String appSecret = this.getAppSecret();
        String sign = DigestUtils.md5Hex((String)(this.getAppkey() + dateStr + appSecret));
        dateStr = URLEncoder.encode(dateStr, "UTF-8");
        param.put("appKey", this.getAppkey());
        param.put("strSysDatetime", dateStr);
        param.put("pageNum", pageNum);
        param.put("pageSize", pageSize);
        param.put("dataType", dataType);
        Object queryPara = "";
        String startStr = "";
        String endStr = "";
        if (start != null) {
            if (this.getAppkey().equalsIgnoreCase("BIZ_037_ZYWS_CHECK")) {
                startStr = DateUtils.formatDateTime((Date)start);
                if (end == null) {
                    end = DateUtils.addMonth((Date)start, (int)1);
                }
                endStr = DateUtils.formatDateTime((Date)end);
            } else {
                startStr = DateUtils.format((Date)start, (String)"yyyyMMdd");
                if (end == null) {
                    end = DateUtils.addMonth((Date)start, (int)1);
                }
                endStr = DateUtils.format((Date)end, (String)"yyyyMMdd");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)startStr) && StringUtils.isNotBlank((CharSequence)endStr)) {
            queryPara = "{\"LOAD_TIME\":\"" + startStr + "," + endStr + "\"}";
            queryPara = URLEncoder.encode((String)queryPara, "UTF-8");
        } else {
            queryPara = "{}";
        }
        param.put("queryPara", (String)queryPara);
        param.put("sign", sign);
        String responseText = HttpUtil.doGet((String)this.url, param);
        JSONObject jsonObject = JSONObject.parseObject((String)responseText);
        if (jsonObject != null && jsonObject.containsKey((Object)"root") && (root = jsonObject.getJSONObject("root")).containsKey((Object)"request")) {
            JSONObject header;
            Integer pageSum;
            JSONObject dataList;
            JSONObject body;
            JSONObject request = root.getJSONObject("request");
            if (request.containsKey((Object)"body") && (body = request.getJSONObject("body")).containsKey((Object)"dataList") && (dataList = body.getJSONObject("dataList")).containsKey((Object)"data")) {
                JSONArray data = dataList.getJSONArray("data");
                this.parseData(reslutList, data);
            }
            if (request.containsKey((Object)"header") && (pageSum = (header = request.getJSONObject("header")).getInteger("pageSum")) != null && pageSum >= Integer.parseInt(pageNum)) {
                this.save(reslutList);
                reslutList.clear();
                this.getDataFromUrl(reslutList, "" + (Integer.parseInt(pageNum) + 1), start, end);
            }
        }
        return "\u63a5\u53e3\uff1a" + this.url + "?appKey=" + this.getAppkey() + "&sign=" + sign + "&strSysDatetime=" + dateStr + "&pageNum=1&pageSize=500&dataType=" + dataType + "&queryPara= " + (String)queryPara;
    }

    public abstract void parseData(List<T> var1, JSONArray var2);
}

