/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.task.pullTask;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import cn.smarthse.services.wanda.api.entity.WandaTrainData;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import cn.smarthse.services.wanda.api.service.IWandaTrainDataService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaTrainDataMapper;
import cn.smarthse.services.wanda.task.pullTask.WandaBaseTask;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TrainTask
extends WandaBaseTask<WandaTrainData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrainTask.class);
    @Autowired
    private IWandaTrainDataService wandaTrainDataService;
    @Autowired
    private IWandaDeclareService wandaDeclareService;
    @Resource
    private WandaTrainDataMapper wandaTrainDataMapper;
    @Autowired
    protected IdWorker idworker;

    @Override
    public String getAppkey() {
        return "BIZ_037_OHOL_TRAINING";
    }

    @Override
    public String getAppSecret() {
        return "123456";
    }

    @Override
    public void save(List<WandaTrainData> reslutList) {
        this.wandaTrainDataService.saveList(reslutList);
    }

    @Override
    public void parseData(List<WandaTrainData> reslutList, JSONArray data) {
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String sourceId = jsonObject.getString("ID");
                jsonObject.put("sourceId", (Object)sourceId);
                jsonObject.remove((Object)"ID");
                WandaTrainData object = (WandaTrainData)jsonObject.toJavaObject(WandaTrainData.class);
                object.setId(Long.valueOf(this.idworker.nextId()));
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                object.setIsValid(Boolean.valueOf(true));
                reslutList.add(object);
            }
        }
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    @XxlJob(value="TrainTask-syncdata")
    public synchronized void syncdata() throws UnsupportedEncodingException {
        Date maxLoadTime;
        String endDateStr;
        JSONObject jsonObj;
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u57f9\u8bad\u6570\u636e\u62c9\u53d6\u5f00\u59cb=============================");
        long start = System.currentTimeMillis();
        ArrayList reslutList = new ArrayList();
        Date startDate = null;
        Date endDate = new Date();
        String jobParam = XxlJobHelper.getJobParam();
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null && !StringUtil.isEmpty((String)(endDateStr = jsonObj.getString("endDateStr")))) {
            log.info("\u63a5\u6536\u5230\u53c2\u6570=========={}", (Object)endDateStr);
            endDate = DateUtils.parseDate((Object)endDateStr);
        }
        if (Objects.nonNull(maxLoadTime = this.wandaTrainDataService.getMaxLoadTime())) {
            startDate = maxLoadTime;
        }
        this.doTask(reslutList, "1", startDate, endDate);
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u57f9\u8bad\u6570\u636e\u62c9\u53d6\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    @XxlJob(value="TrainTask-sync2Company")
    public void sync2Company() {
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u676d\u5dde\u57f9\u8bad\u6570\u636e\u540c\u6b65\u5230\u4f01\u4e1a\u5f00\u59cb=============================");
        long start = System.currentTimeMillis();
        this.wandaTrainDataService.mitigatingRisks(null);
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u676d\u5dde\u57f9\u8bad\u6570\u636e\u540c\u6b65\u5230\u4f01\u4e1a\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    public Map<String, Object> checkNewData() throws UnsupportedEncodingException {
        Map<String, Object> map = this.checkNewData(this.wandaTrainDataService.getMaxLoadTime());
        map.put("name", "train");
        Date busiTime = this.wandaTrainDataMapper.getmAxBusiTime();
        map.put("busiTime", busiTime);
        map.put("existNoConverted", "false");
        return map;
    }
}

