/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.task.pullTask;

import cn.smarthse.services.wanda.api.entity.WandaReportInfo;
import cn.smarthse.services.wanda.api.service.IWandaReportInfoService;
import cn.smarthse.services.wanda.task.pullTask.WandaBaseTask;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ReportInfoTask
extends WandaBaseTask<WandaReportInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportInfoTask.class);
    @DubboReference
    private IWandaReportInfoService wandaReportInfoService;
    @Autowired
    protected IdWorker idworker;

    @Override
    public String getAppkey() {
        return "BIZ_037_ZYWS_REPORT_INFO_ZJ";
    }

    @Override
    public String getAppSecret() {
        return "123456ZJ";
    }

    @Override
    public void save(List<WandaReportInfo> reslutList) {
        this.wandaReportInfoService.batchInsert(reslutList);
    }

    @XxlJob(value="ReportInfoTask-syncData")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void syncData() throws UnsupportedEncodingException {
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u804c\u4e1a\u536b\u751f-\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u6570\u636e\u63d2\u5165\u5f00\u59cb=============================");
        long start = System.currentTimeMillis();
        ArrayList resultList = new ArrayList();
        Date startDate = null;
        Date maxLoadTime = this.wandaReportInfoService.getMaxBizDate();
        if (Objects.nonNull(maxLoadTime)) {
            startDate = maxLoadTime;
        }
        this.doTask(resultList, "1", startDate, new Date());
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u804c\u4e1a\u536b\u751f-\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u6570\u636e\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    @Override
    public void parseData(List<WandaReportInfo> resultList, JSONArray data) {
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String sourceId = jsonObject.getString("ID");
                jsonObject.put("sourceId", (Object)sourceId);
                jsonObject.remove((Object)"ID");
                WandaReportInfo object = (WandaReportInfo)data.getObject(i, WandaReportInfo.class);
                object.setId(Long.valueOf(this.idworker.nextId()));
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                resultList.add(object);
            }
        }
    }
}

