/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.task.pullTask;

import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.services.wanda.api.entity.WandaHealthCard;
import cn.smarthse.services.wanda.api.service.IWandaHcAbnormalService;
import cn.smarthse.services.wanda.api.service.IWandaHealthCardService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaHealthCardMapper;
import cn.smarthse.services.wanda.task.pullTask.WandaBaseTask;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class HealthCardTask
extends WandaBaseTask<WandaHealthCard> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthCardTask.class);
    @DubboReference
    private IWandaHealthCardService healthCardService;
    @DubboReference
    private IWandaHcAbnormalService abnormalService;
    @DubboReference
    private IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;
    @Resource
    private WandaHealthCardMapper wandaHealthCardMapper;
    @Autowired
    protected IdWorker idworker;

    @Override
    public String getAppkey() {
        return "BIZ_037_ZYWS_HEALTH_CARD_ZJ";
    }

    @Override
    public String getAppSecret() {
        return "123456ZJ";
    }

    @Override
    public void save(List<WandaHealthCard> reslutList) {
        if (reslutList == null || reslutList.isEmpty()) {
            log.error("\u4fdd\u5b58WandaHealthCard\u6570\u636e\u5931\u8d25: \u4f20\u5165\u7684\u6570\u636e\u5217\u8868\u4e3a\u7a7a\u6216\u4e3anull");
            return;
        }
        try {
            log.error("\u5f00\u59cb\u6279\u91cf\u4fdd\u5b58WandaHealthCard\u6570\u636e, \u6570\u636e\u91cf: {}", (Object)reslutList.size());
            long startTime = System.currentTimeMillis();
            this.healthCardService.batchInsert(reslutList);
            long costTime = System.currentTimeMillis() - startTime;
            log.error("\u6210\u529f\u4fdd\u5b58WandaHealthCard\u6570\u636e, \u6570\u636e\u91cf: {}, \u8017\u65f6: {}ms", (Object)reslutList.size(), (Object)costTime);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u4fdd\u5b58WandaHealthCard\u5931\u8d25, \u6570\u636e\u91cf: {}", (Object)reslutList.size(), (Object)e);
            throw new RuntimeException("\u4fdd\u5b58WandaHealthCard\u5931\u8d25", e);
        }
    }

    public void save2(List<WandaHealthCard> reslutList) {
        if (reslutList == null || reslutList.isEmpty()) {
            log.error("\u4fdd\u5b58WandaHealthCard\u6570\u636e\u5931\u8d25: \u4f20\u5165\u7684\u6570\u636e\u5217\u8868\u4e3a\u7a7a\u6216\u4e3anull");
            return;
        }
        try {
            log.error("\u5f00\u59cb\u6279\u91cf\u4fdd\u5b58WandaHealthCard\u6570\u636e, \u6570\u636e\u91cf: {}", (Object)reslutList.size());
            long startTime = System.currentTimeMillis();
            this.healthCardService.batchInsert2(reslutList);
            long costTime = System.currentTimeMillis() - startTime;
            log.error("\u6210\u529f\u4fdd\u5b58WandaHealthCard\u6570\u636e, \u6570\u636e\u91cf: {}, \u8017\u65f6: {}ms", (Object)reslutList.size(), (Object)costTime);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u4fdd\u5b58WandaHealthCard\u5931\u8d25, \u6570\u636e\u91cf: {}", (Object)reslutList.size(), (Object)e);
            throw new RuntimeException("\u4fdd\u5b58WandaHealthCard\u5931\u8d25", e);
        }
    }

    @Override
    public void parseData(List<WandaHealthCard> reslutList, JSONArray data) {
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String sourceId = jsonObject.getString("ID");
                jsonObject.put("sourceId", (Object)sourceId);
                jsonObject.remove((Object)"ID");
                WandaHealthCard object = (WandaHealthCard)jsonObject.toJavaObject(WandaHealthCard.class);
                object.setId(Long.valueOf(this.idworker.nextId()));
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                object.setIsValid(Boolean.valueOf(true));
                object.setIsConverted(Byte.valueOf((byte)0));
                object.setOrgCode(object.getOrgCode() == null ? object.getOrgName() : object.getOrgCode());
                reslutList.add(object);
            }
        }
    }

    @XxlJob(value="HealthCardTask-syncdata")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public synchronized void syncdata() throws UnsupportedEncodingException {
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u4f53\u68c0\u6570\u636e\u63d2\u5165\u5f00\u59cb=============================");
        long start = System.currentTimeMillis();
        ArrayList reslutList = new ArrayList();
        Date startDate = null;
        Date maxLoadTime = this.healthCardService.getMaxLoadTime();
        if (Objects.nonNull(maxLoadTime)) {
            startDate = maxLoadTime;
        }
        this.doTask(reslutList, "1", startDate, new Date());
        log.info("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u4f53\u68c0\u6570\u636e\u63d2\u5165\u5f00\u59cb\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    @XxlJob(value="HealthCardTask-syncdataCustom")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public synchronized void syncdataCustom() throws UnsupportedEncodingException {
        log.error("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u4f53\u68c0\u6570\u636e\u63d2\u5165\u5f00\u59cb=============================");
        long start = System.currentTimeMillis();
        ArrayList reslutList = new ArrayList();
        String startStr = this.getParamValue("start");
        String endStr = this.getParamValue("end");
        Date startDate = null;
        Date endDate = null;
        try {
            SimpleDateFormat sdf;
            if (StringUtils.isNotBlank((CharSequence)startStr)) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                startDate = sdf.parse(startStr);
            }
            if (StringUtils.isNotBlank((CharSequence)endStr)) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                endDate = sdf.parse(endStr);
            }
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\uff0cstartStr: {}, endStr: {}", new Object[]{startStr, endStr, e});
            return;
        }
        if (startDate == null || endDate == null) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u505c\u6b62\uff1a\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a\uff0cstartDate: {}, endDate: {}", (Object)startDate, endDate);
            return;
        }
        if (startDate.after(endDate)) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u505c\u6b62\uff1a\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4\uff0cstartDate: {}, endDate: {}", (Object)startDate, (Object)endDate);
            return;
        }
        this.doTask2(reslutList, "1", startDate, endDate);
        log.error("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u4f53\u68c0\u6570\u636e\u63d2\u5165\u7ed3\u675f\uff0c\u8017\u65f6:{}\u79d2", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    public Map<String, Object> checkNewData() throws UnsupportedEncodingException {
        Date maxLoadTime = this.healthCardService.getMaxLoadTime();
        Date maxBusiTime = this.wandaHealthCardMapper.getMaxBusiTime();
        Map<String, Object> map = this.checkNewData(maxLoadTime);
        map.put("busiTime", maxBusiTime);
        map.put("name", "healthCard");
        map.put("existNoConverted", "false");
        return map;
    }

    private String getParamValue(String paramName) {
        JSONObject jsonObj;
        String paramValue = null;
        String jobParam = XxlJobHelper.getJobParam();
        if (CharSequenceUtil.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null) {
            paramValue = jsonObj.getString(paramName);
        }
        return paramValue;
    }

    @XxlJob(value="HealthCardTask-wandaAbnormalData")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void wandaAbnormalData(Date start, Date end) throws InterruptedException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String endStr;
            String startStr;
            if (start == null && StringUtils.isNotBlank((CharSequence)(startStr = this.getParamValue("start")))) {
                start = sdf.parse(startStr);
            }
            if (end == null && StringUtils.isNotBlank((CharSequence)(endStr = this.getParamValue("end")))) {
                end = sdf.parse(endStr);
            }
        }
        catch (ParseException e) {
            log.warn("\u53c2\u6570\u89e3\u6790\u5931\u8d25: start={}, end={}", new Object[]{this.getParamValue("start"), this.getParamValue("end"), e});
        }
        this.abnormalService.updateBakDbData(start, end);
        List allList = this.abnormalService.getAbnormalDataByYear(start, end);
        log.error("\u5b9a\u65f6\u4efb\u52a1->\u4e07\u8fbe\u4ed3\u4f53\u68c0\u6570\u636e\u63d2\u5165\u7ed3\u675f\uff0c\u5171\u83b7\u53d6\u5f02\u5e38\u6570\u636e {} \u6761", (Object)allList.size());
    }
}

