/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.task.pullTask;

import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.services.component.AsyncTask;
import cn.smarthse.services.component.AsyncTaskExecutor;
import cn.smarthse.services.wanda.api.entity.WandaHcItems;
import cn.smarthse.services.wanda.api.service.IWandaHcItemsService;
import cn.smarthse.services.wanda.task.pullTask.WandaBaseTask;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HcItemsTask
extends WandaBaseTask<WandaHcItems> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HcItemsTask.class);
    @DubboReference
    private IWandaHcItemsService wandaHcItemsService;
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private AsyncTaskExecutor executor;

    @XxlJob(value="HcItemsTask-ContinuousExecution")
    public synchronized void ContinuousExecution() {
        this.executor.execute(new AsyncTask(){

            @Override
            public void runTask() {
                try {
                    HcItemsTask.this.hcItemsListData();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
        log.info("\u5f00\u59cb\u5f02\u6b65\u6267\u884c\u4f53\u68c0\u8f6c\u6362");
    }

    public synchronized void hcItemsListData() throws UnsupportedEncodingException {
        ArrayList reslutList = new ArrayList();
        Date startDate = DateUtil.getDate((String)"2022-12-20", (String)"yyyy-MM-dd");
        Date maxLoadTime = this.wandaHcItemsService.getMaxBizDate();
        if (Objects.nonNull(maxLoadTime)) {
            startDate = maxLoadTime;
        }
        Date endDate = DateUtil.getNextDate((Date)startDate, (int)1);
        String dateString = DateUtil.getDateString((int)DateUtil.getYear(), (int)DateUtil.getMonth(), (int)DateUtil.getDay()) + " 04:00:00";
        Date date = DateUtil.getDate((String)dateString, (String)"yyyy-MM-dd HH:mm:ss");
        while (endDate.before(new Date()) && date.after(new Date())) {
            this.doTask(reslutList, "1", startDate, endDate);
            startDate = endDate;
            endDate = DateUtil.getNextDate((Date)startDate, (int)1);
        }
    }

    @Override
    public String getAppSecret() {
        return "123456ZJ";
    }

    @Override
    public String getAppkey() {
        return "BIZ_037_ZYWS_HC_ITEMS_ZZ";
    }

    @Override
    public void save(List<WandaHcItems> reslutList) {
        this.wandaHcItemsService.batchInsert(reslutList);
    }

    @Override
    public void parseData(List<WandaHcItems> reslutList, JSONArray data) {
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String sourceId = jsonObject.getString("ID");
                jsonObject.put("sourceId", (Object)sourceId);
                jsonObject.remove((Object)"ID");
                WandaHcItems object = (WandaHcItems)jsonObject.toJavaObject(WandaHcItems.class);
                object.setId(Long.valueOf(this.idworker.nextId()));
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                reslutList.add(object);
            }
        }
    }
}

