/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.task.pullTask;

import cn.smarthse.services.wanda.api.entity.WandaHcFactors;
import cn.smarthse.services.wanda.api.service.IWandaHcFactorsService;
import cn.smarthse.services.wanda.task.pullTask.WandaBaseTask;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class HcFactorsTask
extends WandaBaseTask<WandaHcFactors> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HcFactorsTask.class);
    @DubboReference
    private IWandaHcFactorsService wandaHcFactorsService;
    @Autowired
    protected IdWorker idworker;

    @XxlJob(value="HcFactorsTask-hcFactorsListData")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public synchronized void hcFactorsListData() throws UnsupportedEncodingException {
        ArrayList reslutList = new ArrayList();
        Date startDate = null;
        Date maxLoadTime = this.wandaHcFactorsService.getMaxBizDate();
        if (Objects.nonNull(maxLoadTime)) {
            startDate = maxLoadTime;
        }
        this.doTask(reslutList, "1", startDate, new Date());
    }

    @Override
    public String getAppSecret() {
        return "123456ZJ";
    }

    @Override
    public String getAppkey() {
        return "BIZ_037_ZYWS_HC_FACTORS_ZZ";
    }

    @Override
    public void save(List<WandaHcFactors> reslutList) {
        if (reslutList == null || reslutList.isEmpty()) {
            log.error("\u4fdd\u5b58WandaHcFactors\u6570\u636e\u5931\u8d25: \u4f20\u5165\u7684\u6570\u636e\u5217\u8868\u4e3a\u7a7a\u6216\u4e3anull");
            return;
        }
        try {
            log.error("\u5f00\u59cb\u6279\u91cf\u4fdd\u5b58WandaHcFactors\u6570\u636e, \u6570\u636e\u91cf: {}", (Object)reslutList.size());
            long startTime = System.currentTimeMillis();
            this.wandaHcFactorsService.batchInsert(reslutList);
            long costTime = System.currentTimeMillis() - startTime;
            log.error("\u6210\u529f\u4fdd\u5b58WandaHcFactors\u6570\u636e, \u6570\u636e\u91cf: {}, \u8017\u65f6: {}ms", (Object)reslutList.size(), (Object)costTime);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u4fdd\u5b58WandaHcFactors\u5931\u8d25, \u6570\u636e\u91cf: {}", (Object)reslutList.size(), (Object)e);
            throw new RuntimeException("\u4fdd\u5b58WandaHcFactors\u6570\u636e\u5931\u8d25", e);
        }
    }

    @Override
    public void parseData(List<WandaHcFactors> reslutList, JSONArray data) {
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String sourceId = jsonObject.getString("ID");
                jsonObject.put("sourceId", (Object)sourceId);
                jsonObject.remove((Object)"ID");
                WandaHcFactors object = (WandaHcFactors)jsonObject.toJavaObject(WandaHcFactors.class);
                object.setId(Long.valueOf(this.idworker.nextId()));
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                reslutList.add(object);
            }
        }
    }
}

