/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pushdata.wsdl;

import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.services.wanda.pushdata.wsdl.req2.WandaRequestBody;
import cn.smarthse.services.wanda.pushdata.wsdl.req2.WandaRequestDataList;
import cn.smarthse.services.wanda.pushdata.wsdl.req2.WandaRequestHeader;
import cn.smarthse.services.wanda.pushdata.wsdl.req2.WandaRequestRequest;
import cn.smarthse.services.wanda.pushdata.wsdl.req2.WandaRequestRoot;
import cn.smarthse.services.wanda.pushdata.wsdl.res.WandaResponseRoot;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.github.pagehelper.PageInfo;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.assertj.core.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WandaWebServiceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaWebServiceUtils.class);
    private static final String ENCODING = "utf-8";
    private static final XmlMapper xmlMapper = new XmlMapper();
    static CloseableHttpClient httpClient = HttpClients.createDefault();
    private static final String DATAQUERYSERVICE_SOAP_REQUEST_XML = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ws=\"http://ws.databus.wondersgroup.com/\"><soapenv:Header/> <soapenv:Body><ws:dataQueryService> <arg0>##appKey</arg0><arg1>##strSysDatetime</arg1><arg2>##pageNum</arg2><arg3>##pageSize</arg3><arg4>##queryPara</arg4><arg5>##dataType</arg5><arg6>##sign</arg6></ws:dataQueryService></soapenv:Body></soapenv:Envelope>";
    private static final String DATARECEIVESERVICE_SOAP_REQUEST_XML = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"  xmlns:ws=\"http://ws.databus.wondersgroup.com/\">\n    <soapenv:Header/>\n    <soapenv:Body>\n        <ws:dataReceiveService>\n            <arg0>##msgId</arg0>\n            <arg1>##appKey</arg1>\n            <arg2>##strSysDatetime</arg2>\n            <arg3>##num</arg3>\n            <arg4>##dataType</arg4>\n            <arg5>##dataKey</arg5>\n            <arg6>##data</arg6>\n            <arg7>##oper</arg7>\n            <arg8>##sign</arg8>\n        </ws:dataReceiveService>\n    </soapenv:Body>\n</soapenv:Envelope>";

    public static void pullDataSingle(Object o, String appKey, String appSecret, String dataKey, String oper) throws JsonProcessingException {
        PageInfo pageInfo = PageInfo.of((List)Arrays.asList((Object)o));
        WandaWebServiceUtils.pullData(pageInfo, appKey, appSecret, dataKey, oper);
    }

    public static WandaResponseRoot pullData(PageInfo pageInfo, String appKey, String appSecret, String dataKey, String oper) throws JsonProcessingException {
        if (pageInfo == null || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return null;
        }
        String strtime = DateUtils.format((Date)new Date(), (String)"yyyyMMdd");
        String secretOut = "24aa087c805c76e2d58044e86d7a63a3";
        String signout = DigestUtils.md5Hex((String)(appKey + strtime + secretOut));
        String strSecretWsdlUrl = "http://10.142.61.89:8082/dataReceiveService/ws/pulldata?wsdl&appkey=" + appKey + "&strtime=" + strtime + "&sign=" + signout;
        String msgId = UUID.randomUUID().toString();
        String dateTime = DateUtils.formatDateTime((Date)new Date());
        WandaRequestDataList dataList = new WandaRequestDataList();
        dataList.getData().add(pageInfo.getList());
        int dataLength = pageInfo.getList().size();
        WandaRequestBody body = new WandaRequestBody(dataList);
        WandaRequestHeader header = new WandaRequestHeader();
        header.setAction("pull");
        header.setRecords("" + dataLength);
        header.setMsgId(msgId);
        header.setSendTime(dateTime);
        header.setPageSize("" + pageInfo.getPageSize());
        header.setPageSum("" + pageInfo.getPages());
        header.setPageNum("" + pageInfo.getPageNum());
        WandaRequestRequest requestRequest = new WandaRequestRequest(body, header);
        WandaRequestRoot root = new WandaRequestRoot(requestRequest);
        String xml = xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true).writeValueAsString((Object)root);
        String sign = DigestUtils.md5Hex((String)(appKey + dateTime + appSecret));
        String xmldes = "<![CDATA[" + xml + "]]>";
        String responseResult = WandaWebServiceUtils.dataReceiveService(strSecretWsdlUrl, msgId, appKey, dateTime, "" + dataLength, "XML", dataKey, xmldes, oper, sign);
        DebugUtils.error((String)"WandaWebServiceUtils \u8bf7\u6c42webservice\u7ed3\u679cresponseResult\uff1a{}", (Object[])new Object[]{responseResult});
        WandaResponseRoot requestroot = (WandaResponseRoot)xmlMapper.readValue(responseResult, WandaResponseRoot.class);
        return requestroot;
    }

    public static String dataQueryService(String webServiceUrl, String appKey, String strSysDatetime, int pageNum, int pageSize, String queryPara, String dataType, String sign) {
        String result = "";
        try {
            String xml = WandaWebServiceUtils.putDataQueryParamsValues(appKey, strSysDatetime, pageNum, pageSize, queryPara, dataType, sign);
            result = WandaWebServiceUtils.doPostWebservice(webServiceUrl, xml);
        }
        catch (Exception e) {
            log.error("\u4e07\u8fbewebservice\u6570\u636e\u67e5\u8be2\u670d\u52a1\u8bf7\u6c42\u51fa\u9519\uff1a", (Throwable)e);
        }
        return result;
    }

    public static String dataReceiveService(String webServiceUrl, String msgId, String appKey, String strSysDatetime, String num, String dataType, String dataKey, String data, String oper, String sign) {
        String result = "";
        try {
            String xml = WandaWebServiceUtils.putDataReceiveParamsValues(msgId, appKey, strSysDatetime, num, dataType, dataKey, data, oper, sign);
            result = WandaWebServiceUtils.doPostWebservice(webServiceUrl, xml);
        }
        catch (Exception e) {
            log.error("\u4e07\u8fbewebservice\u6570\u636e\u63a8\u9001\u670d\u52a1\u8bf7\u6c42\u51fa\u9519\uff1a", (Throwable)e);
        }
        return result;
    }

    private static String putDataQueryParamsValues(String appKey, String strSysDatetime, int pageNum, int pageSize, String queryPara, String dataType, String sign) {
        return DATAQUERYSERVICE_SOAP_REQUEST_XML.replace("##appKey", appKey).replace("##strSysDatetime", strSysDatetime).replace("##pageNum", "" + pageNum).replace("##pageSize", "" + pageSize).replace("##queryPara", queryPara).replace("##dataType", dataType).replace("##sign", sign);
    }

    private static String putDataReceiveParamsValues(String msgId, String appKey, String strSysDatetime, String num, String dataType, String dataKey, String data, String oper, String sign) {
        return DATARECEIVESERVICE_SOAP_REQUEST_XML.replace("##msgId", msgId).replace("##appKey", appKey).replace("##strSysDatetime", strSysDatetime).replace("##num", num).replace("##dataType", dataType).replace("##dataKey", dataKey).replace("##data", data).replace("##oper", oper).replace("##sign", sign);
    }

    public static String doPostWebservice(String url, String xml) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "text/xml;charset=UTF-8");
        StringEntity data = new StringEntity(xml, Charset.forName("UTF-8"));
        httpPost.setEntity((HttpEntity)data);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)ENCODING);
        resultString = resultString.replace("&lt;", "<");
        resultString = resultString.replace("&gt;", ">");
        if (resultString == null || resultString.indexOf("<return>") <= 0) {
            return resultString;
        }
        resultString = resultString.substring(resultString.indexOf("<return>") + 8, resultString.indexOf("</return>"));
        return resultString;
    }
}

