/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pushdata.hse.service.impl;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.compare.CompareUtils;
import cn.smarthse.services.wanda.api.entity.company.WandaPullCompany;
import cn.smarthse.services.wanda.api.service.IHseCollectBaseService;
import cn.smarthse.services.wanda.pushdata.hse.dao.WandaPullCompanyMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WandaPullCompanyServiceImpl
extends ServiceImpl<WandaPullCompanyMapper, WandaPullCompany>
implements IHseCollectBaseService {
    @Autowired
    WandaPullCompanyMapper wandaCompanyMapper;

    public boolean needPull(WandaPullCompany dbCompany, WandaPullCompany collectCompany) {
        CompareUtils companyCompareUtils = new CompareUtils();
        String compare = companyCompareUtils.compare((Object)dbCompany, (Object)collectCompany, Arrays.asList("isValid,createBy,createDate,updateBy,updateDate,lastPullDate,needPull,isAdd,isProc"));
        return StringUtils.isNotBlank((CharSequence)compare);
    }

    @Transactional(readOnly=false)
    public void collect() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        List dbAllCompanyList = this.wandaCompanyMapper.selectList((Wrapper)wrapper);
        List<WandaPullCompany> collectCompanyDataList = this.wandaCompanyMapper.collectCompanyData();
        Map<Object, Object> dbCompanyMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dbAllCompanyList)) {
            dbCompanyMap = dbAllCompanyList.stream().collect(Collectors.toMap(k -> k.getId(), v -> v));
        }
        ArrayList<WandaPullCompany> addList = new ArrayList<WandaPullCompany>();
        ArrayList<WandaPullCompany> updateList = new ArrayList<WandaPullCompany>();
        if (CollectionUtils.isNotEmpty(collectCompanyDataList)) {
            for (WandaPullCompany wandaPullCompany : collectCompanyDataList) {
                if (dbCompanyMap.containsKey(wandaPullCompany.getId())) {
                    WandaPullCompany dbCompanyPull = (WandaPullCompany)dbCompanyMap.get(wandaPullCompany.getId());
                    if (!this.needPull(dbCompanyPull, wandaPullCompany)) continue;
                    wandaPullCompany.setIsAdd(Integer.valueOf(0));
                    wandaPullCompany.setUpdateDate(LocalDateTime.now());
                    updateList.add(wandaPullCompany);
                    continue;
                }
                wandaPullCompany.setIsAdd(Integer.valueOf(1));
                wandaPullCompany.setCreateDate(LocalDateTime.now());
                addList.add(wandaPullCompany);
            }
            if (CollectionUtils.isNotEmpty(addList)) {
                this.saveBatch(addList);
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                this.updateBatchById(updateList);
            }
        }
    }
}

