/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pushdata.hse.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import cn.smarthse.services.wanda.api.entity.GiianUpdateParam;
import cn.smarthse.services.wanda.api.entity.WandaCheckBackPushLog;
import cn.smarthse.services.wanda.api.entity.WandaCheckReturn;
import cn.smarthse.services.wanda.api.enums.WandCheckBackTypeEnm;
import cn.smarthse.services.wanda.api.service.IWandaCheckBackPushLogService;
import cn.smarthse.services.wanda.api.service.IWandaCheckReturnService;
import cn.smarthse.services.wanda.pushdata.wsdl.WandaWebServiceUtils;
import cn.smarthse.services.wanda.pushdata.wsdl.res.WandaResponseReport;
import cn.smarthse.services.wanda.pushdata.wsdl.res.WandaResponseRoot;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@DubboService(timeout=600000)
public class WandaCheckReturnServiceImpl
implements IWandaCheckReturnService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String appKey = "BIZ_037_ZYWS_CHECK_RETURN";
    private static final String appKey4181 = "BIZ_037_ZYWS_RI_RETRUN";
    @Value(value="${spring.profiles.active:}")
    private String environment;
    @Value(value="${giian.url:}")
    private String giianUrl;
    @Autowired
    private IWandaCheckBackPushLogService backPushLogService;

    public int backToWanda(WandaCheckReturn data) {
        if (data == null) {
            return 0;
        }
        try {
            boolean isProEnvironment = Arrays.stream(this.environment.split(",")).map(String::trim).anyMatch(s -> "pro".equalsIgnoreCase((String)s) || "prod".equalsIgnoreCase((String)s));
            if (isProEnvironment) {
                WandaWebServiceUtils.pullDataSingle(data, appKey, "123456", "ID", "add");
            }
            WandaCheckBackPushLog log = new WandaCheckBackPushLog();
            log.setCheckId(data.getCheckId());
            log.setType(data.getType());
            log.setReason(data.getReason());
            log.setDealState(data.getDealState());
            log.setStatus(Integer.valueOf(1));
            log.setPushDate(new Date());
            log.setSourceId(data.getId());
            log.setCreateDate(new Date());
            log.setUpdateDate(new Date());
            this.backPushLogService.save((Object)log);
            this.logger.info("\u6210\u529f\u9000\u56de\u4e00\u6761\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u6570\u636e");
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int backToGiian(WandaCheckReturn data) {
        int i = this.backToWanda(data);
        if (i > 0) {
            GiianUpdateParam updateParam = GiianUpdateParam.builder().cdcId(data.getCheckId()).cdcInfo(WandCheckBackTypeEnm.normal.getName() + ":" + data.getReason()).cdcState("200").build();
            HttpRequest.post((String)this.giianUrl).body(JSONUtil.toJsonStr((Object)updateParam)).execute();
        }
        return i;
    }

    public int backToGiian4181(WandaCheckReturn data) {
        if (data == null) {
            return 0;
        }
        try {
            boolean isProEnvironment = Arrays.stream(this.environment.split(",")).map(String::trim).anyMatch(s -> "pro".equalsIgnoreCase((String)s) || "prod".equalsIgnoreCase((String)s));
            if (isProEnvironment) {
                WandaWebServiceUtils.pullDataSingle(data, appKey4181, "123456", "ID", "add");
            }
            this.logger.info("\u6210\u529f\u9000\u56de\u4e00\u6761\u4e07\u8fbe\u4ed3report\u68c0\u6d4b\u6570\u636e");
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public Set<Long> backToWanda(List<WandaCheckReturn> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashSet<Long>();
        }
        HashSet<Long> ids = new HashSet<Long>();
        try {
            PageInfo pageInfo = new PageInfo(list);
            WandaResponseRoot root = null;
            boolean isProEnvironment = Arrays.stream(this.environment.split(",")).map(String::trim).anyMatch(s -> "pro".equalsIgnoreCase((String)s) || "prod".equalsIgnoreCase((String)s));
            if (isProEnvironment) {
                root = WandaWebServiceUtils.pullData(pageInfo, appKey, "123456", "ID", "back");
            }
            if (root == null) {
                return new HashSet<Long>();
            }
            if (!"200".equalsIgnoreCase(root.getResponse().getCode())) {
                String[] split;
                WandaResponseReport report = root.getResponse().getReport();
                String failKeys = report.getFailKeys();
                for (String s2 : split = failKeys.substring(1, failKeys.length() - 1).split(",")) {
                    String id = s2.split(":")[1];
                    ids.add(Long.parseLong(id));
                }
                this.logger.error("\u63a8\u9001\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u9000\u56de\u6570\u636e\u9519\u8bef\u6570\u636e{}", (Object)((Object)ids).toString());
            }
            return ids;
        }
        catch (Exception e) {
            e.printStackTrace();
            ids.add(0L);
            return ids;
        }
    }
}

