/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pushdata.hse.service.impl;

import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.wanda.api.entity.log.WandaPullDataLog;
import cn.smarthse.services.wanda.api.model.WandaPullModel;
import cn.smarthse.services.wanda.api.service.IWandaBaseService;
import cn.smarthse.services.wanda.pushdata.hse.service.impl.WandaPullDataLogServiceImpl;
import cn.smarthse.services.wanda.pushdata.hse.webservice.WandaPullDataWebServiceImplService;
import cn.smarthse.services.wanda.pushdata.wsdl.WandaWebServiceUtils;
import cn.smarthse.services.wanda.pushdata.wsdl.res.WandaResponseReport;
import cn.smarthse.services.wanda.pushdata.wsdl.res.WandaResponseRoot;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class WandaBaseServiceImpl<T>
implements IWandaBaseService<T> {
    @Autowired
    WandaPullDataLogServiceImpl pullDataLogService;
    @Value(value="${spring.profiles.active:}")
    private String environment;

    public abstract T mappingDict(T var1);

    public PageInfo<T> pageMainTableById(String startValue, Integer page, Integer pageSize) {
        return null;
    }

    public PageInfo<T> pageMainTableByDate(Date startValue, Integer page, Integer pageSize) {
        return null;
    }

    public abstract String appKey();

    public String appSecret() {
        return "123456";
    }

    public abstract String dataKey();

    public void setNeedFalse(PageInfo<T> pageInfo, Set<String> idSet) {
    }

    public String downStringValue(String startValue) {
        Date date = DateUtils.StringToDate((String)startValue);
        if (date != null) {
            return DateUtils.formatDateTime((Date)date);
        }
        if (StringUtils.isNumber((String)startValue)) {
            Long minLong = Long.parseLong(startValue) - 1L;
            return minLong.toString();
        }
        return null;
    }

    public WandaPullModel fetchData(Integer page, Integer pageSize) {
        WandaPullModel model = new WandaPullModel();
        String startValue = this.getStartValue();
        PageInfo<T> pageInfo = null;
        if (StringUtils.isNumber((String)startValue)) {
            pageInfo = this.pageMainTableById(startValue, page, pageSize);
        } else {
            Date date = DateUtils.StringToDate((String)startValue);
            pageInfo = this.pageMainTableByDate(date, page, pageSize);
        }
        if (pageInfo != null) {
            model.setPageTotal(Integer.valueOf(pageInfo.getPages()));
        } else {
            model.setPageTotal(Integer.valueOf(0));
        }
        model.setObject(pageInfo);
        return model;
    }

    private String getStartValue() {
        String startValue = this.pullDataLogService.getStartValue(this.appKey());
        if (StringUtils.isBlank((CharSequence)startValue)) {
            startValue = this.getMinValue();
            startValue = this.downStringValue(startValue);
        }
        return startValue;
    }

    public void doPush(PageInfo<T> pageInfo) throws JsonProcessingException {
        if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            String startValue = this.getStartValue();
            List list = pageInfo.getList();
            WandaPullDataLog pullDataLog = new WandaPullDataLog();
            pullDataLog.setDataSize(Integer.valueOf(list.size()));
            Object maxValue = this.nextTimeStart(list);
            if (maxValue != null) {
                Date date = DateUtils.StringToDate((String)maxValue.toString());
                if (date != null) {
                    pullDataLog.setNextTimeStartValue(DateUtils.formatDateTime((Date)date));
                } else if (StringUtils.isNumber((String)maxValue.toString())) {
                    pullDataLog.setNextTimeStartValue(maxValue.toString());
                }
            }
            pullDataLog.setThisTimeStartValue(startValue);
            pullDataLog.setDataKey(this.appKey());
            pullDataLog.setUpdateDate(LocalDateTime.now());
            pullDataLog.setCreateDate(LocalDateTime.now());
            ArrayList pullDataList = new ArrayList();
            for (Object t : list) {
                Object result = this.mappingDict(t);
                if (result != null) {
                    pullDataList.add(result);
                    continue;
                }
                pullDataList.add(t);
            }
            DebugUtils.error((String)"environment:{}", (Object[])new Object[]{this.environment});
            boolean isProEnvironment = Arrays.stream(this.environment.split(",")).map(String::trim).anyMatch(s -> "pro".equalsIgnoreCase((String)s) || "prod".equalsIgnoreCase((String)s));
            DebugUtils.error((String)"webservice\u63a8\u9001\u6807\u8bb0\u53c2\u6570\uff0c environment:{}, isProEnvironment:{}", (Object[])new Object[]{this.environment, isProEnvironment});
            WandaResponseRoot root = isProEnvironment ? WandaWebServiceUtils.pullData(pageInfo, this.appKey(), this.appSecret(), this.dataKey(), "add") : WandaPullDataWebServiceImplService.pullData(pageInfo, this.appKey(), this.appSecret(), this.dataKey(), "add");
            DebugUtils.error((String)"webservice\u63a8\u9001\u6807\u8bb0\u53c2\u6570\uff0c root:{},", (Object[])new Object[]{root});
            HashSet<String> idSet = new HashSet<String>();
            if (!"200".equalsIgnoreCase(root.getResponse().getCode())) {
                String[] split;
                WandaResponseReport report = root.getResponse().getReport();
                String failKeys = report.getFailKeys();
                for (String s2 : split = failKeys.substring(1, failKeys.length() - 1).split(",")) {
                    String id = s2.split(":")[1];
                    idSet.add(id);
                }
                pullDataLog.setDataSize(Integer.valueOf(report.getSuccCount()));
            }
            this.setNeedFalse(pageInfo, idSet);
            this.pullDataLogService.save(pullDataLog);
        }
    }

    public List<T> handData(Integer page, Integer pageSize) throws JsonProcessingException {
        WandaPullModel pullModel;
        PageInfo list;
        WandaPullModel model = this.fetchData(page, pageSize);
        Integer pageTotal = model.getPageTotal();
        Integer i = 1;
        while (i <= pageTotal && (list = (PageInfo)(pullModel = this.fetchData(i, pageSize)).getObject()).getList().size() != 0) {
            this.doPush(list);
            Integer n = i;
            i = i + 1;
        }
        return null;
    }

    public abstract Object nextTimeStart(List<T> var1);

    public abstract String getMinValue();

    public List<T> listSbuTable(Set<Long> mainTableIdSet) {
        return null;
    }
}

