/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.services.wanda.api.entity.WandaZywsSuplawCollect;
import cn.smarthse.services.wanda.api.service.IWandaZywsSuplawCollectService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaZywsSuplawCollectMapper;
import cn.smarthse.services.wanda.pulldata.service.impl.BaseServiceImpl;
import cn.smarthse.snowflake.IdWorker;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService(timeout=600000)
public class WandaZywsSuplawCollectServiceImpl
extends BaseServiceImpl<WandaZywsSuplawCollectMapper, WandaZywsSuplawCollect>
implements IWandaZywsSuplawCollectService {
    @Autowired
    protected IdWorker idworker;
    private static final int BATCH_SIZE = 1000;
    @Autowired
    RedissonClient client;
    private static final String WANDAZYWSSUPLAWCOLLECT_LOCKKEY = "wandazywssuplawcollect_lockkey";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    @XxlJob(value="WandaZywsSuplawCollect-collectSpuInfo")
    public void collectSpuInfo() throws InterruptedException {
        XxlJobHelper.log((String)"\u5f00\u59cb\u7edf\u8ba1\u76d1\u7763\u4fe1\u606f.. ", (Object[])new Object[0]);
        List<WandaZywsSuplawCollect> cidYearDataList = ((WandaZywsSuplawCollectMapper)this.dao).collectSpu();
        if (CollectionUtils.isEmpty(cidYearDataList)) {
            return;
        }
        Map<Long, List<WandaZywsSuplawCollect>> cidYearDataMap = cidYearDataList.stream().collect(Collectors.groupingBy(WandaZywsSuplawCollect::getCid));
        RLock lock = this.client.getLock(WANDAZYWSSUPLAWCOLLECT_LOCKKEY);
        if (lock.tryLock(5L, TimeUnit.MINUTES)) {
            XxlJobHelper.log((String)"\u83b7\u5f97wandazywssuplawcollect_lockkey \u9501.. ", (Object[])new Object[0]);
            try {
                Set<Long> cidSet = cidYearDataMap.keySet();
                int thisYear = DateUtils.getThisYear();
                ArrayList<WandaZywsSuplawCollect> resultList = new ArrayList<WandaZywsSuplawCollect>();
                for (Long cid : cidSet) {
                    WandaZywsSuplawCollect collect = new WandaZywsSuplawCollect();
                    collect.setCid(cid);
                    List<WandaZywsSuplawCollect> yearDataSet = cidYearDataMap.get(cid);
                    if (CollectionUtils.isEmpty(yearDataSet)) continue;
                    Set yearSet = yearDataSet.stream().map(WandaZywsSuplawCollect::getYeardata).collect(Collectors.toSet());
                    if (yearSet.contains(thisYear)) {
                        collect.setSupState(Integer.valueOf(1));
                    } else if (yearSet.size() > 0) {
                        collect.setSupState(Integer.valueOf(2));
                    }
                    resultList.add(collect);
                }
                this.collectSpuLawInfo(resultList);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    @XxlJob(value="WandaZywsSuplawCollect-collectLawInfo")
    public void collectLawInfo() throws InterruptedException {
        XxlJobHelper.log((String)"\u5f00\u59cb\u7edf\u8ba1\u6267\u6cd5\u4fe1\u606f.. ", (Object[])new Object[0]);
        List<WandaZywsSuplawCollect> cidYearDataList = ((WandaZywsSuplawCollectMapper)this.dao).collectSpu();
        if (CollectionUtils.isEmpty(cidYearDataList)) {
            return;
        }
        Map<Long, List<WandaZywsSuplawCollect>> cidYearDataMap = cidYearDataList.stream().collect(Collectors.groupingBy(WandaZywsSuplawCollect::getCid));
        RLock lock = this.client.getLock(WANDAZYWSSUPLAWCOLLECT_LOCKKEY);
        if (lock.tryLock(5L, TimeUnit.MINUTES)) {
            XxlJobHelper.log((String)"\u83b7\u5f97wandazywssuplawcollect_lockkey \u9501.. ", (Object[])new Object[0]);
            try {
                if (MapUtils.isEmpty(cidYearDataMap)) {
                    return;
                }
                Set<Long> cidSet = cidYearDataMap.keySet();
                int thisYear = DateUtils.getThisYear();
                ArrayList<WandaZywsSuplawCollect> resultList = new ArrayList<WandaZywsSuplawCollect>();
                for (Long cid : cidSet) {
                    WandaZywsSuplawCollect collect = new WandaZywsSuplawCollect();
                    collect.setCid(cid);
                    List<WandaZywsSuplawCollect> yearDataSet = cidYearDataMap.get(cid);
                    if (CollectionUtils.isEmpty(yearDataSet)) continue;
                    Set yearSet = yearDataSet.stream().map(WandaZywsSuplawCollect::getYeardata).collect(Collectors.toSet());
                    if (yearSet.contains(thisYear)) {
                        collect.setLawState(Integer.valueOf(1));
                    } else if (yearSet.size() > 0) {
                        collect.setLawState(Integer.valueOf(2));
                    }
                    resultList.add(collect);
                }
                this.collectSpuLawInfo(resultList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Transactional(readOnly=false)
    public void collectSpuLawInfo(List<WandaZywsSuplawCollect> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<WandaZywsSuplawCollect> allData = ((WandaZywsSuplawCollectMapper)this.dao).getAllData();
        Map<Object, Object> cidIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(allData)) {
            cidIdMap = allData.stream().collect(Collectors.toMap(WandaZywsSuplawCollect::getCid, WandaZywsSuplawCollect::getId));
        }
        ArrayList<WandaZywsSuplawCollect> addList = new ArrayList<WandaZywsSuplawCollect>();
        ArrayList<WandaZywsSuplawCollect> updateList = new ArrayList<WandaZywsSuplawCollect>();
        for (WandaZywsSuplawCollect wandaZywsSuplawCollect : list) {
            if (cidIdMap.containsKey(wandaZywsSuplawCollect.getCid())) {
                Long collectId = (Long)cidIdMap.get(wandaZywsSuplawCollect.getCid());
                wandaZywsSuplawCollect.setId(collectId);
                wandaZywsSuplawCollect.setUpdateDate(new Date());
                updateList.add(wandaZywsSuplawCollect);
                continue;
            }
            wandaZywsSuplawCollect.setId(Long.valueOf(this.idworker.nextId()));
            wandaZywsSuplawCollect.setCreateDate(new Date());
            addList.add(wandaZywsSuplawCollect);
        }
        if (CollectionUtils.isNotEmpty(addList)) {
            this.batchUpdateOrInsert(addList, WandaZywsSuplawCollectMapper.class, (item, mapper) -> mapper.insertSelective(item));
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.batchUpdateOrInsert(updateList, WandaZywsSuplawCollectMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        }
    }
}

