/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.model.org.AddResult;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.services.wanda.api.entity.WandaBaseData;
import cn.smarthse.services.wanda.api.entity.WandaCheckBackPushLog;
import cn.smarthse.services.wanda.api.entity.WandaDictValue;
import cn.smarthse.services.wanda.api.entity.WandaZywsReportInfo;
import cn.smarthse.services.wanda.api.entity.WandaZywsReportPoint;
import cn.smarthse.services.wanda.api.entity.WandaZywsReportResult;
import cn.smarthse.services.wanda.api.enums.WandDealStateEnm;
import cn.smarthse.services.wanda.api.service.IWandaCheckBackPushLogService;
import cn.smarthse.services.wanda.api.service.IWandaDictionaryService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckService;
import cn.smarthse.services.wanda.api.service.IWandaZywsReportInfoService;
import cn.smarthse.services.wanda.api.service.IWandaZywsReportPointService;
import cn.smarthse.services.wanda.api.service.IWandaZywsReportResultService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaZywsReportInfoMapper;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService(timeout=600000)
public class WandaZywsReportInfoServiceImpl
extends ServiceImpl<WandaZywsReportInfoMapper, WandaZywsReportInfo>
implements IWandaZywsReportInfoService {
    @DubboReference
    private IWandaZywsReportPointService pointService;
    @DubboReference
    private IWandaZywsReportResultService resultService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference
    private IWandaDictionaryService dictionaryService;
    @DubboReference
    private IWandaZywsCheckService checkService;
    @DubboReference
    private IWandaCheckBackPushLogService backPushLogService;
    @DubboReference(version="1.0.0", timeout=60000)
    private IHarmFactorService harmFactorService;
    @Autowired
    protected IdWorker idworker;

    public Date getMaxBizDate() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"MAX(load_time)"});
        WandaZywsReportInfo reportInfo = (WandaZywsReportInfo)((WandaZywsReportInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        if (reportInfo != null && reportInfo.getLoadTime() != null) {
            return reportInfo.getLoadTime();
        }
        return null;
    }

    @Transactional
    public List<WandaZywsReportInfo> deleteAndSave(List<WandaZywsReportInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List deleteSourceIdList = list.parallelStream().filter(Objects::nonNull).map(WandaZywsReportInfo::getSourceId).filter(Objects::nonNull).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(WandaZywsReportInfo::getSourceId, deleteSourceIdList);
        this.remove((Wrapper)queryWrapper);
        this.addNewOrgForWandaReport(list);
        this.saveBatch(list);
        return list;
    }

    @Transactional
    public List<WandaZywsReportInfo> save(List<WandaZywsReportInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        this.addNewOrgForWandaReport(list);
        this.saveBatch(list);
        return list;
    }

    public List<WandaZywsReportInfo> getNeedConvertToRiskData(String sourceId) {
        PageHelper.startPage((int)1, (int)3000, (boolean)false);
        List<WandaZywsReportInfo> needConvertToRiskData = ((WandaZywsReportInfoMapper)this.baseMapper).getNeedConvertToRiskData(sourceId);
        return needConvertToRiskData.parallelStream().filter(item -> item != null && item.getOrgId() != null).collect(Collectors.toList());
    }

    public List<WandaZywsReportPoint> getWandaReportPointAndResult(List<String> reportIdList) {
        if (CollectionUtils.isEmpty(reportIdList)) {
            return Collections.emptyList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.pointService.lambdaQuery().eq(WandaBaseData::getIsValid, (Object)true)).in(WandaZywsReportPoint::getReportId, reportIdList)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        List pointIdList = list.parallelStream().map(WandaZywsReportPoint::getSourceId).distinct().collect(Collectors.toList());
        List reportResults = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.resultService.lambdaQuery().eq(WandaBaseData::getIsValid, (Object)true)).in(WandaZywsReportResult::getReportPointId, pointIdList)).list();
        if (CollectionUtils.isEmpty((Collection)reportResults)) {
            return Collections.emptyList();
        }
        Map<String, List<WandaZywsReportResult>> resultAndPointIdMap = reportResults.parallelStream().collect(Collectors.groupingBy(WandaZywsReportResult::getReportPointId));
        Map riskFactor = this.dictionaryService.getAllWandZywsReportRiskFactorByCache();
        List ownHarmFactorList = this.dictionaryService.getOwnHarmFactorList(null);
        Map ownHarmFactorMap = ownHarmFactorList.parallelStream().collect(Collectors.toMap(HarmFactor::getNameCh, Function.identity(), (v1, v2) -> v2));
        ArrayList wandaCheckBackPushLogList = new ArrayList();
        List<WandaZywsReportPoint> collect = list.parallelStream().peek(item -> {
            WandaCheckBackPushLog errorLog = new WandaCheckBackPushLog();
            WandaDictValue wandaDictValue = (WandaDictValue)riskFactor.get(item.getCheckItemCode());
            if (wandaDictValue != null && StringUtils.isNotBlank((CharSequence)wandaDictValue.getValueLabel())) {
                String factorName = wandaDictValue.getValueLabel();
                item.setCheckItemFactorName(factorName);
                item.setFactorName(factorName);
                HarmFactor factor = (HarmFactor)ownHarmFactorMap.get(factorName);
                if (factor != null) {
                    item.setFactorId(factor.getId());
                    item.setFactorNature(Integer.valueOf(factor.getHazardNatureStr().equals("\u4e25\u91cd") ? 2 : 1));
                } else {
                    errorLog.setCheckId(item.getReportId());
                    errorLog.setType(Integer.valueOf(99));
                    errorLog.setDealState(WandDealStateEnm.four.getCode().toString());
                    errorLog.setReason("\u6211\u4eec\u5e93\u91cc\u4e0d\u5b58\u5728\u8be5\u5371\u5bb3\u56e0\u7d20,\u4e3b\u8868sourceId:" + item.getReportId() + "\u8be5\u9879\u5b50\u8868sourceId:" + item.getSourceId());
                    errorLog.setStatus(Integer.valueOf(1));
                    errorLog.setPushDate(new Date());
                    errorLog.setSourceId(item.getId());
                    errorLog.setCreateDate(new Date());
                    wandaCheckBackPushLogList.add(errorLog);
                }
            } else {
                errorLog.setCheckId(item.getReportId());
                errorLog.setType(Integer.valueOf(98));
                errorLog.setReason("\u5371\u5bb3\u56e0\u7d20id\u5bf9\u5e94\u5b57\u5178\u4e3a\u7a7a,\u4e3b\u8868sourceId:" + item.getReportId() + "\u8be5\u9879\u5b50\u8868sourceId:" + item.getSourceId());
                errorLog.setStatus(Integer.valueOf(1));
                errorLog.setDealState(WandDealStateEnm.four.getCode().toString());
                errorLog.setPushDate(new Date());
                errorLog.setSourceId(item.getId());
                errorLog.setCreateDate(new Date());
                wandaCheckBackPushLogList.add(errorLog);
            }
            item.setReportResultList((List)resultAndPointIdMap.get(item.getSourceId()));
        }).collect(Collectors.toList());
        this.backPushLogService.saveBatch(wandaCheckBackPushLogList);
        return collect;
    }

    @Transactional
    public void addNewOrgForWandaReport(List<WandaZywsReportInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, List<WandaZywsReportInfo>> map = list.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCreditCode())).collect(Collectors.groupingBy(WandaZywsReportInfo::getCreditCode));
        List orgCodeList = list.stream().map(WandaZywsReportInfo::getCreditCode).distinct().collect(Collectors.toList());
        List needCreateOrgCodeList = this.thirdOrganizationService.getNeedCreateOrgCode(orgCodeList);
        for (String orgCode : needCreateOrgCodeList) {
            List<WandaZywsReportInfo> reportInfoList;
            if (StringUtils.isBlank((CharSequence)orgCode) || CollectionUtils.isEmpty(reportInfoList = map.get(orgCode))) continue;
            WandaZywsReportInfo reportInfo = reportInfoList.get(0);
            ThirdOrganization newOrg = new ThirdOrganization();
            newOrg.setId(Long.valueOf(this.idworker.nextId()));
            newOrg.setName(reportInfo.getJgmc());
            newOrg.setCreditCode(reportInfo.getCreditCode());
            newOrg.setLegalPerson(reportInfo.getOrgDirectorName());
            newOrg.setLegalPersonPhone("");
            newOrg.setOrgType(Integer.valueOf(1));
            newOrg.setOrgTypes("1");
            newOrg.setLevel(Integer.valueOf(0));
            newOrg.setRecordManageUnitDicId(Long.valueOf(0L));
            newOrg.setIsEnable(Boolean.valueOf(true));
            newOrg.setHidden(Boolean.valueOf(false));
            newOrg.setBusinessStatus(Byte.valueOf((byte)1));
            newOrg.setCreateBy(Long.valueOf(0L));
            newOrg.setCreateDate(new Date());
            newOrg.setUpdateBy(Long.valueOf(0L));
            newOrg.setUpdateDate(new Date());
            newOrg.setOrgSource(Byte.valueOf((byte)1));
            AddResult addResult = this.thirdOrganizationService.addAndGetResult(newOrg, new ArrayList(), Integer.valueOf(0));
        }
    }
}

