/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.hutool.core.convert.Convert;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.enums.hccheckplan.WandOpStateEnum;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.model.org.AddResult;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.services.wanda.api.entity.WandaBaseData;
import cn.smarthse.services.wanda.api.entity.WandaCheckBackPushLog;
import cn.smarthse.services.wanda.api.entity.WandaZywsCheck;
import cn.smarthse.services.wanda.api.entity.WandaZywsCheckSource;
import cn.smarthse.services.wanda.api.enums.WandCheckBackTypeEnm;
import cn.smarthse.services.wanda.api.service.IWandaCheckBackPushLogService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckFactorsService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaZywsCheckMapper;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService(timeout=600000)
public class WandaZywsCheckServiceImpl
extends ServiceImpl<WandaZywsCheckMapper, WandaZywsCheck>
implements IWandaZywsCheckService {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    protected IdWorker idworker;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference
    private IWandaZywsCheckFactorsService checkFactorsService;
    @DubboReference
    private IWandaCheckBackPushLogService backPushLogService;
    @Value(value="${wanda.url}")
    private String url;

    public Date getMaxBizDate() {
        return ((WandaZywsCheckMapper)this.baseMapper).getMaxBizDate();
    }

    @Transactional(readOnly=false)
    public int batchInsert(List<WandaZywsCheck> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        for (WandaZywsCheck zyws : list) {
            zyws.setId(Convert.toStr((Object)this.idworker.nextId()));
            zyws.setIsValid(Boolean.valueOf(true));
            zyws.setNeedPull(Byte.valueOf((byte)1));
            zyws.setPushNum(Integer.valueOf(0));
        }
        this.saveBatch(list);
        this.addNewOrgForWanda(list);
        return list.size();
    }

    public Map<String, WandaZywsCheck> getDataMap(List<String> sourceIdList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(WandaBaseData::getIsValid, (Object)true)).in(WandaZywsCheck::getSourceId, sourceIdList)).select(new SFunction[]{WandaZywsCheck::getSourceId, WandaBaseData::getLoadTime, WandaBaseData::getCreateDate}).list().stream().filter(item -> item != null && item.getSourceId() != null && item.getLoadTime() != null).collect(Collectors.toMap(WandaZywsCheck::getSourceId, Function.identity(), (v1, v2) -> v1.getLoadTime().getTime() > v2.getLoadTime().getTime() ? v1 : v2));
    }

    @Transactional
    public void batchUpdate(List<WandaZywsCheck> updateList) {
        if (CollectionUtils.isEmpty(updateList)) {
            return;
        }
        List<String> checkIdList = updateList.stream().filter(Objects::nonNull).map(WandaZywsCheck::getSourceId).distinct().collect(Collectors.toList());
        this.removeByColumn(checkIdList, "sourceId", false);
        this.batchInsert(updateList);
        this.checkFactorsService.removeFactorAndTargetByColumn(checkIdList, "checkId", Boolean.valueOf(false));
    }

    public void addNewOrgForWanda(List<WandaZywsCheck> list) {
        Map<String, List<WandaZywsCheck>> map = list.stream().collect(Collectors.groupingBy(WandaZywsCheck::getOrgCode));
        List orgCodeList = list.stream().map(WandaZywsCheck::getOrgCode).distinct().collect(Collectors.toList());
        List needCreateOrgCodeList = this.thirdOrganizationService.getNeedCreateOrgCode(orgCodeList);
        for (String orgCode : needCreateOrgCodeList) {
            List<WandaZywsCheck> checkList;
            if (StringUtils.isBlank((CharSequence)orgCode) || CollectionUtils.isEmpty(checkList = map.get(orgCode))) continue;
            WandaZywsCheck wandaZywsCheck = checkList.get(0);
            ThirdOrganization newOrg = new ThirdOrganization();
            newOrg.setId(Long.valueOf(this.idworker.nextId()));
            newOrg.setName(wandaZywsCheck.getOrgName());
            newOrg.setCreditCode(wandaZywsCheck.getOrgCode());
            newOrg.setAreaId(wandaZywsCheck.getRegisterArea());
            newOrg.setAddress(wandaZywsCheck.getRegisterAddress());
            newOrg.setLegalPerson(wandaZywsCheck.getLegalName());
            newOrg.setLegalPersonPhone(wandaZywsCheck.getLegalPhone());
            newOrg.setOrgType(Integer.valueOf(1));
            newOrg.setOrgTypes("1");
            newOrg.setLevel(Integer.valueOf(0));
            newOrg.setRecordManageUnitDicId(Long.valueOf(0L));
            newOrg.setIsEnable(Boolean.valueOf(true));
            newOrg.setHidden(Boolean.valueOf(false));
            newOrg.setBusinessStatus(Byte.valueOf((byte)1));
            newOrg.setCreateBy(Long.valueOf(0L));
            newOrg.setCreateDate(new Date());
            newOrg.setUpdateBy(Long.valueOf(0L));
            newOrg.setUpdateDate(new Date());
            newOrg.setOrgSource(Byte.valueOf((byte)1));
            AddResult result = this.thirdOrganizationService.addAndGetResult(newOrg, new ArrayList(), Integer.valueOf(0));
            if (wandaZywsCheck.getCanService() == null) continue;
            boolean canService = wandaZywsCheck.getCanService().intValue() == 1;
            this.thirdOrganizationService.logout(result.getOrganization().getId(), Long.valueOf(0L), Boolean.valueOf(!canService), Long.valueOf(0L));
        }
    }

    @Transactional
    public Map<String, WandaZywsCheck> verifyData(Map<String, WandaZywsCheck> map) {
        if (CollectionUtils.isEmpty(map) || CollectionUtils.isEmpty(map.values())) {
            return new HashMap<String, WandaZywsCheck>();
        }
        ArrayList<WandaZywsCheck> list = new ArrayList<WandaZywsCheck>(map.values());
        List<String> comCodeList = list.parallelStream().map(WandaZywsCheck::getComCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Map existsCompanyMap = ((WandaZywsCheckMapper)this.baseMapper).getExistsCompany(comCodeList).stream().filter(Objects::nonNull).peek(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getName())) {
                item.setName(cn.smarthse.common.util.StringUtils.toDBC((String)item.getName()));
            }
        }).collect(Collectors.groupingBy(Company::getUnifiedSocialCc, Collectors.mapping(Company::getName, Collectors.toSet())));
        ArrayList<WandaCheckBackPushLog> pushLogList = new ArrayList<WandaCheckBackPushLog>();
        for (WandaZywsCheck item2 : list) {
            if (item2 == null) continue;
            Object reason = "";
            if (StringUtils.isBlank((CharSequence)item2.getComCode())) {
                reason = (String)reason + "\u7528\u4eba\u5355\u4f4d\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a,";
                map.remove(item2.getSourceId());
            } else {
                String comName;
                String unifiedSocialCc = item2.getComCode().toUpperCase(Locale.ROOT);
                if (existsCompanyMap.isEmpty() || !existsCompanyMap.containsKey(unifiedSocialCc)) {
                    reason = (String)reason + "\u8be5\u4f01\u4e1a\u4fe1\u7528\u4ee3\u7801\u5728\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u4e2d\u4e0d\u5b58\u5728\u3002\u5982\u786e\u8ba4\u8be5\u4fe1\u7528\u4ee3\u7801\u65e0\u8bef\uff0c\u53ef\u4e0d\u505a\u8c03\u6574,";
                }
                if (StringUtils.isNotBlank((CharSequence)(comName = item2.getComName()))) {
                    comName = cn.smarthse.common.util.StringUtils.toDBC((String)comName);
                }
                if (!existsCompanyMap.isEmpty() && existsCompanyMap.containsKey(unifiedSocialCc) && CollectionUtils.isNotEmpty((Collection)existsCompanyMap.get(unifiedSocialCc)) && !existsCompanyMap.get(unifiedSocialCc).contains(comName)) {
                    reason = (String)reason + "\u8be5\u4f01\u4e1a\u4fe1\u7528\u4ee3\u7801\u5728\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u4e2d\u5b58\u5728\uff0c\u4f46\u4f01\u4e1a\u540d\u79f0\u4e0e\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u4e2d\u4e0d\u4e00\u81f4(\u82e5\u786e\u8ba4\u4f01\u4e1a\u540d\u79f0\u65e0\u8bef\uff0c\u8bf7\u8054\u7cfb\u201c\u6d59\u91cc\u536b\u4f01\u201d:057189978775),";
                }
            }
            if (item2.getCheckType() == null) {
                reason = (String)reason + "\u68c0\u6d4b\u7c7b\u578b\u4e3a\u7a7a,";
                map.remove(item2.getSourceId());
            }
            if (StringUtils.isBlank((CharSequence)item2.getCheckDate())) {
                reason = (String)reason + "\u68c0\u6d4b\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a,";
                map.remove(item2.getSourceId());
            }
            if (StringUtils.isBlank((CharSequence)item2.getCheckDateEnd())) {
                reason = (String)reason + "\u68c0\u6d4b\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a,";
                map.remove(item2.getSourceId());
            }
            if (StringUtils.isBlank((CharSequence)item2.getCheckOpState())) {
                reason = (String)reason + "check_op_state\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a,";
                map.remove(item2.getSourceId());
            }
            if ((Objects.equals(WandOpStateEnum.CHECK_OP_RECHECK.getState(), item2.getCheckOpState()) || Objects.equals(WandOpStateEnum.CHECK_OP_REPLENISH.getState(), item2.getCheckOpState())) && StringUtils.isBlank((CharSequence)item2.getOldCheckId())) {
                reason = (String)reason + "\u8865\u68c0/\u590d\u68c0\u5bf9\u5e94\u7684\u68c0\u6d4bid\u4e3a\u7a7a,";
                map.remove(item2.getSourceId());
            }
            if (item2.getLoadTime() == null) {
                reason = (String)reason + "LOAD_TIME\u4e3a\u7a7a,";
                item2.setLoadTime(new Date());
                map.remove(item2.getSourceId());
            }
            if (StringUtils.isBlank((CharSequence)reason)) continue;
            WandaCheckBackPushLog log = new WandaCheckBackPushLog();
            log.setCheckId(item2.getSourceId());
            log.setReason((String)reason);
            log.setCreateDate(item2.getLoadTime());
            pushLogList.add(log);
        }
        this.backPushLogService.distinctAddPushLog(pushLogList, WandCheckBackTypeEnm.verifyMain.getCode());
        return map;
    }

    @Transactional
    public Integer removeByColumn(List<String> list, String column, Boolean isLogic) {
        if (CollectionUtils.isEmpty(list) || StringUtils.isBlank((CharSequence)column)) {
            return 0;
        }
        int i = 0;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        switch (column) {
            case "id": {
                if (isLogic.booleanValue()) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(WandaZywsCheck::getId, list)).set(WandaBaseData::getIsValid, (Object)false)).update();
                    break;
                }
                i = ((WandaZywsCheckMapper)this.baseMapper).delete((Wrapper)wrapper.in(WandaZywsCheck::getId, list));
                break;
            }
            case "sourceId": {
                if (isLogic.booleanValue()) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(WandaZywsCheck::getSourceId, list)).set(WandaBaseData::getIsValid, (Object)false)).update();
                    break;
                }
                i = ((WandaZywsCheckMapper)this.baseMapper).delete((Wrapper)wrapper.in(WandaZywsCheck::getSourceId, list));
                break;
            }
        }
        return i;
    }

    @Transactional
    public void insertCheckSourceList(List<WandaZywsCheck> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (WandaZywsCheck check : list) {
            if (check == null) continue;
            check.setId(Convert.toStr((Object)this.idworker.nextId()));
            check.setIsValid(Boolean.valueOf(true));
        }
        List<String> sourceIdList = list.stream().map(WandaZywsCheck::getSourceId).collect(Collectors.toList());
        Integer i = ((WandaZywsCheckMapper)this.baseMapper).deleteLogicWandaZywsCheckSource(sourceIdList);
        Integer j = ((WandaZywsCheckMapper)this.baseMapper).insertBatchCheckSource(list);
    }

    public List<WandaZywsCheckSource> getListWandaCheckSource(WandaZywsCheckSource searchVo) {
        List<WandaZywsCheckSource> list = ((WandaZywsCheckMapper)this.baseMapper).getListWandaCheckSource(searchVo);
        for (WandaZywsCheckSource checkSource : list) {
            String reason;
            if (checkSource == null) continue;
            if (Objects.equals("null", checkSource.getIndustryName()) || Objects.equals("NULL", checkSource.getIndustryName())) {
                checkSource.setIndustryName("");
            }
            if (!StringUtils.isNotBlank((CharSequence)(reason = checkSource.getReason())) || checkSource.getLogBackTime() != null && checkSource.getLoadTime().after(checkSource.getLogBackTime()) || Objects.equals(1, checkSource.getIsConvertRisk())) continue;
            if (reason.contains("\u7528\u4eba\u5355\u4f4d\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a")) {
                checkSource.setReasonStr("\u673a\u6784\u4e0a\u62a5\u7684\u4f01\u4e1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            if (reason.contains("\u8be5\u4f01\u4e1a\u4fe1\u7528\u4ee3\u7801\u5728\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u4e2d\u4e0d\u5b58\u5728")) {
                checkSource.setReasonStr("\u8be5\u4f01\u4e1a\u4fe1\u7528\u4ee3\u7801\u5728\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u4e2d\u4e0d\u5b58\u5728\uff0c\u5982\u786e\u8ba4\u8be5\u4fe1\u7528\u4ee3\u7801\u65e0\u8bef\uff0c\u53ef\u4e0d\u505a\u8c03\u6574");
                continue;
            }
            if (reason.contains("\u8be5\u4f01\u4e1a\u4fe1\u7528\u4ee3\u7801\u5728\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u4e2d\u5b58\u5728\uff0c\u4f46\u4f01\u4e1a\u540d\u79f0\u4e0e\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u4e2d\u4e0d\u4e00\u81f4")) {
                checkSource.setReasonStr("\u8be5\u4f01\u4e1a\u4fe1\u7528\u4ee3\u7801\u5728\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u4e2d\u5b58\u5728\uff0c\u4f46\u673a\u6784\u4e0a\u62a5\u7684\u4f01\u4e1a\u540d\u79f0\u4e0e\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u4e2d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            if (reason.contains("\u65e0\u6709\u6548\u5b50\u8868")) {
                checkSource.setReasonStr("\u673a\u6784\u4e0a\u62a5\u7684\u68c0\u6d4b\u6570\u636e\u672a\u5305\u542b\u5371\u5bb3\u56e0\u7d20\u8be6\u60c5\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            if (reason.contains("\u8f66\u95f4\u540d\u79f0\u4e3a\u7a7a")) {
                checkSource.setReasonStr("\u673a\u6784\u4e0a\u62a5\u6570\u636e\u6709\u8bef\uff0c\u5b58\u5728\u8f66\u95f4\u586b\u5199\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            if (reason.contains("\u5c97\u4f4d\u5de5\u79cd\u4e3a\u7a7a")) {
                checkSource.setReasonStr("\u673a\u6784\u4e0a\u62a5\u6570\u636e\u6709\u8bef\uff0c\u5b58\u5728\u5c97\u4f4d/\u5de5\u79cd\u586b\u5199\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            if (reason.contains("\u5b9a\u5458\u4e3a\u7a7a")) {
                checkSource.setReasonStr("\u673a\u6784\u4e0a\u62a5\u6570\u636e\u6709\u8bef\uff0c\u5b58\u5728\u5b9a\u5458\u586b\u5199\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            if (reason.contains("\u5b9a\u5458\u4e3a0")) {
                checkSource.setReasonStr("\u673a\u6784\u4e0a\u62a5\u6570\u636e\u6709\u8bef\uff0c\u5b58\u5728\u5b9a\u5458\u586b\u5199\u4e3a0\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            if (reason.contains("\u68c0\u6d4b\u70b9\u4e3a\u7a7a")) {
                checkSource.setReasonStr("\u673a\u6784\u4e0a\u62a5\u6570\u636e\u6709\u8bef\uff0c\u5b58\u5728\u68c0\u6d4b\u70b9\u586b\u5199\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            if (reason.contains("\u90e8\u95e8\u8f66\u95f4\u5c97\u4f4d\u76f8\u540c\u4f46\u662f\u4eba\u5458\u4e0d\u540c")) {
                checkSource.setReasonStr("\u673a\u6784\u4e0a\u62a5\u6570\u636e\u6709\u8bef\uff0c\u5b58\u5728\u8f66\u95f4\u5c97\u4f4d\u90fd\u76f8\u540c\u4f46\u5b9a\u5458\u6570\u4e0d\u540c\u7684\u60c5\u51b5\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            if (reason.contains("\u68c0\u6d4b\u7c7b\u578b\u4e3a\u7a7a")) {
                checkSource.setReasonStr("\u673a\u6784\u4e0a\u62a5\u6570\u636e\u6709\u8bef\uff0c\u5b58\u5728\u68c0\u6d4b\u7c7b\u578b\u586b\u5199\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            if (reason.contains("\u68c0\u6d4b\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a")) {
                checkSource.setReasonStr("\u673a\u6784\u4e0a\u62a5\u6570\u636e\u6709\u8bef\uff0c\u5b58\u5728\u68c0\u6d4b\u5f00\u59cb\u65f6\u95f4\u586b\u5199\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            if (reason.contains("\u68c0\u6d4b\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a")) {
                checkSource.setReasonStr("\u673a\u6784\u4e0a\u62a5\u6570\u636e\u6709\u8bef\uff0c\u5b58\u5728\u68c0\u6d4b\u7ed3\u675f\u65f6\u95f4\u586b\u5199\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u673a\u6784\u6838\u5bf9");
                continue;
            }
            checkSource.setReasonStr(reason);
        }
        return list;
    }

    public PageInfo<WandaZywsCheckSource> pageWandaCheckSource(JqGridParam jParam, WandaZywsCheckSource searchVo) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<WandaZywsCheckSource> list = this.getListWandaCheckSource(searchVo);
        return new PageInfo(list);
    }

    public Map<String, Object> getWandaCheckConvertMap() throws UnsupportedEncodingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Date loadTime = this.getMaxBizDate();
        Date busiTime = ((WandaZywsCheckMapper)this.baseMapper).getRiskExposeEvaluateMaxTime();
        JqGridParam jParam = new JqGridParam();
        jParam.setPage(1);
        jParam.setRows(1);
        WandaZywsCheckSource searchVo = new WandaZywsCheckSource().setIsConvertRisk(Integer.valueOf(0)).setIsCanUpdate(Boolean.valueOf(true));
        PageInfo<WandaZywsCheckSource> pageInfo = this.pageWandaCheckSource(jParam, searchVo);
        map.put("loadTime", loadTime);
        map.put("busiTime", busiTime);
        map.put("name", "check");
        map.put("existNoConverted", String.valueOf(CollectionUtils.isNotEmpty((Collection)pageInfo.getList())));
        map.put("isNew", false);
        return map;
    }

    @Transactional
    public void updateCompanyNameRecord(String cids) {
        List cidList = cn.smarthse.common.util.StringUtils.parseToLongList((String)cids);
        ((WandaZywsCheckMapper)this.baseMapper).cleanCompanyNameRecord(cidList, null);
        ((WandaZywsCheckMapper)this.baseMapper).insertCompanyNameRecord(cidList, 1);
        ((WandaZywsCheckMapper)this.baseMapper).insertCompanyNameRecord(cidList, 2);
        ((WandaZywsCheckMapper)this.baseMapper).insertCompanyNameRecord(cidList, 3);
        List<Long> tempIdList = ((WandaZywsCheckMapper)this.baseMapper).selectRepeatCompanyNameRecord(cidList);
        if (CollectionUtils.isNotEmpty(tempIdList)) {
            ((WandaZywsCheckMapper)this.baseMapper).cleanCompanyNameRecord(null, tempIdList);
        }
    }

    public String getWandIsHaveNew(Date loadTime) throws UnsupportedEncodingException {
        JSONObject header;
        Integer records;
        JSONObject request;
        JSONObject root;
        String appkey = "BIZ_037_ZYWS_CHECK";
        String appSecret = "123456ZJ";
        String dateStr = DateUtils.formatDateTime((Date)new Date());
        String sign = DigestUtils.md5Hex((String)(appkey + dateStr + appSecret));
        dateStr = URLEncoder.encode(dateStr, "UTF-8");
        String startStr = DateUtils.formatDateTime((Date)loadTime);
        String endStr = DateUtils.formatDateTime((Date)DateUtils.addDay((Date)loadTime, (int)1));
        Object queryPara = "{\"LOAD_TIME\":\"" + startStr + "," + endStr + "\"}";
        queryPara = URLEncoder.encode((String)queryPara, "UTF-8");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appKey", appkey);
        param.put("strSysDatetime", dateStr);
        param.put("pageNum", "1");
        param.put("pageSize", "1");
        param.put("dataType", "json");
        param.put("queryPara", queryPara);
        param.put("sign", sign);
        String responseText = HttpUtil.doGet((String)this.url, param);
        JSONObject jsonObject = JSONObject.parseObject((String)responseText);
        System.out.println(jsonObject);
        if (jsonObject != null && jsonObject.containsKey((Object)"root") && (root = jsonObject.getJSONObject("root")).containsKey((Object)"request") && (request = root.getJSONObject("request")).containsKey((Object)"header") && (records = (header = request.getJSONObject("header")).getInteger("records")) != null) {
            if (records > 0) {
                return "true";
            }
            return "false";
        }
        return "\u5f02\u5e38";
    }
}

