/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.Convert;
import cn.smarthse.modules.health.enums.hccheckplan.WandOpStateEnum;
import cn.smarthse.services.wanda.api.entity.WandaBaseData;
import cn.smarthse.services.wanda.api.entity.WandaCheckBackPushLog;
import cn.smarthse.services.wanda.api.entity.WandaZywsCheckFactors;
import cn.smarthse.services.wanda.api.entity.WandaZywsCheckTarget;
import cn.smarthse.services.wanda.api.enums.WandCheckBackTypeEnm;
import cn.smarthse.services.wanda.api.service.IWandaCheckBackPushLogService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckFactorsService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckTargetService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaZywsCheckFactorsMapper;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService(timeout=600000)
@Transactional(readOnly=true)
public class WandaZywsCheckFactorsServiceImpl
extends ServiceImpl<WandaZywsCheckFactorsMapper, WandaZywsCheckFactors>
implements IWandaZywsCheckFactorsService {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    protected IdWorker idworker;
    @DubboReference
    private IWandaZywsCheckService wandaZywsCheckService;
    @DubboReference
    private IWandaZywsCheckTargetService checkTargetService;
    @DubboReference
    private IWandaCheckBackPushLogService backPushLogService;

    public Map<String, WandaZywsCheckFactors> getDataMap(List<String> sourceIdList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(WandaBaseData::getIsValid, (Object)true)).in(WandaZywsCheckFactors::getSourceId, sourceIdList)).select(new SFunction[]{WandaZywsCheckFactors::getSourceId, WandaBaseData::getLoadTime, WandaBaseData::getCreateDate}).list().stream().filter(item -> item != null && item.getSourceId() != null && item.getLoadTime() != null).collect(Collectors.toMap(WandaZywsCheckFactors::getSourceId, Function.identity(), (v1, v2) -> v1.getLoadTime().getTime() > v2.getLoadTime().getTime() ? v1 : v2));
    }

    @Transactional(readOnly=false)
    public void inertFactorsInfo(List<WandaZywsCheckFactors> updateList, List<WandaZywsCheckFactors> reslutList, Integer appkeyIndex, Integer pageSize) {
        List<String> deleteSourceIds = updateList.stream().filter(Objects::nonNull).map(WandaZywsCheckFactors::getSourceId).collect(Collectors.toList());
        this.removeFactorAndTargetByColumn(deleteSourceIds, "sourceId", false);
        ArrayList<WandaZywsCheckTarget> targetList = new ArrayList<WandaZywsCheckTarget>();
        ArrayList<WandaZywsCheckFactors> factorAddList = new ArrayList<WandaZywsCheckFactors>();
        for (WandaZywsCheckFactors factor : reslutList) {
            String s;
            if (factor == null) continue;
            factor.setId(Convert.toStr((Object)this.idworker.nextId()));
            factor.setIsValid(Global.TRUE);
            factor.setAppkeyIndex(appkeyIndex);
            factor.setPushNum(Integer.valueOf(0));
            factor.setNeedPull(Byte.valueOf((byte)1));
            this.settingFactorInfo(factor, appkeyIndex);
            if (factor.getFactorId() != null && factor.getFactorId().equals(655L) && StringUtils.isNotBlank((CharSequence)factor.getFactorName()) && (s = cn.smarthse.common.util.StringUtils.toDBC((String)factor.getFactorName())).toLowerCase().equals("\u73af\u6c27\u4e59\u70f7(eo)")) {
                factor.setFactorId(Long.valueOf(127L));
                factor.setFactorName("\u73af\u6c27\u4e59\u70f7");
            }
            Field[] fields = factor.getClass().getDeclaredFields();
            HashMap<String, String> keyMap = new HashMap<String, String>();
            for (Field field : fields) {
                field.setAccessible(true);
                try {
                    TableField exits = field.getAnnotation(TableField.class);
                    if (exits == null || exits.exist()) continue;
                    String name = field.getName();
                    Object o = field.get(factor);
                    if (o == null) continue;
                    keyMap.put(name, o.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Set entries = keyMap.entrySet();
            for (Map.Entry entry : entries) {
                WandaZywsCheckTarget target = new WandaZywsCheckTarget();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                target.setId(Long.valueOf(this.idworker.nextId()));
                target.setFactorsId(factor.getSourceId());
                target.setAttrName(key);
                target.setAttrValue(value);
                target.setCreateDate(new Date());
                target.setUpdateDate(new Date());
                target.setIsValid(Boolean.valueOf(true));
                targetList.add(target);
            }
            factorAddList.add(factor);
            if (factorAddList.size() < pageSize && targetList.size() < pageSize) continue;
            this.saveBatch(factorAddList);
            this.checkTargetService.saveBatch(targetList);
            factorAddList.clear();
            targetList.clear();
        }
        if (factorAddList.size() > 0 || targetList.size() > 0) {
            this.saveBatch(factorAddList);
            this.checkTargetService.saveBatch(targetList);
        }
    }

    public Date getMaxBizDate(Integer appkeyIndex) {
        return ((WandaZywsCheckFactorsMapper)this.baseMapper).getMaxBizDate(appkeyIndex);
    }

    private void settingFactorInfo(WandaZywsCheckFactors factor, Integer appkeyIndex) {
        switch (appkeyIndex) {
            case 1: {
                factor.setItemId(Integer.valueOf(15));
                factor.setFactorName("\u5fae\u5c0f\u6c14\u5019");
                break;
            }
            case 2: {
                factor.setItemId(Integer.valueOf(9));
                factor.setFactorId(Long.valueOf(580L));
                factor.setFactorName("\u8d85\u9ad8\u9891\u8f90\u5c04");
                break;
            }
            case 3: {
                factor.setItemId(Integer.valueOf(3));
                factor.setFactorId(Long.valueOf(567L));
                factor.setFactorName("\u566a\u58f0");
                break;
            }
            case 4: {
                factor.setItemId(Integer.valueOf(7));
                factor.setFactorId(Long.valueOf(575L));
                factor.setFactorName("\u5fae\u6ce2\u8f90\u5c04");
                break;
            }
            case 5: {
                factor.setItemId(Integer.valueOf(12));
                factor.setFactorId(Long.valueOf(573L));
                factor.setFactorName("\u6fc0\u5149\u8f90\u5c04");
                break;
            }
            case 6: {
                factor.setItemId(Integer.valueOf(10));
                factor.setFactorId(Long.valueOf(704L));
                factor.setFactorName("\u7535\u79bb\u8f90\u5c04-\u542b\u6e90\u88c5\u7f6e");
                break;
            }
            case 7: {
                factor.setItemId(Integer.valueOf(10));
                factor.setFactorId(Long.valueOf(704L));
                factor.setFactorName("\u7535\u79bb\u8f90\u5c04-\u542b\u6e90\u88c5\u7f6e");
                break;
            }
            case 8: {
                factor.setItemId(Integer.valueOf(14));
                factor.setFactorName("\u7167\u5ea6");
                break;
            }
            case 9: {
                factor.setItemId(Integer.valueOf(4));
                factor.setFactorId(Long.valueOf(568L));
                factor.setFactorName("\u9ad8\u6e29");
                break;
            }
            case 10: {
                factor.setItemId(Integer.valueOf(8));
                factor.setFactorId(Long.valueOf(579L));
                factor.setFactorName("\u9ad8\u9891\u7535\u78c1\u573a");
                break;
            }
            case 11: {
                factor.setItemId(Integer.valueOf(11));
                factor.setFactorId(Long.valueOf(572L));
                factor.setFactorName("\u624b\u4f20\u632f\u52a8");
                break;
            }
            case 12: {
                factor.setItemId(Integer.valueOf(16));
                factor.setFactorName("\u65b0\u98ce\u91cf");
                break;
            }
            case 13: {
                factor.setItemId(Integer.valueOf(6));
                factor.setFactorId(Long.valueOf(578L));
                factor.setFactorName("\u5de5\u9891\u7535\u573a");
                break;
            }
            case 14: {
                factor.setItemId(Integer.valueOf(2));
                break;
            }
            case 15: {
                factor.setItemId(Integer.valueOf(1));
                break;
            }
            case 16: {
                factor.setItemId(Integer.valueOf(13));
                break;
            }
            case 17: {
                factor.setItemId(Integer.valueOf(17));
                factor.setFactorName("\u63a7\u5236\u98ce\u901f");
                break;
            }
            case 18: {
                factor.setItemId(Integer.valueOf(5));
                factor.setFactorId(Long.valueOf(576L));
                factor.setFactorName("\u7d2b\u5916\u8f90\u5c04");
            }
        }
    }

    @Transactional
    public Map<String, WandaZywsCheckFactors> verifyData(Map<String, WandaZywsCheckFactors> map, String appkey) {
        if (CollectionUtils.isEmpty(map) || CollectionUtils.isEmpty(map.values())) {
            return new HashMap<String, WandaZywsCheckFactors>();
        }
        ArrayList<WandaZywsCheckFactors> list = new ArrayList<WandaZywsCheckFactors>(map.values());
        ArrayList<WandaCheckBackPushLog> pushLogList = new ArrayList<WandaCheckBackPushLog>();
        for (WandaZywsCheckFactors item : list) {
            if (item == null) continue;
            Object reason = "";
            if (StringUtils.isBlank((CharSequence)item.getCheckId())) {
                reason = (String)reason + "\u4e3b\u8868CHECK_ID\u4e3a\u7a7a,";
                item.setCheckId(item.getSourceId());
                map.remove(item.getSourceId());
            }
            if (StringUtils.isBlank((CharSequence)item.getWorkshop())) {
                reason = (String)reason + "\u8f66\u95f4\u540d\u79f0\u4e3a\u7a7a,";
                map.remove(item.getSourceId());
            }
            if (StringUtils.isBlank((CharSequence)item.getWorkName())) {
                reason = (String)reason + "\u5c97\u4f4d\u5de5\u79cd\u4e3a\u7a7a,";
                map.remove(item.getSourceId());
            }
            if (item.getIsRisk() == null) {
                reason = (String)reason + "\u662f\u5426\u4f5c\u4e3a\u5371\u5bb3\u56e0\u7d20\u4e3a\u7a7a,";
                map.remove(item.getSourceId());
            } else {
                if (StringUtils.isBlank((CharSequence)item.getWorkNum()) && item.getIsRisk().booleanValue()) {
                    reason = (String)reason + "\u5b9a\u5458\u4e3a\u7a7a,";
                    map.remove(item.getSourceId());
                }
                if (StringUtils.isNotBlank((CharSequence)item.getWorkNum()) && item.getWorkNum().equals("0") && item.getIsRisk().booleanValue()) {
                    reason = (String)reason + "\u5b9a\u5458\u4e3a0,";
                    map.remove(item.getSourceId());
                }
            }
            if (StringUtils.isBlank((CharSequence)item.getCheckPoint())) {
                reason = (String)reason + "\u68c0\u6d4b\u70b9\u4e3a\u7a7a,";
                map.remove(item.getSourceId());
            }
            if (StringUtils.isBlank((CharSequence)item.getItemOpState())) {
                reason = (String)reason + "item_op_state\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a,";
                map.remove(item.getSourceId());
            }
            if (StringUtils.isBlank((CharSequence)item.getOldItemId())) {
                reason = (String)reason + "\u4fee\u6539/\u5220\u9664\u5bf9\u5e94\u7684\u68c0\u6d4b\u9879id\u4e3a\u7a7a,";
                map.remove(item.getSourceId());
            }
            if (Objects.equals(WandOpStateEnum.ITEM_OP_DELETE.getState(), item.getItemOpState()) && StringUtils.isBlank((CharSequence)item.getOpReason())) {
                reason = (String)reason + "\u5220\u9664\u9879\u4fee\u6539\u539f\u56e0\u4e3a\u7a7a,";
                map.remove(item.getSourceId());
            }
            if (item.getLoadTime() == null) {
                reason = (String)reason + "LOAD_TIME\u4e3a\u7a7a,";
                item.setLoadTime(new Date());
                map.remove(item.getSourceId());
            }
            if (StringUtils.isBlank((CharSequence)reason)) continue;
            WandaCheckBackPushLog log = new WandaCheckBackPushLog();
            log.setCheckId(item.getCheckId());
            log.setReason(appkey + ":" + (String)reason);
            log.setCreateDate(item.getLoadTime());
            pushLogList.add(log);
        }
        Set collect = pushLogList.parallelStream().map(WandaCheckBackPushLog::getCheckId).collect(Collectors.toSet());
        for (WandaZywsCheckFactors factors : list) {
            if (!StringUtils.isNotBlank((CharSequence)factors.getCheckId()) || !collect.contains(factors.getCheckId())) continue;
            map.remove(factors.getSourceId());
        }
        this.backPushLogService.distinctAddPushLog(pushLogList, WandCheckBackTypeEnm.verifySecondary.getCode());
        return map;
    }

    @Transactional
    public Integer removeByColumn(List<String> list, String column, Boolean isLogic) {
        if (CollectionUtils.isEmpty(list) || StringUtils.isBlank((CharSequence)column)) {
            return 0;
        }
        int i = 0;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        switch (column) {
            case "id": {
                if (isLogic.booleanValue()) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(WandaZywsCheckFactors::getId, list)).set(WandaBaseData::getIsValid, (Object)false)).update();
                    break;
                }
                i = ((WandaZywsCheckFactorsMapper)this.baseMapper).delete((Wrapper)wrapper.in(WandaZywsCheckFactors::getId, list));
                break;
            }
            case "sourceId": {
                if (isLogic.booleanValue()) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(WandaZywsCheckFactors::getSourceId, list)).set(WandaBaseData::getIsValid, (Object)false)).update();
                    break;
                }
                i = ((WandaZywsCheckFactorsMapper)this.baseMapper).delete((Wrapper)wrapper.in(WandaZywsCheckFactors::getSourceId, list));
                break;
            }
            case "checkId": {
                if (isLogic.booleanValue()) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(WandaZywsCheckFactors::getCheckId, list)).set(WandaBaseData::getIsValid, (Object)false)).update();
                    break;
                }
                i = ((WandaZywsCheckFactorsMapper)this.baseMapper).delete((Wrapper)wrapper.in(WandaZywsCheckFactors::getCheckId, list));
                break;
            }
        }
        return i;
    }

    @Transactional
    public void removeFactorAndTargetByColumn(List<String> list, String column, Boolean isLogic) {
        if (CollectionUtils.isEmpty(list) || StringUtils.isBlank((CharSequence)column)) {
            return;
        }
        switch (column) {
            case "sourceId": {
                this.checkTargetService.removeByColumn(list, "factorsId", isLogic);
                break;
            }
            case "checkId": {
                List collect = ((LambdaQueryChainWrapper)this.lambdaQuery().in(WandaZywsCheckFactors::getCheckId, list)).select(new SFunction[]{WandaZywsCheckFactors::getSourceId}).list().stream().filter(item -> item != null && item.getSourceId() != null).map(WandaZywsCheckFactors::getSourceId).collect(Collectors.toList());
                this.checkTargetService.removeByColumn(collect, "factorsId", isLogic);
                break;
            }
        }
        this.removeByColumn(list, column, isLogic);
    }
}

