/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.certificate.ApprovalStatusEnum;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffDetailDataSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISyncTrainInfoService;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import cn.smarthse.services.wanda.api.entity.WandaBaseData;
import cn.smarthse.services.wanda.api.entity.WandaTrainData;
import cn.smarthse.services.wanda.api.service.IWandaTrainDataService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaTrainDataMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

@Service(value="wandaTrainDataService")
@DubboService
public class WandaTrainDataServiceImpl
extends ServiceImpl<WandaTrainDataMapper, WandaTrainData>
implements IWandaTrainDataService {
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private TransactionDefinition transactionDefinition;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private ISyncTrainInfoService syncTrainInfoService;

    public List<WandaTrainData> listData(SearchParam searchParam) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(WandaTrainData::getIsValid, (Object)true)).eq(WandaTrainData::getDataSource, (Object)2);
        if (!StringUtil.isEmpty((String)searchParam.getUnifiedSocialCc())) {
            wrapper.eq(WandaTrainData::getStaffComCode, (Object)searchParam.getUnifiedSocialCc());
        }
        return this.list((Wrapper)wrapper);
    }

    public LayUiResponseResult<WandaTrainData> listPage(SearchParam searchParam) {
        PageHelper.startPage((int)searchParam.getPageNum(), (int)searchParam.getPageSize());
        PageInfo pageInfo = new PageInfo(this.listData(searchParam));
        return LayUiResponseResult.success((PageInfo)pageInfo);
    }

    public Date getMaxLoadTime() {
        return ((WandaTrainDataMapper)this.baseMapper).getMaxLoadTime();
    }

    public void saveList(List<WandaTrainData> reslutList) {
        if (CollectionUtil.isEmpty(reslutList)) {
            return;
        }
        Set<String> codes = reslutList.stream().map(WandaTrainData::getStaffComCode).collect(Collectors.toSet());
        if (!CollectionUtil.isEmpty(codes)) {
            List<WandaTrainData> cidCodes = ((WandaTrainDataMapper)this.baseMapper).getCisListByCodes(codes);
            reslutList = reslutList.stream().map(cidCode -> {
                WandaTrainData wandaTrainData = cidCodes.stream().filter(item -> item.getStaffComCode().equalsIgnoreCase(cidCode.getStaffComCode())).findFirst().orElse(null);
                if (Objects.nonNull(wandaTrainData)) {
                    cidCode.setCid(wandaTrainData.getCid());
                }
                return cidCode;
            }).collect(Collectors.toList());
        }
        this.delAndDistinct(reslutList);
        this.saveBatch(reslutList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mitigatingRisks(String staffComCode) {
        List<WandaTrainData> wandaTrainData = this.mitigatingRisksList(staffComCode);
        while (!CollectionUtil.isEmpty(wandaTrainData)) {
            TransactionStatus transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
            try {
                wandaTrainData.stream();
                List details = wandaTrainData.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<WandaTrainData>(Comparator.comparing(WandaTrainData::getSourceId))), ArrayList::new)).stream().map(item -> {
                    CertificateStaffDetail detail = new CertificateStaffDetail();
                    detail.setId(Long.valueOf(IdWorker.getId()));
                    detail.setCertId(Long.valueOf(item.getCertType().longValue()));
                    detail.setValidityDate(item.getCertValidyDate());
                    detail.setStaffName(item.getStaffName());
                    detail.setCertNo(item.getCertNum());
                    detail.setCertCreateDate(item.getCertCreateDate());
                    detail.setCertDownloadUrl(item.getCertDownloadUrl());
                    detail.setCid(item.getCid());
                    detail.setDataSource(Byte.valueOf(CertificateStaffDetailDataSourceEnum.WANDA.getValue().byteValue()));
                    detail.setStatus(ApprovalStatusEnum.NONEEDAPPROVAL.getValue());
                    detail.setCreateDate(new Date());
                    detail.setUpdateDate(new Date());
                    detail.setCreateBy(Long.valueOf(0L));
                    detail.setUpdateBy(Long.valueOf(0L));
                    detail.setIsValid(Boolean.valueOf(true));
                    detail.setSourceId(item.getSourceId());
                    return detail;
                }).collect(Collectors.toList());
                this.syncTrainInfoService.syncBatchCertInfo(details);
                String cids = StringUtil.listToString(details.stream().map(CertificateStaffDetail::getCid).collect(Collectors.toList()), (String)",");
                this.reformItemBasicService.autoAcceptance(cids);
                this.reformItemBasicService.autoGenKeyFactorReform(cids);
                wandaTrainData.forEach(item -> item.setIsUsed(Byte.valueOf((byte)1)));
                this.updateBatchById(wandaTrainData);
                this.dataSourceTransactionManager.commit(transactionStatus);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dataSourceTransactionManager.rollback(transactionStatus);
            }
            finally {
                wandaTrainData = this.mitigatingRisksList(staffComCode);
            }
        }
    }

    private List<ReformItemBasic> doMitigating(WandaTrainData zyfzr, WandaTrainData glry, List<ReformItemBasic> trainReformList) {
        ArrayList<ReformItemBasic> mitigatingList = new ArrayList<ReformItemBasic>();
        if (Objects.nonNull(zyfzr) && Objects.nonNull(glry)) {
            mitigatingList.addAll(trainReformList);
        } else if (Objects.nonNull(zyfzr)) {
            List collect = trainReformList.stream().filter(reformItemBasic -> ReformGenerationSourceEnum.TRAIN.getValue().equals(reformItemBasic.getGenerationSource()) || ReformGenerationSourceEnum.NOZYFZR.getValue().equals(reformItemBasic.getGenerationSource())).collect(Collectors.toList());
            mitigatingList.addAll(collect);
        } else if (Objects.nonNull(glry)) {
            List collect = trainReformList.stream().filter(reformItemBasic -> ReformGenerationSourceEnum.TRAIN.getValue().equals(reformItemBasic.getGenerationSource()) || ReformGenerationSourceEnum.NOGLRY.getValue().equals(reformItemBasic.getGenerationSource())).collect(Collectors.toList());
            mitigatingList.addAll(collect);
        }
        return mitigatingList;
    }

    public List<WandaTrainData> mitigatingRisksList(String staffComCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!StringUtil.isEmpty((String)staffComCode)) {
            wrapper.eq(WandaTrainData::getStaffComCode, (Object)staffComCode);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(WandaTrainData::getDataSource, (Object)2)).eq(WandaTrainData::getIsUsed, (Object)0)).isNotNull(WandaTrainData::getCid)).eq(WandaTrainData::getIsValid, (Object)true)).orderByDesc(WandaBaseData::getLoadTime);
        wrapper.last("limit 0,1000");
        return this.list((Wrapper)wrapper);
    }

    public List<WandaTrainData> listByCertNum(List<String> certNumList) {
        if (CollectionUtils.isEmpty(certNumList)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(WandaTrainData::getDataSource, (Object)2)).in(WandaTrainData::getCertNum, certNumList)).eq(WandaTrainData::getIsValid, (Object)true);
        return this.list((Wrapper)wrapper);
    }

    public List<WandaTrainData> delAndDistinct(List<WandaTrainData> list) {
        Set idSet = list.stream().map(WandaTrainData::getSourceId).collect(Collectors.toSet());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(WandaTrainData::getSourceId, idSet);
        this.remove((Wrapper)wrapper);
        Map collect = list.stream().collect(Collectors.toMap(WandaTrainData::getSourceId, Function.identity(), (c1, c2) -> c1.getLoadTime().compareTo(c2.getLoadTime()) > 0 ? c1 : c2));
        return new ArrayList<WandaTrainData>(collect.values());
    }
}

