/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.services.wanda.api.entity.SodBase;
import cn.smarthse.services.wanda.api.service.IWandaSodBaseService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaSodBaseMapper;
import cn.smarthse.services.wanda.pulldata.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
public class WandaSodBaseServiceImpl
extends BaseServiceImpl<WandaSodBaseMapper, SodBase>
implements IWandaSodBaseService {
    @Transactional(readOnly=false)
    public int batchInsert(List<SodBase> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        for (SodBase card : list) {
            if (card.getId() != null) {
                card.setSourceId(card.getId().toString());
            }
            card.setId(Long.valueOf(this.idworker.nextId()));
            card.setCreateDate(new Date());
            card.setIsValid(Boolean.valueOf(true));
        }
        List<SodBase> addList = this.delAndDistinct(list);
        int i = this.batchUpdateOrInsert(addList, WandaSodBaseMapper.class, (item, mapper) -> mapper.insert(item));
        this.logger.info("\u7591\u4f3c\u804c\u4e1a\u75c5\u8868\u63d2\u5165\u4e86\uff1a{}\u6761\u6570\u636e", (Object)i);
        return i;
    }

    public Date getMaxLoadTime() {
        return ((WandaSodBaseMapper)this.dao).getMaxLoadTime();
    }

    public List<SodBase> delAndDistinct(List<SodBase> list) {
        Set<String> idSet = list.stream().map(SodBase::getSourceId).collect(Collectors.toSet());
        int i = ((WandaSodBaseMapper)this.dao).deleteBatch(idSet);
        this.logger.info("\u7591\u4f3c\u804c\u4e1a\u75c5\u8868\u5220\u9664\uff1a{}\u6761\u6570\u636e", (Object)i);
        Map collect = list.stream().collect(Collectors.toMap(SodBase::getSourceId, Function.identity(), (c1, c2) -> c1.getLoadTime().compareTo(c2.getLoadTime()) > 0 ? c1 : c2));
        return new ArrayList<SodBase>(collect.values());
    }
}

