/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.util.compare.CompareUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.company.service.ICompanyBusinessTableService;
import cn.smarthse.modules.health.param.CompanyBusinessTableParam;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeEnergyEfficiencyVo;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.wanda.api.entity.WandaPullBaseEntity;
import cn.smarthse.services.wanda.api.entity.WandaPullWorkEffect;
import cn.smarthse.services.wanda.api.service.IWandaPullWorkEffectService;
import cn.smarthse.services.wanda.api.service.IWandaZywsPunishInfoService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaPullWorkEffectMapper;
import cn.smarthse.wqyy.provider.supervise.IWqyyActivationProviderToSuperviseService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wandaPullWorkEffectServiceImpl")
public class WandaPullWorkEffectServiceImpl
extends ServiceImpl<WandaPullWorkEffectMapper, WandaPullWorkEffect>
implements IWandaPullWorkEffectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaPullWorkEffectServiceImpl.class);
    @Autowired
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private IWqyyActivationProviderToSuperviseService wqyyService;
    @DubboReference
    private ICompanyGradeV3Service companyGradeV3Service;
    @DubboReference
    private IWandaZywsPunishInfoService wandaZywsPunishInfoService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference
    private ICompanyBusinessTableService companyBusinessTableService;
    @Resource
    private WandaPullWorkEffectMapper wandaPullWorkEffectMapper;

    public void statisticsWorkEffectData() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(WandaPullBaseEntity::getIsValid, (Object)true);
        List<WandaPullWorkEffect> dbAllWorkEffectList = this.wandaPullWorkEffectMapper.selectList((Wrapper)wrapper);
        List<WandaPullWorkEffect> collectWorkEffectList = this.wandaPullWorkEffectMapper.getWorkEffectData();
        Map<Object, Object> dbWorkEffectMap = new HashMap();
        if (CollUtil.isNotEmpty((Collection)dbAllWorkEffectList)) {
            dbWorkEffectMap = dbAllWorkEffectList.stream().collect(Collectors.toMap(WandaPullWorkEffect::getId, Function.identity()));
        }
        ArrayList<WandaPullWorkEffect> needAddList = new ArrayList<WandaPullWorkEffect>();
        ArrayList<WandaPullWorkEffect> needModList = new ArrayList<WandaPullWorkEffect>();
        if (CollUtil.isNotEmpty(collectWorkEffectList)) {
            this.postSetComAvgPickupCount(collectWorkEffectList);
            this.postSetRiskDealRate(collectWorkEffectList);
            this.postSetCheckOrgRateComTrainingRate(collectWorkEffectList);
            Date date = new Date();
            for (WandaPullWorkEffect workEffect : collectWorkEffectList) {
                if (dbWorkEffectMap.containsKey(workEffect.getId())) {
                    WandaPullWorkEffect dbWorkEffectPull = (WandaPullWorkEffect)dbWorkEffectMap.get(workEffect.getId());
                    workEffect.setId(dbWorkEffectPull.getId());
                    if (!this.needPull(dbWorkEffectPull, workEffect)) continue;
                    workEffect.setIsAdd(Boolean.FALSE);
                    workEffect.setIsProc(Integer.valueOf(1));
                    workEffect.setNeedPull(Integer.valueOf(1));
                    workEffect.setUpdateDate(date);
                    needModList.add(workEffect);
                    continue;
                }
                workEffect.setIsAdd(Boolean.TRUE);
                workEffect.setIsProc(Integer.valueOf(1));
                workEffect.setNeedPull(Integer.valueOf(1));
                workEffect.setCreateDate(date);
                workEffect.setUpdateDate(date);
                workEffect.setIsValid(Boolean.TRUE);
                needAddList.add(workEffect);
            }
            int pageSize = 1000;
            if (CollUtil.isNotEmpty(needAddList)) {
                int page = (int)Math.ceil((double)needAddList.size() * 1.0 / (double)pageSize);
                for (int i = 0; i < page; ++i) {
                    List subAddList = needAddList.stream().skip((long)i * (long)pageSize).limit(pageSize).toList();
                    this.saveBatch(subAddList);
                }
            }
            if (CollUtil.isNotEmpty(needModList)) {
                this.updateBatchById(needModList);
            }
            List<Long> needAddRegionIdList = needAddList.stream().map(WandaPullWorkEffect::getId).toList();
            List<Long> needModRegionIdList = needModList.stream().map(WandaPullWorkEffect::getId).toList();
            if (!(dbAllWorkEffectList = dbAllWorkEffectList.stream().filter(e -> !needAddRegionIdList.contains(e.getId())).collect(Collectors.toList())).isEmpty()) {
                dbAllWorkEffectList = dbAllWorkEffectList.stream().filter(e -> !needModRegionIdList.contains(e.getId())).collect(Collectors.toList());
            }
            dbAllWorkEffectList.addAll(needAddList);
            dbAllWorkEffectList.addAll(needModList);
            dbAllWorkEffectList.forEach(e -> e.setLastPullDate(e.getLastPullDate() == null ? date : e.getLastPullDate()));
            List<WandaPullWorkEffect> cityList = dbAllWorkEffectList.stream().filter(e -> e.getAreaLevel() == 2).collect(Collectors.toList());
            List<WandaPullWorkEffect> areaList = dbAllWorkEffectList.stream().filter(e -> e.getAreaLevel() == 3).collect(Collectors.toList());
            WandaPullWorkEffectServiceImpl.setRanking(cityList);
            WandaPullWorkEffectServiceImpl.setRanking(areaList);
            dbAllWorkEffectList.forEach(e -> e.setLastPullDate(Objects.equals(e.getLastPullDate(), date) ? null : e.getLastPullDate()));
            this.updateBatchById(dbAllWorkEffectList);
        }
    }

    private void postSetCheckOrgRateComTrainingRate(List<WandaPullWorkEffect> collectWorkEffectList) {
        List<Long> regionIdList = collectWorkEffectList.stream().map(WandaPullWorkEffect::getAreaId).toList();
        String regionIds = regionIdList.stream().map(String::valueOf).collect(Collectors.joining(","));
        List regionList = this.sysAreaProvideService.getAreaListByIds(regionIds);
        int idx = 1;
        int total = collectWorkEffectList.size();
        for (WandaPullWorkEffect effect : collectWorkEffectList) {
            log.error("\u7edf\u8ba1\u7b2c[{}/{}]\u6279", (Object)idx++, (Object)total);
            Long areaId = effect.getAreaId();
            AreaModel region = regionList.stream().filter(r -> r.getId().equals(areaId)).findFirst().orElse(null);
            if (region == null) continue;
            Byte regionLevel = region.getLevel();
            HomeIndexSearchVo searchVo = this.setHomeIndexSearchVo(areaId, regionLevel, null);
            HomeEnergyEfficiencyVo efficiencyVo = new HomeEnergyEfficiencyVo();
            if (!searchVo.getAreaId().toString().startsWith("33") || searchVo.getAreaLevel().intValue() != 1 && searchVo.getAreaLevel().intValue() != 2) continue;
            if (searchVo.getAreaLevel().intValue() == 1) {
                searchVo.setChooseAreaId(Long.valueOf(330100000000L));
            }
            if (searchVo.getAreaLevel().intValue() == 2) {
                searchVo.setChooseAreaId(searchVo.getAreaId());
            }
            HomeEnergyEfficiencyVo data1 = this.companyGradeV3Service.getCompanyClassifyRate(searchVo, efficiencyVo);
            HomeEnergyEfficiencyVo data2 = this.wandaZywsPunishInfoService.getData2(searchVo, data1);
            HomeEnergyEfficiencyVo data3 = this.certificateStaffDetailService.getCertificateRate(searchVo, data2);
            effect.setComTrainingRate(String.valueOf(new BigDecimal(data3.getRate3()).divide(new BigDecimal(String.valueOf(100)), 4, RoundingMode.HALF_UP)));
        }
    }

    private HomeIndexSearchVo setHomeIndexSearchVo(Long areaId, Byte areaLevel, Boolean isCurrent) {
        HomeIndexSearchVo searchVo = new HomeIndexSearchVo().setAreaId(areaId).setAreaLevel(areaLevel).setIsCurrent(isCurrent).setOrgAreaId(Long.valueOf(330000000000L)).setOrgAreaLevel(Byte.valueOf((byte)1));
        if (searchVo.getAreaId() == null) {
            searchVo.setAreaLevel(Byte.valueOf((byte)1));
            searchVo.setAreaId(Long.valueOf(330000000000L));
            if (Objects.equals(searchVo.getAreaLevel(), (byte)1) || Objects.equals(searchVo.getAreaLevel(), (byte)2)) {
                searchVo.setBelongType(Integer.valueOf(searchVo.getAreaLevel().intValue()));
            } else {
                searchVo.setBelongType(Integer.valueOf(0));
            }
        } else {
            AreaModel areaModel = this.sysAreaProvideService.getAreaById(searchVo.getAreaId());
            if (areaModel != null) {
                searchVo.setAreaLevel(areaModel.getLevel());
                searchVo.setAreaName(areaModel.getAreaName());
                if (Objects.equals(areaModel.getLevel(), (byte)1) || Objects.equals(areaModel.getLevel(), (byte)2)) {
                    searchVo.setBelongType(Integer.valueOf(areaModel.getLevel().intValue()));
                } else {
                    searchVo.setBelongType(Integer.valueOf(0));
                }
            }
        }
        return searchVo;
    }

    public boolean needPull(WandaPullWorkEffect dbWorkEffect, WandaPullWorkEffect collectWorkEffect) {
        CompareUtils compareUtils = new CompareUtils();
        String compare = compareUtils.compare((Object)dbWorkEffect, (Object)collectWorkEffect, Collections.singletonList("id,sourceId,isValid,createBy,createDate,updateBy,updateDate,lastPullDate,needPull,isAdd,isProc"));
        return CharSequenceUtil.isNotBlank((CharSequence)compare);
    }

    private void postSetComAvgPickupCount(List<WandaPullWorkEffect> collectWorkEffectList) {
        List<Long> regionIdList = collectWorkEffectList.stream().map(WandaPullWorkEffect::getAreaId).toList();
        List<WandaPullWorkEffect> pickupCountAvgList = this.wandaPullWorkEffectMapper.getRegionPickupCountAvg(regionIdList);
        if (CollUtil.isNotEmpty(pickupCountAvgList)) {
            Map<Long, Integer> regionPickupCountAvgMap = pickupCountAvgList.stream().collect(Collectors.toMap(WandaPullWorkEffect::getAreaId, WandaPullWorkEffect::getComAvgPickupCount));
            collectWorkEffectList.forEach(e -> e.setComAvgPickupCount(regionPickupCountAvgMap.getOrDefault(e.getAreaId(), 0)));
        }
    }

    private void postSetRiskDealRate(List<WandaPullWorkEffect> collectWorkEffectList) {
        CompanyBusinessTableParam cityParam = new CompanyBusinessTableParam().setRows(Integer.valueOf(999)).setPage(Integer.valueOf(1)).setAreaId(Long.valueOf(330000000000L)).setLevel(Byte.valueOf((byte)1)).setIsCity(Boolean.TRUE).setIsCounty(Boolean.FALSE).setBelongType(Integer.valueOf(1));
        CompanyBusinessTableParam areaParam = new CompanyBusinessTableParam().setRows(Integer.valueOf(999)).setPage(Integer.valueOf(1)).setAreaId(Long.valueOf(330000000000L)).setLevel(Byte.valueOf((byte)1)).setIsCity(Boolean.FALSE).setIsCounty(Boolean.TRUE).setBelongType(Integer.valueOf(1));
        List regionList = Stream.concat(this.companyBusinessTableService.listDataByRiskStatTable(cityParam).stream(), this.companyBusinessTableService.listDataByRiskStatTable(areaParam).stream()).toList();
        collectWorkEffectList.forEach(we -> regionList.stream().filter(r -> Objects.equals(r.getAreaId(), we.getAreaId())).findFirst().ifPresent(r -> we.setRiskDealRate(Convert.toStr((Object)r.getDefuseComRate()))));
    }

    private static void setRanking(List<WandaPullWorkEffect> regionList) {
        List<WandaPullWorkEffect> sorted = WandaPullWorkEffectServiceImpl.getSortedList(regionList);
        for (int i = 0; i < sorted.size(); ++i) {
            sorted.get(i).setSort(Integer.valueOf(sorted.size() - i));
        }
    }

    private static List<WandaPullWorkEffect> getSortedList(List<WandaPullWorkEffect> list) {
        Comparator<WandaPullWorkEffect> comparator = Comparator.comparing(WandaPullWorkEffect::getPortraitFinishScore, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(WandaPullWorkEffect::getRiskDealScore, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(WandaPullWorkEffect::getRiskDealRate, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(WandaPullBaseEntity::getLastPullDate, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(WandaPullWorkEffect::getId);
        return Optional.ofNullable(list).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).sorted(comparator).toList();
    }
}

