/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.compare.CompareUtils;
import cn.smarthse.services.wanda.api.entity.WandaPullBaseEntity;
import cn.smarthse.services.wanda.api.entity.WandaPullEnterprise;
import cn.smarthse.services.wanda.api.service.IWandaPullEnterpriseService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaPullEnterpriseMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wandaPullEnterpriseServiceImpl")
public class WandaPullEnterpriseServiceImpl
extends ServiceImpl<WandaPullEnterpriseMapper, WandaPullEnterprise>
implements IWandaPullEnterpriseService {
    @Autowired
    private WandaPullEnterpriseMapper wandaPullEnterpriseMapper;

    public void statisticsData() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(WandaPullBaseEntity::getIsValid, (Object)true);
        List dbAllCompanyList = this.wandaPullEnterpriseMapper.selectList((Wrapper)wrapper);
        List<WandaPullEnterprise> collectCompanyDataList = this.wandaPullEnterpriseMapper.getEnterpriseData();
        Map<Object, Object> dbCompanyMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dbAllCompanyList)) {
            dbCompanyMap = dbAllCompanyList.stream().collect(Collectors.toMap(WandaPullBaseEntity::getSourceId, v -> v, (a, b) -> a));
        }
        ArrayList<WandaPullEnterprise> addList = new ArrayList<WandaPullEnterprise>();
        ArrayList<WandaPullEnterprise> updateList = new ArrayList<WandaPullEnterprise>();
        if (CollectionUtils.isNotEmpty(collectCompanyDataList)) {
            for (WandaPullEnterprise enterprise : collectCompanyDataList) {
                if (dbCompanyMap.containsKey(enterprise.getSourceId())) {
                    WandaPullEnterprise dbCompanyPull = (WandaPullEnterprise)dbCompanyMap.get(enterprise.getSourceId());
                    enterprise.setId(dbCompanyPull.getId());
                    if (!this.needPull(dbCompanyPull, enterprise)) continue;
                    enterprise.setIsAdd(Boolean.valueOf(false));
                    enterprise.setIsProc(Integer.valueOf(1));
                    enterprise.setNeedPull(Integer.valueOf(1));
                    enterprise.setUpdateDate(new Date());
                    updateList.add(enterprise);
                    continue;
                }
                enterprise.setIsAdd(Boolean.valueOf(true));
                enterprise.setIsProc(Integer.valueOf(1));
                enterprise.setNeedPull(Integer.valueOf(1));
                enterprise.setCreateDate(new Date());
                enterprise.setUpdateDate(new Date());
                enterprise.setIsValid(Global.TRUE);
                addList.add(enterprise);
            }
            int pageSize = 1000;
            if (CollectionUtils.isNotEmpty(addList)) {
                int page = (int)Math.ceil((double)addList.size() * 1.0 / (double)pageSize);
                for (int i = 0; i < page; ++i) {
                    List<WandaPullEnterprise> subAddList = addList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList());
                    for (WandaPullEnterprise enterprise : subAddList) {
                        if (enterprise.getGrade() != null) continue;
                        enterprise.setGrade(Integer.valueOf(0));
                    }
                    this.wandaPullEnterpriseMapper.batchInsert(subAddList);
                }
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                for (WandaPullEnterprise enterprise : updateList) {
                    if (enterprise.getGrade() != null) continue;
                    enterprise.setGrade(Integer.valueOf(0));
                }
                this.updateBatchById(updateList);
            }
        }
    }

    public boolean needPull(WandaPullEnterprise dbCompany, WandaPullEnterprise collectCompany) {
        CompareUtils companyCompareUtils = new CompareUtils();
        String compare = companyCompareUtils.compare((Object)dbCompany, (Object)collectCompany, Arrays.asList("id,sourceId,isValid,createBy,createDate,updateBy,updateDate,lastPullDate,needPull,isAdd,isProc"));
        return StringUtils.isNotBlank((CharSequence)compare);
    }
}

