/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.compare.CompareUtils;
import cn.smarthse.services.wanda.api.entity.WandaPullBaseEntity;
import cn.smarthse.services.wanda.api.entity.WandaPullEntePunish;
import cn.smarthse.services.wanda.api.service.IWandaPullEntePunishService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaPullEntePunishMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wandaPullEntePunishServiceImpl")
public class WandaPullEntePunishServiceImpl
extends ServiceImpl<WandaPullEntePunishMapper, WandaPullEntePunish>
implements IWandaPullEntePunishService {
    @Autowired
    private WandaPullEntePunishMapper wandaPullEntePunishMapper;

    public void statisticsData() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(WandaPullBaseEntity::getIsValid, (Object)true);
        List dbAllEntePunishList = this.wandaPullEntePunishMapper.selectList((Wrapper)wrapper);
        List<WandaPullEntePunish> collectEntePunishDataList = this.wandaPullEntePunishMapper.getEntePunishData();
        Map<Object, Object> dbEntePunishMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dbAllEntePunishList)) {
            dbEntePunishMap = dbAllEntePunishList.stream().distinct().collect(Collectors.groupingBy(WandaPullBaseEntity::getSourceId)).values().stream().flatMap(group -> group.stream().limit(1L)).collect(Collectors.toMap(WandaPullBaseEntity::getSourceId, v -> v));
        }
        ArrayList<WandaPullEntePunish> addList = new ArrayList<WandaPullEntePunish>();
        ArrayList<WandaPullEntePunish> updateList = new ArrayList<WandaPullEntePunish>();
        if (CollectionUtils.isNotEmpty(collectEntePunishDataList)) {
            for (WandaPullEntePunish punish : collectEntePunishDataList) {
                if (dbEntePunishMap.containsKey(punish.getSourceId())) {
                    WandaPullEntePunish p = (WandaPullEntePunish)dbEntePunishMap.get(punish.getSourceId());
                    punish.setId(p.getId());
                    if (!this.needPull(p, punish)) continue;
                    punish.setIsAdd(Boolean.valueOf(false));
                    punish.setIsProc(Integer.valueOf(1));
                    punish.setNeedPull(Integer.valueOf(1));
                    punish.setUpdateDate(new Date());
                    updateList.add(punish);
                    continue;
                }
                punish.setIsAdd(Boolean.valueOf(true));
                punish.setIsProc(Integer.valueOf(1));
                punish.setNeedPull(Integer.valueOf(1));
                punish.setCreateDate(new Date());
                punish.setUpdateDate(new Date());
                punish.setIsValid(Global.TRUE);
                addList.add(punish);
            }
        }
        int pageSize = 1000;
        if (CollectionUtils.isNotEmpty(addList)) {
            int page = (int)Math.ceil((double)addList.size() * 1.0 / (double)pageSize);
            for (int i = 0; i < page; ++i) {
                List<WandaPullEntePunish> subAddList = addList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList());
                this.wandaPullEntePunishMapper.batchInsert(subAddList);
            }
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.updateBatchById(updateList);
        }
    }

    public boolean needPull(WandaPullEntePunish p1, WandaPullEntePunish p2) {
        CompareUtils companyCompareUtils = new CompareUtils();
        String compare = companyCompareUtils.compare((Object)p1, (Object)p2, Arrays.asList("id,sourceId,isValid,createBy,createDate,updateBy,updateDate,lastPullDate,needPull,isAdd,isProc"));
        return StringUtils.isNotBlank((CharSequence)compare);
    }
}

