/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.compare.CompareUtils;
import cn.smarthse.services.wanda.api.entity.WandaPullBaseEntity;
import cn.smarthse.services.wanda.api.entity.WandaPullDrHazard;
import cn.smarthse.services.wanda.api.service.IWandaPullDrHazardService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaPullDrHazardMapper;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wandaPullDrHazardService")
public class WandaPullDrHazardServiceImpl
extends ServiceImpl<WandaPullDrHazardMapper, WandaPullDrHazard>
implements IWandaPullDrHazardService {
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private WandaPullDrHazardMapper wandaPullDrHazardMapper;

    public void statisticsData() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(WandaPullBaseEntity::getIsValid, (Object)true);
        List dbAlldrHazardList = this.wandaPullDrHazardMapper.selectList((Wrapper)wrapper);
        List<WandaPullDrHazard> collectdrHazardDataList = this.wandaPullDrHazardMapper.getDrHazardData();
        Map<Object, Object> dbdrHazardMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dbAlldrHazardList)) {
            dbdrHazardMap = dbAlldrHazardList.stream().collect(Collectors.toMap(WandaPullBaseEntity::getSourceId, v -> v));
        }
        ArrayList<WandaPullDrHazard> addList = new ArrayList<WandaPullDrHazard>();
        ArrayList<WandaPullDrHazard> updateList = new ArrayList<WandaPullDrHazard>();
        if (CollectionUtils.isNotEmpty(collectdrHazardDataList)) {
            for (WandaPullDrHazard drHazard : collectdrHazardDataList) {
                if (dbdrHazardMap.containsKey(drHazard.getSourceId())) {
                    WandaPullDrHazard d = (WandaPullDrHazard)dbdrHazardMap.get(drHazard.getSourceId());
                    drHazard.setId(d.getId());
                    if (!this.needPull(d, drHazard)) continue;
                    drHazard.setIsAdd(Boolean.valueOf(false));
                    drHazard.setIsProc(Integer.valueOf(1));
                    drHazard.setNeedPull(Integer.valueOf(1));
                    drHazard.setUpdateDate(new Date());
                    updateList.add(drHazard);
                    continue;
                }
                drHazard.setId("" + this.idworker.nextId());
                drHazard.setIsAdd(Boolean.valueOf(true));
                drHazard.setIsProc(Integer.valueOf(1));
                drHazard.setNeedPull(Integer.valueOf(1));
                drHazard.setCreateDate(new Date());
                drHazard.setUpdateDate(new Date());
                drHazard.setIsValid(Global.TRUE);
                addList.add(drHazard);
            }
        }
        int pageSize = 1000;
        if (CollectionUtils.isNotEmpty(addList)) {
            int page = (int)Math.ceil((double)addList.size() * 1.0 / (double)pageSize);
            for (int i = 0; i < page; ++i) {
                List<WandaPullDrHazard> subAddList = addList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList());
                this.wandaPullDrHazardMapper.batchInsert(subAddList);
            }
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.updateBatchById(updateList);
        }
    }

    public boolean needPull(WandaPullDrHazard p1, WandaPullDrHazard p2) {
        CompareUtils companyCompareUtils = new CompareUtils();
        String compare = companyCompareUtils.compare((Object)p1, (Object)p2, Arrays.asList("id,sourceId,isValid,createBy,createDate,updateBy,updateDate,lastPullDate,needPull,isAdd,isProc"));
        return StringUtils.isNotBlank((CharSequence)compare);
    }
}

