/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.compare.CompareUtils;
import cn.smarthse.services.wanda.api.entity.WandaPullBaseEntity;
import cn.smarthse.services.wanda.api.entity.WandaPullDetect;
import cn.smarthse.services.wanda.api.service.IWandaPullDetectService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaPullDetectMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wandaPullDetectService")
public class WandaPullDetectServiceImpl
extends ServiceImpl<WandaPullDetectMapper, WandaPullDetect>
implements IWandaPullDetectService {
    @Autowired
    private WandaPullDetectMapper wandaPullDetectMapper;

    public void statisticsData() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(WandaPullBaseEntity::getIsValid, (Object)true);
        List dbAllDetectList = this.wandaPullDetectMapper.selectList((Wrapper)wrapper);
        List<WandaPullDetect> collectDetectDataList = this.wandaPullDetectMapper.getDetectData();
        Map<Object, Object> dbDetectMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dbAllDetectList)) {
            dbDetectMap = dbAllDetectList.stream().collect(Collectors.toMap(WandaPullBaseEntity::getSourceId, v -> v));
        }
        ArrayList<WandaPullDetect> addList = new ArrayList<WandaPullDetect>();
        ArrayList<WandaPullDetect> updateList = new ArrayList<WandaPullDetect>();
        if (CollectionUtils.isNotEmpty(collectDetectDataList)) {
            for (WandaPullDetect detect : collectDetectDataList) {
                if (dbDetectMap.containsKey(detect.getSourceId())) {
                    WandaPullDetect p = (WandaPullDetect)dbDetectMap.get(detect.getSourceId());
                    detect.setId(p.getId());
                    if (!this.needDetectPull(p, detect)) continue;
                    detect.setIsAdd(Boolean.valueOf(false));
                    detect.setIsProc(Integer.valueOf(1));
                    detect.setNeedPull(Integer.valueOf(1));
                    detect.setUpdateDate(new Date());
                    updateList.add(detect);
                    continue;
                }
                detect.setIsAdd(Boolean.valueOf(true));
                detect.setIsProc(Integer.valueOf(1));
                detect.setNeedPull(Integer.valueOf(1));
                detect.setCreateDate(new Date());
                detect.setUpdateDate(new Date());
                detect.setIsValid(Global.TRUE);
                addList.add(detect);
            }
        }
        int pageSize = 1000;
        if (CollectionUtils.isNotEmpty(addList)) {
            int page = (int)Math.ceil((double)addList.size() * 1.0 / (double)pageSize);
            for (int i = 0; i < page; ++i) {
                List<WandaPullDetect> subAddList = addList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList());
                this.wandaPullDetectMapper.batchInsert(subAddList);
            }
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.updateBatchById(updateList);
        }
    }

    public boolean needDetectPull(WandaPullDetect p1, WandaPullDetect p2) {
        CompareUtils companyCompareUtils = new CompareUtils();
        String compare = companyCompareUtils.compare((Object)p1, (Object)p2, Arrays.asList("id,sourceId,isValid,createBy,createDate,updateBy,updateDate,lastPullDate,needPull,isAdd,isProc"));
        return StringUtils.isNotBlank((CharSequence)compare);
    }
}

