/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.services.wanda.api.entity.WandaOdiBase;
import cn.smarthse.services.wanda.api.service.IWandaOdiBaseService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaOdiBaseMapper;
import cn.smarthse.services.wanda.pulldata.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
public class WandaOdiBaseServiceImpl
extends BaseServiceImpl<WandaOdiBaseMapper, WandaOdiBase>
implements IWandaOdiBaseService {
    public Date getMaxBizDate() {
        return ((WandaOdiBaseMapper)this.dao).getMaxBizDate();
    }

    @Transactional(readOnly=false)
    public int batchInsert(List<WandaOdiBase> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        for (WandaOdiBase odi : list) {
            if (odi.getId() != null) {
                odi.setSourceId(odi.getId().toString());
            }
            odi.setId(Long.valueOf(this.idworker.nextId()));
            odi.setCreateDate(new Date());
            odi.setIsValid(Boolean.valueOf(true));
        }
        List<WandaOdiBase> addList = this.delAndDistinct(list);
        int i = this.batchUpdateOrInsert(addList, WandaOdiBaseMapper.class, (item, mapper) -> mapper.insert(item));
        this.logger.info("\u804c\u4e1a\u75c5\u9274\u5b9a\u8868\u63d2\u5165\u4e86\uff1a{}\u6761\u6570\u636e", (Object)i);
        return i;
    }

    public List<WandaOdiBase> delAndDistinct(List<WandaOdiBase> list) {
        Set<String> idSet = list.stream().map(WandaOdiBase::getSourceId).collect(Collectors.toSet());
        int i = ((WandaOdiBaseMapper)this.dao).deleteBatch(idSet);
        this.logger.info("\u804c\u4e1a\u75c5\u9274\u5b9a\u8868\u5220\u9664\uff1a{}\u6761\u6570\u636e", (Object)i);
        Map collect = list.stream().collect(Collectors.toMap(WandaOdiBase::getSourceId, Function.identity(), (c1, c2) -> c1.getLoadTime().compareTo(c2.getLoadTime()) > 0 ? c1 : c2));
        return new ArrayList<WandaOdiBase>(collect.values());
    }
}

