/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.services.wanda.api.entity.WandaLearning;
import cn.smarthse.services.wanda.api.service.IWandaLearningService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaLearningMapper;
import cn.smarthse.services.wanda.pulldata.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
public class WandaLearningServiceImpl
extends BaseServiceImpl<WandaLearningMapper, WandaLearning>
implements IWandaLearningService {
    public Date getMaxBizDate() {
        return ((WandaLearningMapper)this.dao).getMaxBizDate();
    }

    @Transactional(readOnly=false)
    public int batchInsert(List<WandaLearning> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        for (WandaLearning card : list) {
            if (card.getId() != null) {
                card.setSourceId(card.getId().toString());
            }
            card.setId(Long.valueOf(this.idworker.nextId()));
            card.setCreateDate(new Date());
            card.setIsValid(Boolean.valueOf(true));
        }
        List<WandaLearning> addList = this.delAndDistinct(list);
        int i = this.batchUpdateOrInsert(addList, WandaLearningMapper.class, (item, mapper) -> mapper.insert(item));
        this.logger.info("\u804c\u4e1a\u5065\u5eb7\u57f9\u8bad\u8868\u63d2\u5165\u4e86\uff1a{}\u6761\u6570\u636e", (Object)i);
        return i;
    }

    public List<WandaLearning> delAndDistinct(List<WandaLearning> list) {
        Set<String> idSet = list.stream().map(WandaLearning::getSourceId).collect(Collectors.toSet());
        int i = ((WandaLearningMapper)this.dao).deleteBatch(idSet);
        this.logger.info("\u804c\u4e1a\u5065\u5eb7\u57f9\u8bad\u8868\u8868\u5220\u9664\uff1a{}\u6761\u6570\u636e", (Object)i);
        Map collect = list.stream().collect(Collectors.toMap(WandaLearning::getSourceId, Function.identity(), (c1, c2) -> c1.getLoadTime().compareTo(c2.getLoadTime()) > 0 ? c1 : c2));
        return new ArrayList<WandaLearning>(collect.values());
    }
}

