/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.param.WandaSearchParam;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.services.wanda.api.entity.WandaDictValue;
import cn.smarthse.services.wanda.api.entity.WandaHealthCard;
import cn.smarthse.services.wanda.api.model.HealthCardSearchModel;
import cn.smarthse.services.wanda.api.service.IWandaDictionaryService;
import cn.smarthse.services.wanda.api.service.IWandaHealthCardService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaHealthCardMapper;
import cn.smarthse.services.wanda.pulldata.service.impl.BaseServiceImpl;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@DubboService
@Service(value="wandaHealthCardService")
public class WandaHealthCardServiceImpl
extends BaseServiceImpl<WandaHealthCardMapper, WandaHealthCard>
implements IWandaHealthCardService {
    @Autowired
    protected IdWorker idworker;
    public Cache<String, List<WandaDictValue>> healthCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.DAYS).build();
    @Resource
    private IWandaDictionaryService dictionaryService;
    @DubboReference
    @Lazy
    private IReformItemBasicNewService reformItemBasicNewService;

    public Date getMaxLoadTime() {
        return ((WandaHealthCardMapper)this.dao).getMaxLoadTime();
    }

    public void getHealthCache() {
        this.healthCache.invalidateAll();
        this.healthCache.cleanUp();
        this.healthCache.put((Object)"\u6027\u522b\u7f16\u7801", ((WandaHealthCardMapper)this.dao).getDictValue("\u6027\u522b\u7f16\u7801"));
        this.healthCache.put((Object)"\u68c0\u67e5\u7c7b\u578b\u7f16\u7801", ((WandaHealthCardMapper)this.dao).getDictValue("\u68c0\u67e5\u7c7b\u578b\u7f16\u7801"));
        this.healthCache.put((Object)"\u4f53\u68c0\u7c7b\u578b\u7f16\u7801", ((WandaHealthCardMapper)this.dao).getDictValue("\u4f53\u68c0\u7c7b\u578b\u7f16\u7801"));
        this.healthCache.put((Object)"\u4f53\u68c0\u7ed3\u8bba\u7f16\u7801", ((WandaHealthCardMapper)this.dao).getDictValue("\u4f53\u68c0\u7ed3\u8bba\u7f16\u7801"));
        this.healthCache.put((Object)"\u804c\u4e1a\u7981\u5fcc\u75c7\u7f16\u7801", ((WandaHealthCardMapper)this.dao).getDictValue("\u804c\u4e1a\u7981\u5fcc\u75c7\u7f16\u7801"));
        this.healthCache.put((Object)"\u804c\u4e1a\u75c5\u5206\u7c7b\u548c\u76ee\u5f55\u7f16\u7801", ((WandaHealthCardMapper)this.dao).getDictValue("\u804c\u4e1a\u75c5\u5206\u7c7b\u548c\u76ee\u5f55\u7f16\u7801"));
    }

    @Transactional
    public int batchInsert(List<WandaHealthCard> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        List<WandaHealthCard> addList = this.delAndDistinct(list);
        List<String> cardIdList = list.stream().map(WandaHealthCard::getSourceId).distinct().collect(Collectors.toList());
        ((WandaHealthCardMapper)this.dao).copyRepeatedData(cardIdList);
        int i = this.batchUpdateOrInsert(addList, WandaHealthCardMapper.class, (item, mapper) -> mapper.insertOrUpdate((WandaHealthCard)item));
        this.logger.info("\u63d2\u5165\u4e86\uff1a{}\u6761\u6570\u636e", (Object)i);
        return i;
    }

    public List<WandaHealthCard> delAndDistinct(List<WandaHealthCard> list) {
        Set idSet = list.stream().map(WandaHealthCard::getSourceId).collect(Collectors.toSet());
        Map<String, WandaHealthCard> collect = list.stream().collect(Collectors.groupingBy(WandaHealthCard::getSourceId, Collectors.collectingAndThen(Collectors.reducing((c1, c2) -> c1.getLoadTime().compareTo(c2.getLoadTime()) > 1 ? c1 : c2), Optional::get)));
        return new ArrayList<WandaHealthCard>(collect.values());
    }

    private void checkSourceIdExist(List<WandaHealthCard> updateList, List<WandaHealthCard> addList, WandaHealthCard card) {
        List collect = addList.stream().filter(item -> item.getSourceId().equalsIgnoreCase(card.getSourceId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            WandaHealthCard old = (WandaHealthCard)collect.get(0);
            addList.remove(old);
            card.setId(Long.valueOf(this.idworker.nextId()));
            card.setCreateDate(new Date());
            addList.add(card);
        } else {
            WandaHealthCard dbData = this.getWandaHealthCardWithoutConvert(card.getSourceId());
            if (Objects.nonNull(dbData)) {
                card.setUpdateDate(new Date());
                card.setId(dbData.getId());
                updateList.add(card);
            } else {
                card.setId(Long.valueOf(this.idworker.nextId()));
                card.setCreateDate(new Date());
                addList.add(card);
            }
        }
    }

    public WandaHealthCard getUserInfo(String username, String idNum) {
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)idNum)) {
            return null;
        }
        Example example = new Example(WandaHealthCard.class);
        example.createCriteria().andEqualTo("name", (Object)username).andEqualTo("idcardCode", (Object)idNum);
        List list = ((WandaHealthCardMapper)this.dao).selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (WandaHealthCard)list.get(0);
        }
        return null;
    }

    @Transactional
    public int batchInsert2(List<WandaHealthCard> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        List<WandaHealthCard> addList = this.delAndDistinct(list);
        List<WandaHealthCard> newList = this.filterExistingRecords(addList);
        if (CollectionUtils.isEmpty(newList)) {
            this.logger.info("\u6ca1\u6709\u9700\u8981\u65b0\u589e\u7684\u6570\u636e");
            return 0;
        }
        int i = this.batchUpdateOrInsert(newList, WandaHealthCardMapper.class, (item, mapper) -> mapper.insertOnly((WandaHealthCard)item));
        this.logger.info("\u65b0\u589e\u4e86\uff1a{}\u6761\u6570\u636e", (Object)i);
        return i;
    }

    private List<WandaHealthCard> filterExistingRecords(List<WandaHealthCard> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        List<String> sourceIds = list.stream().map(WandaHealthCard::getSourceId).distinct().collect(Collectors.toList());
        List<String> existingSourceIds = ((WandaHealthCardMapper)this.dao).selectExistingSourceIds(sourceIds);
        return list.stream().filter(item -> !existingSourceIds.contains(item.getSourceId())).collect(Collectors.toList());
    }

    public PageInfo<WandaHealthCard> getWandaHealthCardPage(HealthCardSearchModel searchModel) {
        PageHelper.startPage((int)searchModel.getPageNum(), (int)searchModel.getPageSize());
        Example example = new Example(WandaHealthCard.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("idcardCode", (Object)searchModel.getIdcardCode());
        List list = ((WandaHealthCardMapper)this.dao).selectByExample(example);
        list.forEach(item -> this.convertWandaHealthCard((WandaHealthCard)item));
        return new PageInfo(list);
    }

    @Transactional
    public WandaHealthCard getWandaHealthCard(String sourceId) {
        Example example = new Example(WandaHealthCard.class);
        example.createCriteria().andEqualTo("sourceId", (Object)sourceId).andEqualTo("isValid", (Object)true);
        WandaHealthCard wandaHealthCard = (WandaHealthCard)((WandaHealthCardMapper)this.dao).selectOneByExample(example);
        if (wandaHealthCard == null) {
            return null;
        }
        this.convertWandaHealthCard(wandaHealthCard);
        return wandaHealthCard;
    }

    public List<WandaHealthCard> getBySourceIds(Set<String> cardIds) {
        Example example = new Example(WandaHealthCard.class);
        example.createCriteria().andIn("sourceId", cardIds).andEqualTo("isValid", (Object)true);
        return ((WandaHealthCardMapper)this.dao).selectByExample(example);
    }

    public int batchUpdate(List<WandaHealthCard> healthCardList) {
        return this.batchUpdateOrInsert(healthCardList, WandaHealthCardMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
    }

    public List<WandaHealthCard> getByCreditCode(String creditCode) {
        Example example = new Example(WandaHealthCard.class);
        example.createCriteria().andEqualTo("creditCode", (Object)creditCode).andEqualTo("isValid", (Object)true);
        return ((WandaHealthCardMapper)this.dao).selectByExample(example);
    }

    private Boolean hasCondition(WandaSearchParam searchParam) {
        return StringUtils.isNotBlank((CharSequence)searchParam.getKeywords()) || StringUtils.isNotBlank((CharSequence)searchParam.getName());
    }

    public PageInfo<WandaHealthCard> listPage(WandaSearchParam searchParam) {
        PageHelper.startPage((int)searchParam.getPageNum(), (int)searchParam.getPageSize(), (boolean)false);
        List<WandaHealthCard> list = ((WandaHealthCardMapper)this.dao).listPage(searchParam);
        List<String> sourceIdList = list.stream().map(WandaHealthCard::getSourceId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sourceIdList)) {
            List<String> existedCardIds = ((WandaHealthCardMapper)this.dao).selectExistingCardIds(sourceIdList);
            HashSet<String> existedSet = new HashSet<String>(existedCardIds);
            for (WandaHealthCard card : list) {
                if (card.getSourceId() == null || existedSet.contains(card.getSourceId())) continue;
                card.setIsConverted(Byte.valueOf((byte)0));
            }
            List<WandaHealthCard> reasonList = ((WandaHealthCardMapper)this.dao).getReason(sourceIdList);
            Map<String, WandaHealthCard> reasonMap = reasonList.stream().collect(Collectors.toMap(WandaHealthCard::getSourceId, v -> v));
            for (WandaHealthCard wandaHealthCard : list) {
                WandaHealthCard sysReference = reasonMap.get(wandaHealthCard.getSourceId());
                wandaHealthCard.setReason(sysReference.getReason());
                wandaHealthCard.setSysReferenceCompanyName(sysReference.getSysReferenceCompanyName());
                wandaHealthCard.setSysReferenceCreditCode(sysReference.getSysReferenceCreditCode());
                if (wandaHealthCard.getIsConverted() != 0 && StringUtils.isNotBlank((CharSequence)wandaHealthCard.getReason()) && "\u4f01\u4e1a\u540d\u4e0d\u5339\u914d".equalsIgnoreCase(wandaHealthCard.getReason())) {
                    wandaHealthCard.setSysReference("\u8be5\u4fe1\u7528\u4ee3\u7801\u4e0e\u8be5\u4fe1\u7528\u4ee3\u7801\u5728\u6d59\u91cc\u536b\u4f01\u4e2d\u5bf9\u5e94\u7684\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4");
                    continue;
                }
                if (wandaHealthCard.getIsConverted() != 0 && StringUtils.isNotBlank((CharSequence)wandaHealthCard.getReason()) && "\u4f01\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728".equalsIgnoreCase(wandaHealthCard.getReason())) {
                    wandaHealthCard.setSysReferenceCompanyName("/");
                    wandaHealthCard.setSysReferenceCreditCode("/");
                    wandaHealthCard.setSysReference("\u4f01\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    continue;
                }
                wandaHealthCard.setSysReference("\u4f01\u4e1a\u540d\uff1a" + wandaHealthCard.getEmployerNameEmployer() + "\u4fe1\u7528\u4ee3\u7801\uff1a" + wandaHealthCard.getCreditCodeEmployer());
            }
        }
        return new PageInfo(list);
    }

    public Integer listCount(WandaSearchParam searchParam) {
        if (StringUtils.isNotBlank((CharSequence)searchParam.getBodyCheckTypes())) {
            List strings = cn.smarthse.common.util.StringUtils.parseToStringList((String)searchParam.getBodyCheckTypes(), (String)",");
            searchParam.setBodyCheckTypeList(strings);
        }
        return ((WandaHealthCardMapper)this.dao).listCount(searchParam);
    }

    public List<WandaHealthCard> getByCreditCodeIdCard(Set<String> creditCodeSet, Set<String> idCardSet) {
        if (CollectionUtils.isEmpty(creditCodeSet) || CollectionUtils.isEmpty(idCardSet)) {
            return new ArrayList<WandaHealthCard>();
        }
        Set<String> idCardSetEnc = idCardSet.stream().map(SpringEncryptUtils::encrypt).collect(Collectors.toSet());
        return ((WandaHealthCardMapper)this.dao).getByCreditCodeIdCard(creditCodeSet, idCardSetEnc);
    }

    public List<WandaHealthCard> getWorkName(List<String> unifiedSocialCc, List<String> idcards) {
        Example example = new Example(WandaHealthCard.class);
        example.createCriteria().andIn("creditCode", unifiedSocialCc).andIn("idcardCode", idcards).andEqualTo("isValid", (Object)true);
        example.selectProperties(new String[]{"idcardCode", "otherJobName", "jobCode", "creditCode"});
        Map jobMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(9L));
        List<WandaHealthCard> list = this.getListByExample(example);
        for (WandaHealthCard wandaHealthCard : list) {
            if ("99-9999".equals(wandaHealthCard.getJobCode())) continue;
            wandaHealthCard.setOtherJobName((String)jobMap.get(wandaHealthCard.getJobCode()));
        }
        return list;
    }

    @Transactional
    public List<String> resetRepeatedData(List<String> unifiedSocialCcsList) {
        List<PhcPhysicalStaffCheckInfo> delStaff;
        this.logger.info("\u91cd\u7f6e\u9519\u8bef\u4f53\u68c0\u6570\u636e\u5f00\u59cb");
        Example example = new Example(WandaHealthCard.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isRepeated", (Object)1).andNotEqualTo("isConverted", (Object)0);
        if (CollectionUtils.isNotEmpty(unifiedSocialCcsList)) {
            criteria.andIn("creditCodeEmployer", unifiedSocialCcsList);
        }
        example.selectProperties(new String[]{"sourceId"});
        List wandaHealthCardList = this.getListByExample(example);
        if (CollectionUtils.isEmpty(wandaHealthCardList)) {
            return Collections.emptyList();
        }
        List<String> wandaSourceIdList = wandaHealthCardList.stream().map(WandaHealthCard::getSourceId).collect(Collectors.toList());
        List<Long> checkIdList = ((WandaHealthCardMapper)this.dao).queryCheckIdByWandaSourceId(wandaSourceIdList);
        if (CollectionUtils.isEmpty(checkIdList)) {
            return Collections.emptyList();
        }
        List<PhcPhysicalStaffCheckInfo> staffCheckInfoList = ((WandaHealthCardMapper)this.dao).queryStaffCheckInfoByCheckId(checkIdList);
        List<Long> staffCheckIdList = staffCheckInfoList.stream().map(PhcPhysicalStaffCheckInfo::getId).distinct().collect(Collectors.toList());
        List<String> allWandaSourceIdList = staffCheckInfoList.stream().map(PhcPhysicalStaffCheckInfo::getCardId).distinct().collect(Collectors.toList());
        HashMap<String, PhcPhysicalStaffCheckInfo> map = new HashMap<String, PhcPhysicalStaffCheckInfo>();
        for (PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo : staffCheckInfoList) {
            String key = phcPhysicalStaffCheckInfo.getCardId();
            if (map.containsKey(key) || !wandaSourceIdList.contains(key)) continue;
            phcPhysicalStaffCheckInfo.setCreateDate(new Date());
            map.put(key, phcPhysicalStaffCheckInfo);
        }
        ArrayList<PhcPhysicalStaffCheckInfo> delLog = new ArrayList<PhcPhysicalStaffCheckInfo>(map.values());
        ((WandaHealthCardMapper)this.dao).insertBatchLog(delLog);
        ((WandaHealthCardMapper)this.dao).resetWandaHealthCard(allWandaSourceIdList, (byte)0);
        ((WandaHealthCardMapper)this.dao).delCheck(checkIdList);
        ((WandaHealthCardMapper)this.dao).delStaffCheckInfo(staffCheckIdList);
        List idCardList = delLog.stream().map(PhcPhysicalStaffCheckInfo::getIdcardCode).distinct().collect(Collectors.toList());
        List<Long> cidList = delLog.stream().map(PhcPhysicalStaffCheckInfo::getCid).distinct().collect(Collectors.toList());
        List<String> creditCodeEmployerList = delLog.stream().map(PhcPhysicalStaffCheckInfo::getCreditCodeEmployer).distinct().collect(Collectors.toList());
        ArrayList<String> idCardEncs = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idCardList)) {
            for (String idCard : idCardList) {
                String encs = SpringEncryptUtils.encrypt((String)idCard);
                idCardEncs.add(encs);
            }
        }
        if (CollectionUtils.isNotEmpty(delStaff = ((WandaHealthCardMapper)this.dao).queryNeedDelStaff(cidList, idCardEncs))) {
            List<Long> delStaffIdList = delStaff.stream().map(PhcPhysicalStaffCheckInfo::getId).distinct().collect(Collectors.toList());
            ((WandaHealthCardMapper)this.dao).delStaffBasic(delStaffIdList);
            ((WandaHealthCardMapper)this.dao).delStaffInfo(delStaffIdList);
        }
        ((WandaHealthCardMapper)this.dao).delRisk(wandaSourceIdList, cidList);
        ((WandaHealthCardMapper)this.dao).delRiskSource(wandaSourceIdList, cidList);
        this.logger.info("\u91cd\u7f6e\u9519\u8bef\u4f53\u68c0\u6570\u636e\u7ed3\u675f");
        return creditCodeEmployerList;
    }

    public WandaHealthCard getWandaHealthCardWithoutConvert(String sourceId) {
        Example example = new Example(WandaHealthCard.class);
        example.createCriteria().andEqualTo("sourceId", (Object)sourceId).andEqualTo("isValid", (Object)true);
        WandaHealthCard wandaHealthCard = (WandaHealthCard)((WandaHealthCardMapper)this.dao).selectOneByExample(example);
        if (wandaHealthCard == null) {
            return null;
        }
        return wandaHealthCard;
    }

    public WandaHealthCard convertWandaHealthCard(WandaHealthCard wandaHealthCard) {
        String contactHazardCode;
        if (this.healthCache.estimatedSize() == 0L) {
            this.getHealthCache();
        }
        List sexCodeList = (List)this.healthCache.getIfPresent((Object)"\u6027\u522b\u7f16\u7801");
        List checkTypeList = (List)this.healthCache.getIfPresent((Object)"\u68c0\u67e5\u7c7b\u578b\u7f16\u7801");
        List bodyCheckTypeList = (List)this.healthCache.getIfPresent((Object)"\u4f53\u68c0\u7c7b\u578b\u7f16\u7801");
        List conclusionList = (List)this.healthCache.getIfPresent((Object)"\u4f53\u68c0\u7ed3\u8bba\u7f16\u7801");
        List cdtIdList = (List)this.healthCache.getIfPresent((Object)"\u804c\u4e1a\u7981\u5fcc\u75c7\u7f16\u7801");
        List occupationalDiseasesList = (List)this.healthCache.getIfPresent((Object)"\u804c\u4e1a\u75c5\u5206\u7c7b\u548c\u76ee\u5f55\u7f16\u7801");
        if (StringUtils.isNotBlank((CharSequence)wandaHealthCard.getSexCode())) {
            sexCodeList.forEach(item -> {
                if (wandaHealthCard.getSexCode().equals(item.getValue())) {
                    wandaHealthCard.setSexCode(item.getValueLabel());
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)wandaHealthCard.getCheckType())) {
            checkTypeList.forEach(item -> {
                if (wandaHealthCard.getCheckType().equals(item.getValue())) {
                    wandaHealthCard.setCheckType(item.getValueLabel());
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)wandaHealthCard.getBodyCheckType())) {
            bodyCheckTypeList.forEach(item -> {
                if (item.getValue().equals("1")) {
                    item.setValueLabel("\u5c97\u524d\u4f53\u68c0");
                }
                if (item.getValue().equals("2")) {
                    item.setValueLabel("\u5728\u5c97\u4f53\u68c0");
                }
                if (item.getValue().equals("3")) {
                    item.setValueLabel("\u79bb\u5c97\u65f6\u4f53\u68c0");
                }
                if (item.getValue().equals("4")) {
                    item.setValueLabel("\u79bb\u5c97\u540e\u4f53\u68c0");
                }
                if (item.getValue().equals("5")) {
                    item.setValueLabel("\u5e94\u6025\u4f53\u68c0");
                }
                if (wandaHealthCard.getBodyCheckType().equals(item.getValue())) {
                    wandaHealthCard.setBodyCheckType(item.getValueLabel());
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)wandaHealthCard.getConclusion())) {
            conclusionList.forEach(item -> {
                String str;
                if (wandaHealthCard.getConclusion().equals(item.getValue()) && StringUtils.isNotBlank((CharSequence)(str = item.getValueLabel()))) {
                    wandaHealthCard.setConclusion(str.split(":")[0]);
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)wandaHealthCard.getCdtId())) {
            cdtIdList.forEach(item -> {
                if (wandaHealthCard.getCdtId().equals(item.getValue())) {
                    wandaHealthCard.setCdtId(item.getValueLabel());
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)wandaHealthCard.getSptId())) {
            occupationalDiseasesList.forEach(item -> {
                if (wandaHealthCard.getSptId().equals(item.getValue())) {
                    wandaHealthCard.setSptId(item.getValueLabel());
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)(contactHazardCode = wandaHealthCard.getContactHazardCode()))) {
            String hazardNameStr = ((WandaHealthCardMapper)this.dao).getContactHazardCodes(Arrays.asList(contactHazardCode.split(",")));
            wandaHealthCard.setContactHazardCode(hazardNameStr);
        }
        return wandaHealthCard;
    }
}

