/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.services.wanda.api.entity.WandaHcRItems;
import cn.smarthse.services.wanda.api.service.IWandaHcRItemsService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaHcRItemsMapper;
import cn.smarthse.services.wanda.pulldata.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
public class WandaHcRItemsServiceImpl
extends BaseServiceImpl<WandaHcRItemsMapper, WandaHcRItems>
implements IWandaHcRItemsService {
    public Date getMaxBizDate() {
        return ((WandaHcRItemsMapper)this.dao).getMaxBizDate();
    }

    @Transactional(readOnly=false)
    public int batchInsert(List<WandaHcRItems> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        for (WandaHcRItems card : list) {
            card.setId(Long.valueOf(this.idworker.nextId()));
            card.setCreateDate(new Date());
            card.setIsValid(Boolean.valueOf(true));
        }
        List<WandaHcRItems> addList = this.delAndDistinct(list);
        int i = this.batchUpdateOrInsert(addList, WandaHcRItemsMapper.class, (item, mapper) -> mapper.insert(item));
        this.logger.info("\u4f53\u68c0\u590d\u67e5\u9879\u76ee\u8868\u63d2\u5165\u4e86\uff1a{}\u6761\u6570\u636e", (Object)i);
        return i;
    }

    public List<WandaHcRItems> delAndDistinct(List<WandaHcRItems> list) {
        Set<String> idSet = list.stream().map(WandaHcRItems::getSourceId).collect(Collectors.toSet());
        int i = ((WandaHcRItemsMapper)this.dao).deleteBatch(idSet);
        this.logger.info("\u4f53\u68c0\u590d\u67e5\u9879\u76ee\u8868\u5220\u9664\uff1a{}\u6761\u6570\u636e", (Object)i);
        Map collect = list.stream().collect(Collectors.toMap(WandaHcRItems::getSourceId, Function.identity(), (c1, c2) -> c1.getLoadTime().compareTo(c2.getLoadTime()) > 0 ? c1 : c2));
        return new ArrayList<WandaHcRItems>(collect.values());
    }
}

