/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.services.wanda.api.entity.WandaHcItems;
import cn.smarthse.services.wanda.api.service.IWandaHcItemsService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaHcItemsMapper;
import cn.smarthse.services.wanda.pulldata.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
public class WandaHcItemsServiceImpl
extends BaseServiceImpl<WandaHcItemsMapper, WandaHcItems>
implements IWandaHcItemsService {
    public Date getMaxBizDate() {
        return ((WandaHcItemsMapper)this.dao).getMaxBizDate();
    }

    @Transactional(readOnly=false)
    public int batchInsert(List<WandaHcItems> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        for (WandaHcItems card : list) {
            card.setId(Long.valueOf(this.idworker.nextId()));
            card.setCreateDate(new Date());
            card.setIsValid(Boolean.valueOf(true));
        }
        List<WandaHcItems> addList = this.delAndDistinct(list);
        int i = this.batchUpdateOrInsert(addList, WandaHcItemsMapper.class, (item, mapper) -> mapper.insert(item));
        this.logger.info("\u4f53\u68c0\u9879\u76ee\u8868\u63d2\u5165\u4e86\uff1a{}\u6761\u6570\u636e", (Object)i);
        return i;
    }

    public List<String> getItemGroupNameByCardId(String cardId) {
        if (cardId == null) {
            return Collections.emptyList();
        }
        return ((WandaHcItemsMapper)this.dao).getItemGroupNameByCardId(cardId);
    }

    public Set<String> getItemGroupNameByCardIds(Set<String> cardIdSet) {
        if (CollectionUtils.isEmpty(cardIdSet)) {
            return Collections.emptySet();
        }
        return ((WandaHcItemsMapper)this.dao).getItemGroupNameByCardIds(cardIdSet);
    }

    public List<WandaHcItems> delAndDistinct(List<WandaHcItems> list) {
        Set<String> idSet = list.stream().map(WandaHcItems::getSourceId).collect(Collectors.toSet());
        int i = ((WandaHcItemsMapper)this.dao).deleteBatch(idSet);
        this.logger.info("\u4f53\u68c0\u9879\u76ee\u8868\u5220\u9664\u4e86\uff1a{}\u6761\u6570\u636e", (Object)i);
        Map collect = list.stream().collect(Collectors.toMap(WandaHcItems::getSourceId, Function.identity(), (c1, c2) -> c1.getLoadTime().compareTo(c2.getLoadTime()) > 0 ? c1 : c2));
        return new ArrayList<WandaHcItems>(collect.values());
    }
}

