/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.param.WandaErrorSearchParam;
import cn.smarthse.services.wanda.api.entity.WandaHcAbnormal;
import cn.smarthse.services.wanda.api.entity.WandaHcAbnormalByWeek;
import cn.smarthse.services.wanda.api.entity.WandaHealthCard;
import cn.smarthse.services.wanda.api.entity.WandaHealthCardErrorCom;
import cn.smarthse.services.wanda.api.service.IWandaHcAbnormalService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaHcAbnormalMapper;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Transactional(readOnly=true)
@DubboService
public class WandaHcAbnormalImpl
implements IWandaHcAbnormalService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaHcAbnormalImpl.class);
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private WandaHcAbnormalMapper wandaHcAbnormalMapper;
    @Autowired(required=false)
    private DataSourceTransactionManager transactionManager;
    private static final int FIRST_YEAR = 2022;
    private static final int INSERT_BATCH_SIZE = 2000;
    private static final int UPDATE_BATCH_SIZE = 1000;
    private static final int CHECK_BATCH_SIZE = 2000;

    public Date getAbnormalMaxLoadTime() {
        return this.wandaHcAbnormalMapper.getAbnormalMaxLoadTime();
    }

    public List<WandaHcAbnormal> getAbnormalDataByYear(Date start, Date end) {
        List<WandaHcAbnormal> list;
        ArrayList<WandaHcAbnormal> allList = new ArrayList<WandaHcAbnormal>();
        if (start == null) {
            start = this.getAbnormalMaxLoadTime();
        }
        if ((list = this.getAbnormalData(start, end)) == null || CollectionUtils.isEmpty(list)) {
            return allList;
        }
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            int batchSize = 2000;
            for (int i = 0; i < list.size(); i += 2000) {
                int endIdx = Math.min(i + 2000, list.size());
                List<WandaHcAbnormal> subList = list.subList(i, endIdx);
                this.wandaHcAbnormalMapper.insertList2(subList);
            }
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            this.transactionManager.rollback(status);
            throw e;
        }
        allList.addAll(list);
        return allList;
    }

    private List<WandaHcAbnormal> getAbnormalData(Date start, Date end) {
        List<WandaHcAbnormal> list = this.wandaHcAbnormalMapper.getAbnormalData(start, end);
        list.forEach(item -> {
            item.setId(Long.valueOf(this.idworker.nextId()));
            item.setIsValid(Boolean.valueOf(true));
            item.setCreateDate(new Date());
        });
        return list;
    }

    public PageInfo<WandaHcAbnormal> failListData(WandaErrorSearchParam searchParam) {
        PageHelper.startPage((int)searchParam.getPage(), (int)searchParam.getRows());
        List<WandaHcAbnormal> list = this.wandaHcAbnormalMapper.listPage(searchParam);
        return new PageInfo(list);
    }

    public void updateBakDbData(Date start, Date end) {
        long startTime = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u66f4\u65b0\u5907\u4efd\u6570\u636e\u5e93\u6570\u636e...");
        try {
            List<WandaHealthCard> list = this.wandaHcAbnormalMapper.selectErrorData(start, end);
            log.info("\u67e5\u8be2\u5230\u5f02\u5e38\u6570\u636e\u6570\u91cf: {}", (Object)list.size());
            if (list.isEmpty()) {
                log.info("\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u5f02\u5e38\u6570\u636e");
                return;
            }
            List<WandaHealthCardErrorCom> newErrorCompanies = this.extractErrorCompaniesFromList(list);
            log.info("\u63d0\u53d6\u5230\u9519\u8bef\u4f01\u4e1a\u6570\u91cf: {}", (Object)newErrorCompanies.size());
            this.syncDataToBakTable(list);
            this.updateErrorCompanyTables(newErrorCompanies);
            long endTime = System.currentTimeMillis();
            log.info("\u6570\u636e\u66f4\u65b0\u5b8c\u6210\uff0c\u603b\u8017\u65f6: {} \u6beb\u79d2", (Object)(endTime - startTime));
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5907\u4efd\u6570\u636e\u5e93\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u6570\u636e\u66f4\u65b0\u5931\u8d25", e);
        }
    }

    public Date getLastExportTime() {
        return this.wandaHcAbnormalMapper.getLastExportTime();
    }

    @Transactional
    public void addExportLog(Long loginUserId, Date date, Integer batchWeek) {
        this.wandaHcAbnormalMapper.addExportLog(loginUserId, date, batchWeek);
    }

    public PageInfo<WandaHcAbnormalByWeek> failListDataByWeek(WandaErrorSearchParam searchParam) {
        PageHelper.startPage((int)searchParam.getPage(), (int)searchParam.getRows());
        return new PageInfo(this.wandaHcAbnormalMapper.failListDataByWeek(searchParam));
    }

    private void syncDataToBakTable(List<WandaHealthCard> list) {
        log.info("\u5f00\u59cb\u540c\u6b65\u6570\u636e\u5230\u5907\u4efd\u8868\uff0c\u603b\u6570: {}", (Object)list.size());
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        def.setTimeout(1800);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            long checkStart = System.currentTimeMillis();
            Set<Long> existingIds = this.batchQueryExistingIds(list);
            long checkEnd = System.currentTimeMillis();
            log.info("\u67e5\u8be2\u5df2\u5b58\u5728ID\u5b8c\u6210\uff0c\u6570\u91cf: {}, \u8017\u65f6: {} \u6beb\u79d2", (Object)existingIds.size(), (Object)(checkEnd - checkStart));
            ArrayList<WandaHealthCard> insertList = new ArrayList<WandaHealthCard>();
            ArrayList<WandaHealthCard> updateList = new ArrayList<WandaHealthCard>();
            for (WandaHealthCard card : list) {
                if (existingIds.contains(card.getId())) {
                    updateList.add(card);
                    continue;
                }
                insertList.add(card);
            }
            log.info("\u6570\u636e\u5206\u79bb\u5b8c\u6210 - \u9700\u8981\u63d2\u5165: {} \u6761, \u9700\u8981\u66f4\u65b0: {} \u6761", (Object)insertList.size(), (Object)updateList.size());
            if (!insertList.isEmpty()) {
                long insertStart = System.currentTimeMillis();
                this.batchInsertOnly(insertList);
                long insertEnd = System.currentTimeMillis();
                log.info("\u6279\u91cf\u63d2\u5165\u5b8c\u6210\uff0c\u8017\u65f6: {} \u6beb\u79d2", (Object)(insertEnd - insertStart));
            }
            if (!updateList.isEmpty()) {
                long updateStart = System.currentTimeMillis();
                this.batchUpdateOnly(updateList);
                long updateEnd = System.currentTimeMillis();
                log.info("\u6279\u91cf\u66f4\u65b0\u5b8c\u6210\uff0c\u8017\u65f6: {} \u6beb\u79d2", (Object)(updateEnd - updateStart));
            }
            this.transactionManager.commit(status);
            log.info("\u6570\u636e\u540c\u6b65\u4e8b\u52a1\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            this.transactionManager.rollback(status);
            log.error("\u6570\u636e\u540c\u6b65\u5931\u8d25\uff0c\u5df2\u56de\u6eda\u4e8b\u52a1", (Throwable)e);
            throw new RuntimeException("\u6570\u636e\u540c\u6b65\u5931\u8d25", e);
        }
    }

    private Set<Long> batchQueryExistingIds(List<WandaHealthCard> list) {
        HashSet<Long> existingIds = new HashSet<Long>();
        for (int i = 0; i < list.size(); i += 2000) {
            int end = Math.min(i + 2000, list.size());
            List<Long> idBatch = list.subList(i, end).stream().map(WandaHealthCard::getId).collect(Collectors.toList());
            List<Long> existingBatch = this.wandaHcAbnormalMapper.checkExistingIds(idBatch);
            existingIds.addAll(existingBatch);
            log.debug("\u68c0\u67e5\u6279\u6b21 {}-{}, \u5b58\u5728: {} \u6761", new Object[]{i, end, existingBatch.size()});
        }
        return existingIds;
    }

    private void batchInsertOnly(List<WandaHealthCard> insertList) {
        int totalInserted = 0;
        for (int i = 0; i < insertList.size(); i += 2000) {
            int end = Math.min(i + 2000, insertList.size());
            ArrayList<WandaHealthCard> batch = new ArrayList<WandaHealthCard>(insertList.subList(i, end));
            long batchStart = System.currentTimeMillis();
            this.wandaHcAbnormalMapper.batchInsertOnly(batch);
            long batchEnd = System.currentTimeMillis();
            totalInserted += batch.size();
            log.info("\u63d2\u5165\u6279\u6b21 {}-{} \u5b8c\u6210, \u6570\u91cf: {}, \u8017\u65f6: {} \u6beb\u79d2", new Object[]{i, end, batch.size(), batchEnd - batchStart});
            if (i + 2000 >= insertList.size()) continue;
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        log.info("\u6240\u6709\u63d2\u5165\u64cd\u4f5c\u5b8c\u6210\uff0c\u603b\u8ba1: {} \u6761", (Object)totalInserted);
    }

    private void batchUpdateOnly(List<WandaHealthCard> updateList) {
        int totalUpdated = 0;
        for (int i = 0; i < updateList.size(); i += 1000) {
            int end = Math.min(i + 1000, updateList.size());
            ArrayList<WandaHealthCard> batch = new ArrayList<WandaHealthCard>(updateList.subList(i, end));
            long batchStart = System.currentTimeMillis();
            this.wandaHcAbnormalMapper.batchUpdateOnly(batch);
            long batchEnd = System.currentTimeMillis();
            totalUpdated += batch.size();
            log.info("\u66f4\u65b0\u6279\u6b21 {}-{} \u5b8c\u6210, \u6570\u91cf: {}, \u8017\u65f6: {} \u6beb\u79d2", new Object[]{i, end, batch.size(), batchEnd - batchStart});
            if (i + 1000 >= updateList.size()) continue;
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        log.info("\u6240\u6709\u66f4\u65b0\u64cd\u4f5c\u5b8c\u6210\uff0c\u603b\u8ba1: {} \u6761", (Object)totalUpdated);
    }

    private void updateErrorCompanyTables(List<WandaHealthCardErrorCom> newErrorCompanies) {
        log.info("\u5f00\u59cb\u66f4\u65b0\u9519\u8bef\u4f01\u4e1a\u8868...");
        try {
            this.wandaHcAbnormalMapper.delErrorCom();
            log.info("\u5df2\u6e05\u7a7a wanda_health_card_error_com \u8868");
            this.wandaHcAbnormalMapper.inserErrorCom();
            log.info("\u5df2\u91cd\u65b0\u751f\u6210 wanda_health_card_error_com \u8868\u6570\u636e");
            if (!newErrorCompanies.isEmpty()) {
                this.batchInsertErrorCompanies(newErrorCompanies);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u9519\u8bef\u4f01\u4e1a\u8868\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u66f4\u65b0\u9519\u8bef\u4f01\u4e1a\u8868\u5931\u8d25", e);
        }
    }

    private void batchInsertErrorCompanies(List<WandaHealthCardErrorCom> errorCompanies) {
        log.info("\u5f00\u59cb\u6279\u91cf\u63d2\u5165\u9519\u8bef\u4f01\u4e1a\u5386\u53f2\u6570\u636e\uff0c\u6570\u91cf: {}", (Object)errorCompanies.size());
        int errorBatchSize = Math.min(2000, 1000);
        for (int i = 0; i < errorCompanies.size(); i += errorBatchSize) {
            int end = Math.min(i + errorBatchSize, errorCompanies.size());
            List<WandaHealthCardErrorCom> batchList = errorCompanies.subList(i, end);
            try {
                this.wandaHcAbnormalMapper.insertErrorCompanyBatch(batchList);
                log.info("\u9519\u8bef\u4f01\u4e1a\u6279\u6b21 {}-{} \u63d2\u5165\u5b8c\u6210", (Object)i, (Object)end);
                continue;
            }
            catch (Exception e) {
                log.error("\u63d2\u5165\u9519\u8bef\u4f01\u4e1a\u6279\u6b21 {}-{} \u5931\u8d25", new Object[]{i, end, e});
            }
        }
        log.info("\u9519\u8bef\u4f01\u4e1a\u5386\u53f2\u6570\u636e\u63d2\u5165\u5b8c\u6210\uff0c\u603b\u8ba1: {} \u6761", (Object)errorCompanies.size());
    }

    private List<WandaHealthCardErrorCom> extractErrorCompaniesFromList(List<WandaHealthCard> healthCardList) {
        ArrayList<WandaHealthCardErrorCom> errorList = new ArrayList<WandaHealthCardErrorCom>();
        HashSet<CallSite> processedKeys = new HashSet<CallSite>();
        HashSet<String> creditCodes = new HashSet<String>();
        HashSet<String> companyNames = new HashSet<String>();
        for (WandaHealthCard card : healthCardList) {
            String key = card.getCreditCodeEmployer() + "|" + card.getEmployerNameEmployer();
            if (processedKeys.contains(key)) continue;
            processedKeys.add((CallSite)((Object)key));
            if (card.getCreditCodeEmployer() != null && !card.getCreditCodeEmployer().trim().isEmpty()) {
                creditCodes.add(card.getCreditCodeEmployer());
            }
            if (card.getEmployerNameEmployer() == null || card.getEmployerNameEmployer().trim().isEmpty()) continue;
            companyNames.add(card.getEmployerNameEmployer());
        }
        HashMap<String, Company> companyByCreditCode = new HashMap<String, Company>();
        HashMap<String, Company> companyByName = new HashMap<String, Company>();
        if (!creditCodes.isEmpty()) {
            List<Company> companiesByCode = this.wandaHcAbnormalMapper.getCompaniesByCreditCodes(new ArrayList<String>(creditCodes));
            for (Company company : companiesByCode) {
                companyByCreditCode.put(company.getUnifiedSocialCc(), company);
            }
        }
        if (!companyNames.isEmpty()) {
            List<Company> companiesByName = this.wandaHcAbnormalMapper.getCompaniesByNames(new ArrayList<String>(companyNames));
            for (Company company : companiesByName) {
                companyByName.put(company.getName(), company);
            }
        }
        processedKeys.clear();
        for (WandaHealthCard card : healthCardList) {
            String key = card.getCreditCodeEmployer() + "|" + card.getEmployerNameEmployer();
            if (processedKeys.contains(key)) continue;
            processedKeys.add((CallSite)((Object)key));
            Company company = null;
            if (card.getCreditCodeEmployer() != null) {
                company = (Company)companyByCreditCode.get(card.getCreditCodeEmployer());
            }
            if (company != null) {
                if (card.getEmployerNameEmployer().equals(company.getName())) continue;
                errorList.add(new WandaHealthCardErrorCom(card.getCreditCodeEmployer(), card.getEmployerNameEmployer(), Byte.valueOf((byte)1)));
                continue;
            }
            Company companyByNameObj = (Company)companyByName.get(card.getEmployerNameEmployer());
            if (companyByNameObj == null) continue;
            byte errorType = card.getCreditCodeEmployer() != null && !card.getCreditCodeEmployer().trim().isEmpty() ? (byte)2 : 3;
            errorList.add(new WandaHealthCardErrorCom(card.getCreditCodeEmployer(), card.getEmployerNameEmployer(), Byte.valueOf(errorType)));
        }
        return errorList;
    }
}

