/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.services.wanda.api.entity.WandaDictValue;
import cn.smarthse.services.wanda.api.service.IWandaDictionaryService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaDictionaryMapper;
import cn.smarthse.services.wanda.pulldata.service.impl.BaseServiceImpl;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@DubboService(timeout=600000)
public class WandaDictionaryServiceImpl
extends BaseServiceImpl<WandaDictionaryMapper, WandaDictValue>
implements IWandaDictionaryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3);
    public Cache<String, Map<String, String>> dictNameCache = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.DAYS).maximumSize(Integer.MAX_VALUE).build();
    public Cache<Long, Map<String, String>> dictCodeCache = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.DAYS).maximumSize(Integer.MAX_VALUE).build();
    public Cache<String, WandaDictValue> riskFactoryCache = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.DAYS).maximumSize(Integer.MAX_VALUE).build();
    public Cache<String, WandaDictValue> riskReportInfoFactoryCache = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.DAYS).maximumSize(Integer.MAX_VALUE).build();
    public Cache<String, List<HarmFactor>> ownRiskFactoryCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(Integer.MAX_VALUE).build();

    @PostConstruct
    public void init() {
        scheduler.scheduleWithFixedDelay(() -> {
            this.dictNameCache.invalidateAll();
            this.dictNameCache.cleanUp();
            this.dictCodeCache.invalidateAll();
            this.dictCodeCache.cleanUp();
            this.riskFactoryCache.invalidateAll();
            this.riskFactoryCache.cleanUp();
            this.logger.info("WandaDictionaryServiceImpl:\u7f13\u5b58--\u300b\u83b7\u53d6\u6240\u6709\u4e07\u8fbe\u4ed3\u7684\u5b57\u5178...");
            List<WandaDictValue> allDictValue = ((WandaDictionaryMapper)this.dao).getAllDictValue();
            Map<String, List<WandaDictValue>> dictName = allDictValue.stream().collect(Collectors.groupingBy(WandaDictValue::getName));
            dictName.forEach((k, v) -> {
                Map<String, String> collect = v.stream().collect(Collectors.toMap(WandaDictValue::getValue, WandaDictValue::getValueLabel, (n, o) -> n));
                this.dictNameCache.put(k, collect);
            });
            Map<Long, List<WandaDictValue>> dictCode = allDictValue.stream().collect(Collectors.groupingBy(WandaDictValue::getTypeId));
            dictCode.forEach((k, v) -> {
                Map<String, String> collect = v.stream().collect(Collectors.toMap(WandaDictValue::getValue, WandaDictValue::getValueLabel, (n, o) -> n));
                this.dictCodeCache.put(k, collect);
            });
            Map<String, WandaDictValue> allRiskFactor = ((WandaDictionaryMapper)this.dao).getAllWandRiskFactor();
            this.riskFactoryCache.putAll(allRiskFactor);
            this.logger.info("WandaDictionaryServiceImpl::\u7f13\u5b58--\u300b\u83b7\u53d6\u6240\u6709\u4e07\u8fbe\u4ed3\u7684\u5b57\u5178\u5b8c\u6210");
        }, 0L, 1L, TimeUnit.DAYS);
    }

    public Map<String, String> getDictValueByNameCache(String typeName) {
        Map<String, String> dictValueByName;
        if (StringUtils.isBlank((CharSequence)typeName)) {
            return null;
        }
        Map<String, String> wandaDictValueMap = (Map<String, String>)this.dictNameCache.getIfPresent((Object)typeName);
        if (CollectionUtils.isEmpty((Map)wandaDictValueMap) && CollectionUtils.isNotEmpty(dictValueByName = ((WandaDictionaryMapper)this.dao).getDictValueByName(Collections.singletonList(typeName)))) {
            this.dictNameCache.put((Object)typeName, dictValueByName);
            wandaDictValueMap = dictValueByName;
        }
        return wandaDictValueMap;
    }

    public Map<String, String> getDictValueByCodeCache(Long code) {
        Map<String, String> dictValueByCode;
        if (code == null) {
            return null;
        }
        Map<String, String> wandaDictValueList = (Map<String, String>)this.dictCodeCache.getIfPresent((Object)code);
        if (CollectionUtils.isEmpty((Map)wandaDictValueList) && CollectionUtils.isNotEmpty(dictValueByCode = ((WandaDictionaryMapper)this.dao).getDictValueByCode(Collections.singletonList(code)))) {
            this.dictCodeCache.put((Object)code, dictValueByCode);
            wandaDictValueList = dictValueByCode;
        }
        return wandaDictValueList;
    }

    public Map<Long, Map<String, String>> getDictValueByCodesCache(List<Long> codeList) {
        HashMap<Long, Map<String, String>> map = new HashMap<Long, Map<String, String>>();
        for (Long code : codeList) {
            Map<String, String> wandaDictValueMap = this.getDictValueByCodeCache(code);
            map.put(code, wandaDictValueMap);
        }
        return map;
    }

    public Map<String, Map<String, String>> getDictValueByNamesCache(List<String> typeNameList) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (String typeName : typeNameList) {
            Map<String, String> wandaDictValueMap = this.getDictValueByNameCache(typeName);
            map.put(typeName, wandaDictValueMap);
        }
        return map;
    }

    public Map<String, WandaDictValue> getAllWandRiskFactorByCache() {
        if (this.riskFactoryCache.estimatedSize() == 0L) {
            this.riskFactoryCache.invalidateAll();
            this.riskFactoryCache.cleanUp();
            Map<String, WandaDictValue> allRiskFactor = ((WandaDictionaryMapper)this.dao).getAllWandRiskFactor();
            this.riskFactoryCache.putAll(allRiskFactor);
        }
        ConcurrentMap riskFactoryMap = this.riskFactoryCache.asMap();
        return riskFactoryMap;
    }

    public Map<String, WandaDictValue> getAllWandZywsReportRiskFactorByCache() {
        if (this.riskReportInfoFactoryCache.estimatedSize() == 0L) {
            this.riskReportInfoFactoryCache.invalidateAll();
            this.riskReportInfoFactoryCache.cleanUp();
            Map<String, WandaDictValue> allReportRiskFactor = ((WandaDictionaryMapper)this.dao).getAllWandZywsReportRiskFactorByCache();
            this.riskReportInfoFactoryCache.putAll(allReportRiskFactor);
        }
        return this.riskReportInfoFactoryCache.asMap();
    }

    public List<HarmFactor> getOwnHarmFactorList(Long cid) {
        List<HarmFactor> harmFactorList;
        if (this.ownRiskFactoryCache.estimatedSize() == 0L) {
            this.ownRiskFactoryCache.invalidateAll();
            this.ownRiskFactoryCache.cleanUp();
            List<HarmFactor> ownHarmFactorList = ((WandaDictionaryMapper)this.dao).getOwnHarmFactorList(cid);
            this.ownRiskFactoryCache.put((Object)"harmFactorList", ownHarmFactorList);
        }
        if (CollectionUtils.isEmpty((Collection)(harmFactorList = (List<HarmFactor>)this.ownRiskFactoryCache.getIfPresent((Object)"harmFactorList")))) {
            harmFactorList = ((WandaDictionaryMapper)this.dao).getOwnHarmFactorList(cid);
            this.ownRiskFactoryCache.put((Object)"harmFactorList", harmFactorList);
        }
        return harmFactorList;
    }

    public String getContactHazardCodes(List<String> codeList) {
        return ((WandaDictionaryMapper)this.dao).getContactHazardCodes(codeList);
    }
}

